/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.pageserializer.kryo2;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import de.javakaffee.kryoserializers.ArraysAsListSerializer;
import de.javakaffee.kryoserializers.CollectionsEmptyListSerializer;
import de.javakaffee.kryoserializers.CollectionsEmptyMapSerializer;
import de.javakaffee.kryoserializers.CollectionsEmptySetSerializer;
import de.javakaffee.kryoserializers.CollectionsSingletonListSerializer;
import de.javakaffee.kryoserializers.CollectionsSingletonMapSerializer;
import de.javakaffee.kryoserializers.CollectionsSingletonSetSerializer;
import de.javakaffee.kryoserializers.GregorianCalendarSerializer;
import de.javakaffee.kryoserializers.JdkProxySerializer;
import de.javakaffee.kryoserializers.KryoReflectionFactorySupport;
import de.javakaffee.kryoserializers.SynchronizedCollectionsSerializer;
import de.javakaffee.kryoserializers.UnmodifiableCollectionsSerializer;
import de.javakaffee.kryoserializers.cglib.CGLibProxySerializer;
import java.lang.reflect.InvocationHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.GregorianCalendar;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoSerializer
implements ISerializer {
    private static final Logger LOG = LoggerFactory.getLogger(KryoSerializer.class);
    private static final Bytes DEFAULT_BUFFER_SIZE = Bytes.megabytes((long)10L);
    private final Bytes bufferSize;
    private ThreadLocal<Kryo> kryo = new ThreadLocal();

    public KryoSerializer() {
        this(DEFAULT_BUFFER_SIZE);
    }

    public KryoSerializer(Bytes bufferSize) {
        this.bufferSize = (Bytes)Args.notNull((Object)bufferSize, (String)"bufferSize");
        LOG.debug("Buffer size: '{}'", (Object)bufferSize);
    }

    protected Kryo createKryo() {
        return new KryoReflectionFactorySupport();
    }

    protected Kryo getKryo() {
        if (this.kryo.get() == null) {
            Kryo kryo = this.createKryo();
            this.internalInit(kryo);
            this.kryo.set(kryo);
        }
        return this.kryo.get();
    }

    /*
     * Loose catch block
     */
    public byte[] serialize(Object object) {
        LOG.debug("Going to serialize: '{}'", object);
        try {
            try (Output buffer = this.getBuffer(object);){
                this.getKryo().writeClassAndObject(buffer, object);
                byte[] data = buffer.toBytes();
                if (data == null) {
                    LOG.error("Kryo wasn't able to serialize: '{}'", object);
                }
                buffer.reset();
                byte[] byArray = data;
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            System.runFinalization();
        }
    }

    public Object deserialize(byte[] data) {
        Input buffer = new Input(data);
        Object object = this.getKryo().readClassAndObject(buffer);
        LOG.debug("Deserialized: '{}'", object);
        buffer = null;
        System.runFinalization();
        return object;
    }

    protected Output getBuffer(Object target) {
        return new Output((int)this.bufferSize.bytes());
    }

    private void internalInit(Kryo kryo) {
        kryo.register(Arrays.asList("").getClass(), (Serializer)new ArraysAsListSerializer());
        kryo.register(Class.class, (Serializer)new DefaultSerializers.ClassSerializer());
        kryo.register(Collections.EMPTY_LIST.getClass(), (Serializer)new CollectionsEmptyListSerializer());
        kryo.register(Collections.EMPTY_MAP.getClass(), (Serializer)new CollectionsEmptyMapSerializer());
        kryo.register(Collections.EMPTY_SET.getClass(), (Serializer)new CollectionsEmptySetSerializer());
        kryo.register(Collections.singletonList("").getClass(), (Serializer)new CollectionsSingletonListSerializer());
        kryo.register(Collections.singleton("").getClass(), (Serializer)new CollectionsSingletonSetSerializer());
        kryo.register(Collections.singletonMap("", "").getClass(), (Serializer)new CollectionsSingletonMapSerializer());
        kryo.register(Currency.class, (Serializer)new DefaultSerializers.CurrencySerializer());
        kryo.register(GregorianCalendar.class, (Serializer)new GregorianCalendarSerializer());
        kryo.register(InvocationHandler.class, (Serializer)new JdkProxySerializer());
        kryo.register(StringBuffer.class, (Serializer)new DefaultSerializers.StringBufferSerializer());
        kryo.register(StringBuilder.class, (Serializer)new DefaultSerializers.StringBuilderSerializer());
        UnmodifiableCollectionsSerializer.registerSerializers((Kryo)kryo);
        SynchronizedCollectionsSerializer.registerSerializers((Kryo)kryo);
        kryo.register(CGLibProxySerializer.CGLibProxyMarker.class, (Serializer)new CGLibProxySerializer());
        kryo.register(InvocationHandler.class, (Serializer)new JdkProxySerializer());
        kryo.setRegistrationRequired(false);
        kryo.register(Panel.class);
        kryo.register(WebPage.class);
        kryo.register(WebMarkupContainer.class);
        kryo.register(Link.class);
        kryo.register(Label.class);
        kryo.register(ListView.class);
        this.init(kryo);
    }

    protected void init(Kryo kryo) {
    }
}

