/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.pageserializer.kryo2.inspecting;

import com.esotericsoftware.kryo.Kryo;
import org.apache.wicket.util.lang.Bytes;
import org.wicketstuff.pageserializer.common.listener.ISerializationListener;
import org.wicketstuff.pageserializer.kryo2.KryoSerializer;
import org.wicketstuff.pageserializer.kryo2.inspecting.InspectingKryo;

public class InspectingKryoSerializer
extends KryoSerializer {
    private final ISerializationListener serializingListener;

    public InspectingKryoSerializer(Bytes size, ISerializationListener serializingListener) {
        super(size);
        this.serializingListener = serializingListener;
    }

    @Override
    protected Kryo createKryo() {
        return new InspectingKryo(this);
    }

    @Override
    public byte[] serialize(Object object) {
        byte[] ret;
        RuntimeException exceptionIfAny = null;
        try {
            this.serializingListener.begin(object);
            ret = super.serialize(object);
        }
        catch (RuntimeException ex) {
            exceptionIfAny = ex;
            throw ex;
        }
        finally {
            this.serializingListener.end(object, (Exception)exceptionIfAny);
        }
        return ret;
    }

    protected final ISerializationListener serializingListener() {
        return this.serializingListener;
    }
}

