/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wicket.mount.secure.processor;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.wicketstuff.wicket.mount.core.annotation.MountPath;
import org.wicketstuff.wicket.mount.core.processor.AbstractAutoMountAnnotationProcessor;
import org.wicketstuff.wicket.mount.core.processor.AutoMountContext;
import org.wicketstuff.wicket.servlet3.auth.annotation.SecureAutoMount;

@SupportedAnnotationTypes(value={"org.wicketstuff.wicket.servlet3.auth.annotation.SecureAutoMount", "org.wicketstuff.wicket.mount.annotation.MountPoint"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class SecureMountAnnotationProcessor
extends AbstractAutoMountAnnotationProcessor {
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            for (Element element : roundEnv.getElementsAnnotatedWith(SecureAutoMount.class)) {
                AuthorizeInstantiation mp;
                AutoMountContext context = this.getAutoMountContext(element, SecureAutoMount.class);
                if (context == null) continue;
                for (Element element2 : roundEnv.getElementsAnnotatedWith(AuthorizeInstantiation.class)) {
                    mp = element2.getAnnotation(AuthorizeInstantiation.class);
                    this.processMountPoint(context, element2, (Annotation)mp);
                }
                for (Element element3 : roundEnv.getElementsAnnotatedWith(MountPath.class)) {
                    mp = element3.getAnnotation(MountPath.class);
                    this.processMountPoint(context, element3, (Annotation)mp);
                }
                this.generateSource(context);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SecureMountAnnotationProcessor.class.getName()).log(Level.SEVERE, null, ex);
        }
        return true;
    }

    protected String getDefaultRootPath(AutoMountContext context, TypeElement elem) {
        SecureAutoMount auto = (SecureAutoMount)context.getAppAnnotation(SecureAutoMount.class);
        if (auto == null) {
            return "";
        }
        if (this.isSecureElement(elem)) {
            return auto.secureRoot().replaceAll("^/+|/+$", "");
        }
        return auto.defaultRoot().replaceAll("^/+|/+$", "");
    }

    protected void setPackagesToScan(AutoMountContext context) {
        SecureAutoMount annotation = (SecureAutoMount)context.getAppAnnotation(SecureAutoMount.class);
        String[] packagesToScan = annotation != null ? annotation.packagesToScan() : new String[]{};
        if (packagesToScan.length == 0) {
            context.addPackageToScan(context.getApplicationPackage().getQualifiedName().toString() + ".*");
        } else {
            context.addPackagesToScan(packagesToScan);
        }
    }

    protected String getDefaultMimeExtension(AutoMountContext context, TypeElement elem) {
        Object mimeExtension = "";
        SecureAutoMount annotation = (SecureAutoMount)context.getAppAnnotation(SecureAutoMount.class);
        if (annotation != null) {
            mimeExtension = this.isSecureElement(elem) ? annotation.secureMimeExtension() : annotation.defaultMimeExtension();
        }
        if (!((String)mimeExtension).isEmpty() && !((String)mimeExtension).startsWith(".")) {
            mimeExtension = "." + (String)mimeExtension;
        }
        return mimeExtension;
    }

    private boolean isSecureElement(TypeElement elem) {
        if (elem.getAnnotation(AuthorizeInstantiation.class) != null) {
            return true;
        }
        return elem.getEnclosingElement().getAnnotation(AuthorizeInstantiation.class) != null;
    }
}

