/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wicket.servlet3.auth;

import org.apache.wicket.Component;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.IUnauthorizedComponentInstantiationListener;
import org.apache.wicket.authroles.authentication.AbstractAuthenticatedWebSession;
import org.apache.wicket.authroles.authentication.AuthenticatedWebApplication;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPageClassRequestHandler;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.wicket.mount.core.AutoMounter;
import org.wicketstuff.wicket.mount.core.annotation.MountPath;
import org.wicketstuff.wicket.servlet3.auth.ServletContainerAuthenticatedWebSession;
import org.wicketstuff.wicket.servlet3.auth.annotation.SecureAutoMount;

@SecureAutoMount
public abstract class ServletContainerAuthenticatedWebApplication
extends AuthenticatedWebApplication {
    private static final Logger LOG = LoggerFactory.getLogger(ServletContainerAuthenticatedWebApplication.class);

    protected void init() {
        super.init();
        ContainerSecurityInterceptorListener listener = new ContainerSecurityInterceptorListener();
        this.getSecuritySettings().setUnauthorizedComponentInstantiationListener((IUnauthorizedComponentInstantiationListener)listener);
        this.getRequestCycleListeners().add((Object)listener);
        this.autoMountPages();
    }

    protected boolean autoMountPages() {
        MountPath mp;
        Class authPage;
        boolean mountOk = AutoMounter.mountAll((WebApplication)this);
        if (!mountOk) {
            LOG.warn("Unable to Automount pages.");
        }
        if ((authPage = this.getSignInPageClass()) != null && (mp = authPage.getAnnotation(MountPath.class)) == null) {
            Object mime;
            SecureAutoMount annot = ((Object)((Object)this)).getClass().getAnnotation(SecureAutoMount.class);
            Object root = annot.defaultRoot().trim();
            if (!((String)root).isEmpty() && !((String)root).endsWith("/")) {
                root = (String)root + "/";
            }
            if (!((String)(mime = annot.defaultMimeExtension().trim())).isEmpty() && !((String)mime).startsWith(".")) {
                mime = "." + (String)mime;
            }
            String loginPagePath = (String)root + "login" + (String)mime;
            LOG.info("Mounting SignInPageClass: {} to path {}", (Object)authPage, (Object)loginPagePath);
            this.mountPage(loginPagePath, authPage);
        }
        return mountOk;
    }

    protected final Class<? extends AbstractAuthenticatedWebSession> getWebSessionClass() {
        return this.getContainerManagedWebSessionClass();
    }

    protected abstract Class<? extends ServletContainerAuthenticatedWebSession> getContainerManagedWebSessionClass();

    private class ContainerSecurityInterceptorListener
    implements IRequestCycleListener,
    IUnauthorizedComponentInstantiationListener {
        private ContainerSecurityInterceptorListener() {
        }

        public void onRequestHandlerScheduled(RequestCycle cycle, IRequestHandler handler) {
            if (handler instanceof IPageClassRequestHandler) {
                IPageClassRequestHandler classHandler = (IPageClassRequestHandler)handler;
                Class pgClass = classHandler.getPageClass();
                boolean authorized = ServletContainerAuthenticatedWebApplication.this.getSecuritySettings().getAuthorizationStrategy().isInstantiationAuthorized(pgClass);
                if (!authorized && !ServletContainerAuthenticatedWebSession.get().isSignedIn()) {
                    PageParameters pp = classHandler.getPageParameters();
                    throw new RestartResponseAtInterceptPageException(pgClass, pp);
                }
            }
        }

        public void onUnauthorizedInstantiation(Component component) {
            if (!AbstractAuthenticatedWebSession.get().isSignedIn()) {
                MetaDataRoleAuthorizationStrategy.unauthorizeAll((Component)component, (Action)Component.RENDER);
            } else {
                ServletContainerAuthenticatedWebApplication.this.onUnauthorizedInstantiation(component);
            }
        }
    }
}

