/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wicket.servlet3.auth;

import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Session;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.wicketstuff.wicket.servlet3.auth.UserPrincipalRoles;

public class ServletContainerAuthenticatedWebSession
extends AuthenticatedWebSession {
    private static final long serialVersionUID = 1L;

    public static ServletContainerAuthenticatedWebSession get() {
        return (ServletContainerAuthenticatedWebSession)Session.get();
    }

    public ServletContainerAuthenticatedWebSession(Request request) {
        super(request);
    }

    public static String getUserName() {
        Principal principal = ServletContainerAuthenticatedWebSession.getRequest().getUserPrincipal();
        if (principal == null) {
            return null;
        }
        return principal.getName();
    }

    public final Roles getRoles() {
        if (this.isSignedIn()) {
            return new UserPrincipalRoles();
        }
        return null;
    }

    public final void signOut() {
        this.signIn(false);
        if (ServletContainerAuthenticatedWebSession.getRequest().getUserPrincipal() != null) {
            try {
                ServletContainerAuthenticatedWebSession.getRequest().logout();
            }
            catch (ServletException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public boolean authenticate(String username, String password) {
        try {
            if (ServletContainerAuthenticatedWebSession.getRequest().getUserPrincipal() != null) {
                this.signOut();
            }
            ServletContainerAuthenticatedWebSession.getRequest().login(username, password);
            return true;
        }
        catch (ServletException ex) {
            return false;
        }
    }

    private static HttpServletRequest getRequest() {
        return (HttpServletRequest)RequestCycle.get().getRequest().getContainerRequest();
    }
}

