/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.simile.timeline;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.wicketstuff.simile.timeline.ITimelineEvent;

public class TimelineEventModel
implements ITimelineEvent {
    private static final long serialVersionUID = 1L;
    private final DateFormat dateFormat = new SimpleDateFormat("MMM dd yyyy");
    private String title;
    private Date start;
    private Date end;
    private String link;
    private String color;
    private boolean isDuration;
    private String text;
    private String caption;

    public TimelineEventModel(String title, String caption, Date start, Date end, String link, boolean isDuration) {
        if (start == null) {
            throw new IllegalStateException("Start should not be null");
        }
        this.title = title;
        this.start = start;
        this.end = end;
        this.link = link;
        this.isDuration = isDuration;
        this.caption = caption;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getStartFormatted() {
        return this.dateFormat.format(this.start);
    }

    public String getEndFormatted() {
        return this.dateFormat.format(this.end);
    }

    public boolean isDuration() {
        return this.isDuration;
    }

    public void setDuration(boolean isDuration) {
        this.isDuration = isDuration;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }
}

