Timeline.SpanHighlightDecorator=function(a){this._unit=("unit" in a)?a.unit:SimileAjax.NativeDateUnit;
this._startDate=(typeof a.startDate=="string")?this._unit.parseFromObject(a.startDate):a.startDate;
this._endDate=(typeof a.endDate=="string")?this._unit.parseFromObject(a.endDate):a.endDate;
this._startLabel=a.startLabel;
this._endLabel=a.endLabel;
this._color=a.color;
this._cssClass=("cssClass" in a)?a.cssClass:null;
this._opacity=("opacity" in a)?a.opacity:100
};
Timeline.SpanHighlightDecorator.prototype.initialize=function(b,a){this._band=b;
this._timeline=a;
this._layerDiv=null
};
Timeline.SpanHighlightDecorator.prototype.paint=function(){if(this._layerDiv!=null){this._band.removeLayerDiv(this._layerDiv)
}this._layerDiv=this._band.createLayerDiv(10);
this._layerDiv.setAttribute("name","span-highlight-decorator");
this._layerDiv.style.display="none";
var k=this._band.getMinDate();
var d=this._band.getMaxDate();
if(this._unit.compare(this._startDate,d)<0&&this._unit.compare(this._endDate,k)>0){k=this._unit.later(k,this._startDate);
d=this._unit.earlier(d,this._endDate);
var j=this._band.dateToPixelOffset(k);
var g=this._band.dateToPixelOffset(d);
var h=this._timeline.getDocument();
var e=function(){var l=h.createElement("table");
l.insertRow(0).insertCell(0);
return l
};
var c=h.createElement("div");
c.className="timeline-highlight-decorator";
if(this._cssClass){c.className+=" "+this._cssClass
}if(this._opacity<100){SimileAjax.Graphics.setOpacity(c,this._opacity)
}this._layerDiv.appendChild(c);
var f=e();
f.className="timeline-highlight-label timeline-highlight-label-start";
var b=f.rows[0].cells[0];
b.innerHTML=this._startLabel;
if(this._cssClass){b.className="label_"+this._cssClass
}this._layerDiv.appendChild(f);
var i=e();
i.className="timeline-highlight-label timeline-highlight-label-end";
var a=i.rows[0].cells[0];
a.innerHTML=this._endLabel;
if(this._cssClass){a.className="label_"+this._cssClass
}this._layerDiv.appendChild(i);
if(this._timeline.isHorizontal()){c.style.left=j+"px";
c.style.width=(g-j)+"px";
f.style.right=(this._band.getTotalViewLength()-j)+"px";
f.style.width=(this._startLabel.length)+"em";
i.style.left=g+"px";
i.style.width=(this._endLabel.length)+"em"
}else{c.style.top=j+"px";
c.style.height=(g-j)+"px";
f.style.bottom=j+"px";
f.style.height="1.5px";
i.style.top=g+"px";
i.style.height="1.5px"
}}this._layerDiv.style.display="block"
};
Timeline.SpanHighlightDecorator.prototype.softPaint=function(){};
Timeline.PointHighlightDecorator=function(a){this._unit=("unit" in a)?a.unit:SimileAjax.NativeDateUnit;
this._date=(typeof a.date=="string")?this._unit.parseFromObject(a.date):a.date;
this._width=("width" in a)?a.width:10;
this._color=a.color;
this._cssClass=("cssClass" in a)?a.cssClass:"";
this._opacity=("opacity" in a)?a.opacity:100
};
Timeline.PointHighlightDecorator.prototype.initialize=function(b,a){this._band=b;
this._timeline=a;
this._layerDiv=null
};
Timeline.PointHighlightDecorator.prototype.paint=function(){if(this._layerDiv!=null){this._band.removeLayerDiv(this._layerDiv)
}this._layerDiv=this._band.createLayerDiv(10);
this._layerDiv.setAttribute("name","span-highlight-decorator");
this._layerDiv.style.display="none";
var e=this._band.getMinDate();
var c=this._band.getMaxDate();
if(this._unit.compare(this._date,c)<0&&this._unit.compare(this._date,e)>0){var a=this._band.dateToPixelOffset(this._date);
var f=a-Math.round(this._width/2);
var d=this._timeline.getDocument();
var b=d.createElement("div");
b.className="timeline-highlight-point-decorator";
b.className+=" "+this._cssClass;
if(this._opacity<100){SimileAjax.Graphics.setOpacity(b,this._opacity)
}this._layerDiv.appendChild(b);
if(this._timeline.isHorizontal()){b.style.left=f+"px"
}else{b.style.top=f+"px"
}}this._layerDiv.style.display="block"
};
Timeline.PointHighlightDecorator.prototype.softPaint=function(){};
Timeline.DetailedEventPainter=function(a){this._params=a;
this._onSelectListeners=[];
this._filterMatcher=null;
this._highlightMatcher=null;
this._frc=null;
this._eventIdToElmt={}
};
Timeline.DetailedEventPainter.prototype.initialize=function(b,a){this._band=b;
this._timeline=a;
this._backLayer=null;
this._eventLayer=null;
this._lineLayer=null;
this._highlightLayer=null;
this._eventIdToElmt=null
};
Timeline.DetailedEventPainter.prototype.addOnSelectListener=function(a){this._onSelectListeners.push(a)
};
Timeline.DetailedEventPainter.prototype.removeOnSelectListener=function(b){for(var a=0;
a<this._onSelectListeners.length;
a++){if(this._onSelectListeners[a]==b){this._onSelectListeners.splice(a,1);
break
}}};
Timeline.DetailedEventPainter.prototype.getFilterMatcher=function(){return this._filterMatcher
};
Timeline.DetailedEventPainter.prototype.setFilterMatcher=function(a){this._filterMatcher=a
};
Timeline.DetailedEventPainter.prototype.getHighlightMatcher=function(){return this._highlightMatcher
};
Timeline.DetailedEventPainter.prototype.setHighlightMatcher=function(a){this._highlightMatcher=a
};
Timeline.DetailedEventPainter.prototype.paint=function(){var b=this._band.getEventSource();
if(b==null){return
}this._eventIdToElmt={};
this._prepareForPainting();
var f=this._params.theme.event;
var h=Math.max(f.track.height,this._frc.getLineHeight());
var i={trackOffset:Math.round(this._band.getViewWidth()/2-h/2),trackHeight:h,trackGap:f.track.gap,trackIncrement:h+f.track.gap,icon:f.instant.icon,iconWidth:f.instant.iconWidth,iconHeight:f.instant.iconHeight,labelWidth:f.label.width};
var a=this._band.getMinDate();
var c=this._band.getMaxDate();
var e=(this._filterMatcher!=null)?this._filterMatcher:function(k){return true
};
var d=(this._highlightMatcher!=null)?this._highlightMatcher:function(k){return -1
};
var j=b.getEventReverseIterator(a,c);
while(j.hasNext()){var g=j.next();
if(e(g)){this.paintEvent(g,i,this._params.theme,d(g))
}}this._highlightLayer.style.display="block";
this._lineLayer.style.display="block";
this._eventLayer.style.display="block"
};
Timeline.DetailedEventPainter.prototype.softPaint=function(){};
Timeline.DetailedEventPainter.prototype._prepareForPainting=function(){var b=this._band;
if(this._backLayer==null){this._backLayer=this._band.createLayerDiv(0,"timeline-band-events");
this._backLayer.style.visibility="hidden";
var a=document.createElement("span");
a.className="timeline-event-label";
this._backLayer.appendChild(a);
this._frc=SimileAjax.Graphics.getFontRenderingContext(a)
}this._frc.update();
this._lowerTracks=[];
this._upperTracks=[];
if(this._highlightLayer!=null){b.removeLayerDiv(this._highlightLayer)
}this._highlightLayer=b.createLayerDiv(105,"timeline-band-highlights");
this._highlightLayer.style.display="none";
if(this._lineLayer!=null){b.removeLayerDiv(this._lineLayer)
}this._lineLayer=b.createLayerDiv(110,"timeline-band-lines");
this._lineLayer.style.display="none";
if(this._eventLayer!=null){b.removeLayerDiv(this._eventLayer)
}this._eventLayer=b.createLayerDiv(110,"timeline-band-events");
this._eventLayer.style.display="none"
};
Timeline.DetailedEventPainter.prototype.paintEvent=function(d,c,b,a){if(d.isInstant()){this.paintInstantEvent(d,c,b,a)
}else{this.paintDurationEvent(d,c,b,a)
}};
Timeline.DetailedEventPainter.prototype.paintInstantEvent=function(d,c,b,a){if(d.isImprecise()){this.paintImpreciseInstantEvent(d,c,b,a)
}else{this.paintPreciseInstantEvent(d,c,b,a)
}};
Timeline.DetailedEventPainter.prototype.paintDurationEvent=function(d,c,b,a){if(d.isImprecise()){this.paintImpreciseDurationEvent(d,c,b,a)
}else{this.paintPreciseDurationEvent(d,c,b,a)
}};
Timeline.DetailedEventPainter.prototype.paintPreciseInstantEvent=function(i,e,b,d){var a=this._timeline.getDocument();
var k=i.getText();
var n=i.getStart();
var m=Math.round(this._band.dateToPixelOffset(n));
var t=Math.round(m+e.iconWidth/2);
var r=Math.round(m-e.iconWidth/2);
var p=this._frc.computeSize(k);
var o=this._findFreeTrackForSolid(t,m);
var s=this._paintEventIcon(i,o,r,e,b);
var j=t+b.event.label.offsetFromLine;
var f=o;
var q=this._getTrackData(o);
if(Math.min(q.solid,q.text)>=j+p.width){q.solid=r;
q.text=j
}else{q.solid=r;
j=m+b.event.label.offsetFromLine;
f=this._findFreeTrackForText(o,j+p.width,function(u){u.line=m-2
});
this._getTrackData(f).text=r;
this._paintEventLine(i,m,o,f,e,b)
}var g=Math.round(e.trackOffset+f*e.trackIncrement+e.trackHeight/2-p.height/2);
var c=this._paintEventLabel(i,k,j,g,p.width,p.height,b);
var h=this;
var l=function(v,w,u){return h._onClickInstantEvent(s.elmt,w,i)
};
SimileAjax.DOM.registerEvent(s.elmt,"mousedown",l);
SimileAjax.DOM.registerEvent(c.elmt,"mousedown",l);
this._createHighlightDiv(d,s,b);
this._eventIdToElmt[i.getID()]=s.elmt
};
Timeline.DetailedEventPainter.prototype.paintImpreciseInstantEvent=function(j,f,b,e){var a=this._timeline.getDocument();
var l=j.getText();
var p=j.getStart();
var d=j.getEnd();
var n=Math.round(this._band.dateToPixelOffset(p));
var w=Math.round(this._band.dateToPixelOffset(d));
var x=Math.round(n+f.iconWidth/2);
var u=Math.round(n-f.iconWidth/2);
var r=this._frc.computeSize(l);
var q=this._findFreeTrackForSolid(w,n);
var t=this._paintEventTape(j,q,n,w,b.event.instant.impreciseColor,b.event.instant.impreciseOpacity,f,b);
var v=this._paintEventIcon(j,q,u,f,b);
var s=this._getTrackData(q);
s.solid=u;
var k=x+b.event.label.offsetFromLine;
var o=k+r.width;
var g;
if(o<w){g=q
}else{k=n+b.event.label.offsetFromLine;
o=k+r.width;
g=this._findFreeTrackForText(q,o,function(y){y.line=n-2
});
this._getTrackData(g).text=u;
this._paintEventLine(j,n,q,g,f,b)
}var h=Math.round(f.trackOffset+g*f.trackIncrement+f.trackHeight/2-r.height/2);
var c=this._paintEventLabel(j,l,k,h,r.width,r.height,b);
var i=this;
var m=function(z,A,y){return i._onClickInstantEvent(v.elmt,A,j)
};
SimileAjax.DOM.registerEvent(v.elmt,"mousedown",m);
SimileAjax.DOM.registerEvent(t.elmt,"mousedown",m);
SimileAjax.DOM.registerEvent(c.elmt,"mousedown",m);
this._createHighlightDiv(e,v,b);
this._eventIdToElmt[j.getID()]=v.elmt
};
Timeline.DetailedEventPainter.prototype.paintPreciseDurationEvent=function(k,g,b,e){var a=this._timeline.getDocument();
var m=k.getText();
var q=k.getStart();
var d=k.getEnd();
var p=Math.round(this._band.dateToPixelOffset(q));
var u=Math.round(this._band.dateToPixelOffset(d));
var s=this._frc.computeSize(m);
var r=this._findFreeTrackForSolid(u);
var f=k.getColor();
f=f!=null?f:b.event.duration.color;
var t=this._paintEventTape(k,r,p,u,f,100,g,b);
var n=this._getTrackData(r);
n.solid=p;
var l=p+b.event.label.offsetFromLine;
var h=this._findFreeTrackForText(r,l+s.width,function(v){v.line=p-2
});
this._getTrackData(h).text=p-2;
this._paintEventLine(k,p,r,h,g,b);
var i=Math.round(g.trackOffset+h*g.trackIncrement+g.trackHeight/2-s.height/2);
var c=this._paintEventLabel(k,m,l,i,s.width,s.height,b);
var j=this;
var o=function(v,w,x){return j._onClickDurationEvent(t.elmt,w,k)
};
SimileAjax.DOM.registerEvent(t.elmt,"mousedown",o);
SimileAjax.DOM.registerEvent(c.elmt,"mousedown",o);
this._createHighlightDiv(e,t,b);
this._eventIdToElmt[k.getID()]=t.elmt
};
Timeline.DetailedEventPainter.prototype.paintImpreciseDurationEvent=function(n,g,b,e){var a=this._timeline.getDocument();
var p=n.getText();
var t=n.getStart();
var h=n.getLatestStart();
var d=n.getEnd();
var l=n.getEarliestEnd();
var s=Math.round(this._band.dateToPixelOffset(t));
var v=Math.round(this._band.dateToPixelOffset(h));
var z=Math.round(this._band.dateToPixelOffset(d));
var u=Math.round(this._band.dateToPixelOffset(l));
var x=this._frc.computeSize(p);
var w=this._findFreeTrackForSolid(z);
var f=n.getColor();
f=f!=null?f:b.event.duration.color;
var i=this._paintEventTape(n,w,s,z,b.event.duration.impreciseColor,b.event.duration.impreciseOpacity,g,b);
var y=this._paintEventTape(n,w,v,u,f,100,g,b);
var q=this._getTrackData(w);
q.solid=s;
var o=v+b.event.label.offsetFromLine;
var j=this._findFreeTrackForText(w,o+x.width,function(A){A.line=v-2
});
this._getTrackData(j).text=v-2;
this._paintEventLine(n,v,w,j,g,b);
var k=Math.round(g.trackOffset+j*g.trackIncrement+g.trackHeight/2-x.height/2);
var c=this._paintEventLabel(n,p,o,k,x.width,x.height,b);
var m=this;
var r=function(A,B,C){return m._onClickDurationEvent(y.elmt,B,n)
};
SimileAjax.DOM.registerEvent(y.elmt,"mousedown",r);
SimileAjax.DOM.registerEvent(c.elmt,"mousedown",r);
this._createHighlightDiv(e,y,b);
this._eventIdToElmt[n.getID()]=y.elmt
};
Timeline.DetailedEventPainter.prototype._findFreeTrackForSolid=function(b,a){for(var c=0;
true;
c++){if(c<this._lowerTracks.length){var d=this._lowerTracks[c];
if(Math.min(d.solid,d.text)>b&&(!(a)||d.line>a)){return c
}}else{this._lowerTracks.push({solid:Number.POSITIVE_INFINITY,text:Number.POSITIVE_INFINITY,line:Number.POSITIVE_INFINITY});
return c
}if(c<this._upperTracks.length){var d=this._upperTracks[c];
if(Math.min(d.solid,d.text)>b&&(!(a)||d.line>a)){return -1-c
}}else{this._upperTracks.push({solid:Number.POSITIVE_INFINITY,text:Number.POSITIVE_INFINITY,line:Number.POSITIVE_INFINITY});
return -1-c
}}};
Timeline.DetailedEventPainter.prototype._findFreeTrackForText=function(b,d,f){var c;
var j;
var i;
var g;
if(b<0){c=true;
i=-b;
j=this._findFreeUpperTrackForText(i,d);
g=-1-j
}else{if(b>0){c=false;
i=b+1;
j=this._findFreeLowerTrackForText(i,d);
g=j
}else{var h=this._findFreeUpperTrackForText(0,d);
var e=this._findFreeLowerTrackForText(1,d);
if(e-1<=h){c=false;
i=1;
j=e;
g=j
}else{c=true;
i=0;
j=h;
g=-1-j
}}}if(c){if(j==this._upperTracks.length){this._upperTracks.push({solid:Number.POSITIVE_INFINITY,text:Number.POSITIVE_INFINITY,line:Number.POSITIVE_INFINITY})
}for(var a=i;
a<j;
a++){f(this._upperTracks[a])
}}else{if(j==this._lowerTracks.length){this._lowerTracks.push({solid:Number.POSITIVE_INFINITY,text:Number.POSITIVE_INFINITY,line:Number.POSITIVE_INFINITY})
}for(var a=i;
a<j;
a++){f(this._lowerTracks[a])
}}return g
};
Timeline.DetailedEventPainter.prototype._findFreeLowerTrackForText=function(a,b){for(;
a<this._lowerTracks.length;
a++){var c=this._lowerTracks[a];
if(Math.min(c.solid,c.text)>=b){break
}}return a
};
Timeline.DetailedEventPainter.prototype._findFreeUpperTrackForText=function(a,b){for(;
a<this._upperTracks.length;
a++){var c=this._upperTracks[a];
if(Math.min(c.solid,c.text)>=b){break
}}return a
};
Timeline.DetailedEventPainter.prototype._getTrackData=function(a){return(a<0)?this._upperTracks[-a-1]:this._lowerTracks[a]
};
Timeline.DetailedEventPainter.prototype._paintEventLine=function(e,j,a,d,h,i){var g=Math.round(h.trackOffset+a*h.trackIncrement+h.trackHeight/2);
var f=Math.round(Math.abs(d-a)*h.trackIncrement);
var b="1px solid "+i.event.label.lineColor;
var c=this._timeline.getDocument().createElement("div");
c.style.position="absolute";
c.style.left=j+"px";
c.style.width=i.event.label.offsetFromLine+"px";
c.style.height=f+"px";
if(a>d){c.style.top=(g-f)+"px";
c.style.borderTop=b
}else{c.style.top=g+"px";
c.style.borderBottom=b
}c.style.borderLeft=b;
this._lineLayer.appendChild(c)
};
Timeline.DetailedEventPainter.prototype._paintEventIcon=function(e,c,b,i,j){var g=e.getIcon();
g=g!=null?g:i.icon;
var h=i.trackOffset+c*i.trackIncrement+i.trackHeight/2;
var f=Math.round(h-i.iconHeight/2);
var a=SimileAjax.Graphics.createTranslucentImage(g);
var d=this._timeline.getDocument().createElement("div");
d.style.position="absolute";
d.style.left=b+"px";
d.style.top=f+"px";
d.appendChild(a);
d.style.cursor="pointer";
if(e._title!=null){d.title=e._title
}this._eventLayer.appendChild(d);
return{left:b,top:f,width:i.iconWidth,height:i.iconHeight,elmt:d}
};
Timeline.DetailedEventPainter.prototype._paintEventLabel=function(g,f,b,j,d,i,k){var h=this._timeline.getDocument();
var e=h.createElement("div");
e.style.position="absolute";
e.style.left=b+"px";
e.style.width=d+"px";
e.style.top=j+"px";
e.style.height=i+"px";
e.style.backgroundColor=k.event.label.backgroundColor;
SimileAjax.Graphics.setOpacity(e,k.event.label.backgroundOpacity);
this._eventLayer.appendChild(e);
var c=h.createElement("div");
c.style.position="absolute";
c.style.left=b+"px";
c.style.width=d+"px";
c.style.top=j+"px";
c.innerHTML=f;
c.style.cursor="pointer";
if(g._title!=null){c.title=g._title
}var a=g.getTextColor();
if(a==null){a=g.getColor()
}if(a!=null){c.style.color=a
}this._eventLayer.appendChild(c);
return{left:b,top:j,width:d,height:i,elmt:c}
};
Timeline.DetailedEventPainter.prototype._paintEventTape=function(f,c,a,d,k,b,i,j){var l=d-a;
var m=j.event.tape.height;
var g=i.trackOffset+c*i.trackIncrement+i.trackHeight/2;
var h=Math.round(g-m/2);
var e=this._timeline.getDocument().createElement("div");
e.style.position="absolute";
e.style.left=a+"px";
e.style.width=l+"px";
e.style.top=h+"px";
e.style.height=m+"px";
e.style.backgroundColor=k;
e.style.overflow="hidden";
e.style.cursor="pointer";
if(f._title!=null){e.title=f._title
}SimileAjax.Graphics.setOpacity(e,b);
this._eventLayer.appendChild(e);
return{left:a,top:h,width:l,height:m,elmt:e}
};
Timeline.DetailedEventPainter.prototype._createHighlightDiv=function(a,f,d){if(a>=0){var e=this._timeline.getDocument();
var b=d.event;
var g=b.highlightColors[Math.min(a,b.highlightColors.length-1)];
var c=e.createElement("div");
c.style.position="absolute";
c.style.overflow="hidden";
c.style.left=(f.left-2)+"px";
c.style.width=(f.width+4)+"px";
c.style.top=(f.top-2)+"px";
c.style.height=(f.height+4)+"px";
c.style.background=g;
this._highlightLayer.appendChild(c)
}};
Timeline.DetailedEventPainter.prototype._onClickInstantEvent=function(c,a,d){var b=SimileAjax.DOM.getPageCoordinates(c);
this._showBubble(b.left+Math.ceil(c.offsetWidth/2),b.top+Math.ceil(c.offsetHeight/2),d);
this._fireOnSelect(d.getID());
a.cancelBubble=true;
SimileAjax.DOM.cancelEvent(a);
return false
};
Timeline.DetailedEventPainter.prototype._onClickDurationEvent=function(b,f,e){if("pageX" in f){var a=f.pageX;
var c=f.pageY
}else{var d=SimileAjax.DOM.getPageCoordinates(b);
var a=f.offsetX+d.left;
var c=f.offsetY+d.top
}this._showBubble(a,c,e);
this._fireOnSelect(e.getID());
f.cancelBubble=true;
SimileAjax.DOM.cancelEvent(f);
return false
};
Timeline.DetailedEventPainter.prototype.showBubble=function(a){var c=this._eventIdToElmt[a.getID()];
if(c){var b=SimileAjax.DOM.getPageCoordinates(c);
this._showBubble(b.left+c.offsetWidth/2,b.top+c.offsetHeight/2,a)
}};
Timeline.DetailedEventPainter.prototype._showBubble=function(a,b,d){var c=document.createElement("div");
d.fillInfoBubble(c,this._params.theme,this._band.getLabeller());
SimileAjax.WindowManager.cancelPopups();
SimileAjax.Graphics.createBubbleForContentAndPoint(c,a,b,this._params.theme.event.bubble.width)
};
Timeline.DetailedEventPainter.prototype._fireOnSelect=function(a){for(var b=0;
b<this._onSelectListeners.length;
b++){this._onSelectListeners[b](a)
}};
Timeline.GregorianEtherPainter=function(a){this._params=a;
this._theme=a.theme;
this._unit=a.unit;
this._multiple=("multiple" in a)?a.multiple:1
};
Timeline.GregorianEtherPainter.prototype.initialize=function(c,d){this._band=c;
this._timeline=d;
this._backgroundLayer=c.createLayerDiv(0);
this._backgroundLayer.setAttribute("name","ether-background");
this._backgroundLayer.className="timeline-ether-bg";
this._markerLayer=null;
this._lineLayer=null;
var b=("align" in this._params&&this._params.align!=undefined)?this._params.align:this._theme.ether.interval.marker[d.isHorizontal()?"hAlign":"vAlign"];
var a=("showLine" in this._params)?this._params.showLine:this._theme.ether.interval.line.show;
this._intervalMarkerLayout=new Timeline.EtherIntervalMarkerLayout(this._timeline,this._band,this._theme,b,a);
this._highlight=new Timeline.EtherHighlight(this._timeline,this._band,this._theme,this._backgroundLayer)
};
Timeline.GregorianEtherPainter.prototype.setHighlight=function(a,b){this._highlight.position(a,b)
};
Timeline.GregorianEtherPainter.prototype.paint=function(){if(this._markerLayer){this._band.removeLayerDiv(this._markerLayer)
}this._markerLayer=this._band.createLayerDiv(100);
this._markerLayer.setAttribute("name","ether-markers");
this._markerLayer.style.display="none";
if(this._lineLayer){this._band.removeLayerDiv(this._lineLayer)
}this._lineLayer=this._band.createLayerDiv(1);
this._lineLayer.setAttribute("name","ether-lines");
this._lineLayer.style.display="none";
var e=this._band.getMinDate();
var b=this._band.getMaxDate();
var a=this._band.getTimeZone();
var c=this._band.getLabeller();
SimileAjax.DateTime.roundDownToInterval(e,this._unit,a,this._multiple,this._theme.firstDayOfWeek);
var d=this;
var f=function(h){for(var g=0;
g<d._multiple;
g++){SimileAjax.DateTime.incrementByInterval(h,d._unit)
}};
while(e.getTime()<b.getTime()){this._intervalMarkerLayout.createIntervalMarker(e,c,this._unit,this._markerLayer,this._lineLayer);
f(e)
}this._markerLayer.style.display="block";
this._lineLayer.style.display="block"
};
Timeline.GregorianEtherPainter.prototype.softPaint=function(){};
Timeline.GregorianEtherPainter.prototype.zoom=function(a){if(a!=0){this._unit+=a
}};
Timeline.HotZoneGregorianEtherPainter=function(b){this._params=b;
this._theme=b.theme;
this._zones=[{startTime:Number.NEGATIVE_INFINITY,endTime:Number.POSITIVE_INFINITY,unit:b.unit,multiple:1}];
for(var c=0;
c<b.zones.length;
c++){var f=b.zones[c];
var d=SimileAjax.DateTime.parseGregorianDateTime(f.start).getTime();
var g=SimileAjax.DateTime.parseGregorianDateTime(f.end).getTime();
for(var e=0;
e<this._zones.length&&g>d;
e++){var a=this._zones[e];
if(d<a.endTime){if(d>a.startTime){this._zones.splice(e,0,{startTime:a.startTime,endTime:d,unit:a.unit,multiple:a.multiple});
e++;
a.startTime=d
}if(g<a.endTime){this._zones.splice(e,0,{startTime:d,endTime:g,unit:f.unit,multiple:(f.multiple)?f.multiple:1});
e++;
a.startTime=g;
d=g
}else{a.multiple=f.multiple;
a.unit=f.unit;
d=a.endTime
}}}}};
Timeline.HotZoneGregorianEtherPainter.prototype.initialize=function(c,d){this._band=c;
this._timeline=d;
this._backgroundLayer=c.createLayerDiv(0);
this._backgroundLayer.setAttribute("name","ether-background");
this._backgroundLayer.className="timeline-ether-bg";
this._markerLayer=null;
this._lineLayer=null;
var b=("align" in this._params&&this._params.align!=undefined)?this._params.align:this._theme.ether.interval.marker[d.isHorizontal()?"hAlign":"vAlign"];
var a=("showLine" in this._params)?this._params.showLine:this._theme.ether.interval.line.show;
this._intervalMarkerLayout=new Timeline.EtherIntervalMarkerLayout(this._timeline,this._band,this._theme,b,a);
this._highlight=new Timeline.EtherHighlight(this._timeline,this._band,this._theme,this._backgroundLayer)
};
Timeline.HotZoneGregorianEtherPainter.prototype.setHighlight=function(a,b){this._highlight.position(a,b)
};
Timeline.HotZoneGregorianEtherPainter.prototype.paint=function(){if(this._markerLayer){this._band.removeLayerDiv(this._markerLayer)
}this._markerLayer=this._band.createLayerDiv(100);
this._markerLayer.setAttribute("name","ether-markers");
this._markerLayer.style.display="none";
if(this._lineLayer){this._band.removeLayerDiv(this._lineLayer)
}this._lineLayer=this._band.createLayerDiv(1);
this._lineLayer.setAttribute("name","ether-lines");
this._lineLayer.style.display="none";
var b=this._band.getMinDate();
var d=this._band.getMaxDate();
var h=this._band.getTimeZone();
var e=this._band.getLabeller();
var c=this;
var g=function(n,o){for(var m=0;
m<o.multiple;
m++){SimileAjax.DateTime.incrementByInterval(n,o.unit)
}};
var a=0;
while(a<this._zones.length){if(b.getTime()<this._zones[a].endTime){break
}a++
}var l=this._zones.length-1;
while(l>=0){if(d.getTime()>this._zones[l].startTime){break
}l--
}for(var i=a;
i<=l;
i++){var j=this._zones[i];
var f=new Date(Math.max(b.getTime(),j.startTime));
var k=new Date(Math.min(d.getTime(),j.endTime));
SimileAjax.DateTime.roundDownToInterval(f,j.unit,h,j.multiple,this._theme.firstDayOfWeek);
SimileAjax.DateTime.roundUpToInterval(k,j.unit,h,j.multiple,this._theme.firstDayOfWeek);
while(f.getTime()<k.getTime()){this._intervalMarkerLayout.createIntervalMarker(f,e,j.unit,this._markerLayer,this._lineLayer);
g(f,j)
}}this._markerLayer.style.display="block";
this._lineLayer.style.display="block"
};
Timeline.HotZoneGregorianEtherPainter.prototype.softPaint=function(){};
Timeline.HotZoneGregorianEtherPainter.prototype.zoom=function(a){if(a!=0){for(var b=0;
b<this._zones.length;
++b){if(this._zones[b]){this._zones[b].unit+=a
}}}};
Timeline.YearCountEtherPainter=function(a){this._params=a;
this._theme=a.theme;
this._startDate=SimileAjax.DateTime.parseGregorianDateTime(a.startDate);
this._multiple=("multiple" in a)?a.multiple:1
};
Timeline.YearCountEtherPainter.prototype.initialize=function(c,d){this._band=c;
this._timeline=d;
this._backgroundLayer=c.createLayerDiv(0);
this._backgroundLayer.setAttribute("name","ether-background");
this._backgroundLayer.className="timeline-ether-bg";
this._markerLayer=null;
this._lineLayer=null;
var b=("align" in this._params)?this._params.align:this._theme.ether.interval.marker[d.isHorizontal()?"hAlign":"vAlign"];
var a=("showLine" in this._params)?this._params.showLine:this._theme.ether.interval.line.show;
this._intervalMarkerLayout=new Timeline.EtherIntervalMarkerLayout(this._timeline,this._band,this._theme,b,a);
this._highlight=new Timeline.EtherHighlight(this._timeline,this._band,this._theme,this._backgroundLayer)
};
Timeline.YearCountEtherPainter.prototype.setHighlight=function(a,b){this._highlight.position(a,b)
};
Timeline.YearCountEtherPainter.prototype.paint=function(){if(this._markerLayer){this._band.removeLayerDiv(this._markerLayer)
}this._markerLayer=this._band.createLayerDiv(100);
this._markerLayer.setAttribute("name","ether-markers");
this._markerLayer.style.display="none";
if(this._lineLayer){this._band.removeLayerDiv(this._lineLayer)
}this._lineLayer=this._band.createLayerDiv(1);
this._lineLayer.setAttribute("name","ether-lines");
this._lineLayer.style.display="none";
var f=new Date(this._startDate.getTime());
var b=this._band.getMaxDate();
var c=this._band.getMinDate().getUTCFullYear()-this._startDate.getUTCFullYear();
f.setUTCFullYear(this._band.getMinDate().getUTCFullYear()-c%this._multiple);
var e=this;
var a=function(h){for(var g=0;
g<e._multiple;
g++){SimileAjax.DateTime.incrementByInterval(h,SimileAjax.DateTime.YEAR)
}};
var d={labelInterval:function(i,g){var h=i.getUTCFullYear()-e._startDate.getUTCFullYear();
return{text:h,emphasized:h==0}
}};
while(f.getTime()<b.getTime()){this._intervalMarkerLayout.createIntervalMarker(f,d,SimileAjax.DateTime.YEAR,this._markerLayer,this._lineLayer);
a(f)
}this._markerLayer.style.display="block";
this._lineLayer.style.display="block"
};
Timeline.YearCountEtherPainter.prototype.softPaint=function(){};
Timeline.QuarterlyEtherPainter=function(a){this._params=a;
this._theme=a.theme;
this._startDate=SimileAjax.DateTime.parseGregorianDateTime(a.startDate)
};
Timeline.QuarterlyEtherPainter.prototype.initialize=function(c,d){this._band=c;
this._timeline=d;
this._backgroundLayer=c.createLayerDiv(0);
this._backgroundLayer.setAttribute("name","ether-background");
this._backgroundLayer.className="timeline-ether-bg";
this._markerLayer=null;
this._lineLayer=null;
var b=("align" in this._params)?this._params.align:this._theme.ether.interval.marker[d.isHorizontal()?"hAlign":"vAlign"];
var a=("showLine" in this._params)?this._params.showLine:this._theme.ether.interval.line.show;
this._intervalMarkerLayout=new Timeline.EtherIntervalMarkerLayout(this._timeline,this._band,this._theme,b,a);
this._highlight=new Timeline.EtherHighlight(this._timeline,this._band,this._theme,this._backgroundLayer)
};
Timeline.QuarterlyEtherPainter.prototype.setHighlight=function(a,b){this._highlight.position(a,b)
};
Timeline.QuarterlyEtherPainter.prototype.paint=function(){if(this._markerLayer){this._band.removeLayerDiv(this._markerLayer)
}this._markerLayer=this._band.createLayerDiv(100);
this._markerLayer.setAttribute("name","ether-markers");
this._markerLayer.style.display="none";
if(this._lineLayer){this._band.removeLayerDiv(this._lineLayer)
}this._lineLayer=this._band.createLayerDiv(1);
this._lineLayer.setAttribute("name","ether-lines");
this._lineLayer.style.display="none";
var e=new Date(0);
var b=this._band.getMaxDate();
e.setUTCFullYear(Math.max(this._startDate.getUTCFullYear(),this._band.getMinDate().getUTCFullYear()));
e.setUTCMonth(this._startDate.getUTCMonth());
var d=this;
var a=function(f){f.setUTCMonth(f.getUTCMonth()+3)
};
var c={labelInterval:function(g,f){var h=(4+(g.getUTCMonth()-d._startDate.getUTCMonth())/3)%4;
if(h!=0){return{text:"Q"+(h+1),emphasized:false}
}else{return{text:"Y"+(g.getUTCFullYear()-d._startDate.getUTCFullYear()+1),emphasized:true}
}}};
while(e.getTime()<b.getTime()){this._intervalMarkerLayout.createIntervalMarker(e,c,SimileAjax.DateTime.YEAR,this._markerLayer,this._lineLayer);
a(e)
}this._markerLayer.style.display="block";
this._lineLayer.style.display="block"
};
Timeline.QuarterlyEtherPainter.prototype.softPaint=function(){};
Timeline.EtherIntervalMarkerLayout=function(i,f,b,m,e){var d=i.isHorizontal();
if(d){if(m=="Top"){this.positionDiv=function(n,o){n.style.left=o+"px";
n.style.top="0px"
}
}else{this.positionDiv=function(n,o){n.style.left=o+"px";
n.style.bottom="0px"
}
}}else{if(m=="Left"){this.positionDiv=function(n,o){n.style.top=o+"px";
n.style.left="0px"
}
}else{this.positionDiv=function(n,o){n.style.top=o+"px";
n.style.right="0px"
}
}}var a=b.ether.interval.marker;
var g=b.ether.interval.line;
var c=b.ether.interval.weekend;
var j=(d?"h":"v")+m;
var k=a[j+"Styler"];
var h=a[j+"EmphasizedStyler"];
var l=SimileAjax.DateTime.gregorianUnitLengths[SimileAjax.DateTime.DAY];
this.createIntervalMarker=function(t,A,C,o,x){var s=Math.round(f.dateToPixelOffset(t));
if(e&&C!=SimileAjax.DateTime.WEEK){var r=i.getDocument().createElement("div");
r.className="timeline-ether-lines";
if(g.opacity<100){SimileAjax.Graphics.setOpacity(r,g.opacity)
}if(d){r.style.left=s+"px"
}else{r.style.top=s+"px"
}x.appendChild(r)
}if(C==SimileAjax.DateTime.WEEK){var z=b.firstDayOfWeek;
var v=new Date(t.getTime()+(6-z-7)*l);
var B=new Date(v.getTime()+2*l);
var w=Math.round(f.dateToPixelOffset(v));
var u=Math.round(f.dateToPixelOffset(B));
var q=Math.max(1,u-w);
var p=i.getDocument().createElement("div");
p.className="timeline-ether-weekends";
if(c.opacity<100){SimileAjax.Graphics.setOpacity(p,c.opacity)
}if(d){p.style.left=w+"px";
p.style.width=q+"px"
}else{p.style.top=w+"px";
p.style.height=q+"px"
}x.appendChild(p)
}var n=A.labelInterval(t,C);
var y=i.getDocument().createElement("div");
y.innerHTML=n.text;
y.className="timeline-date-label";
if(n.emphasized){y.className+=" timeline-date-label-em"
}this.positionDiv(y,s);
o.appendChild(y);
return y
}
};
Timeline.EtherHighlight=function(e,b,c,d){var a=e.isHorizontal();
this._highlightDiv=null;
this._createHighlightDiv=function(){if(this._highlightDiv==null){this._highlightDiv=e.getDocument().createElement("div");
this._highlightDiv.setAttribute("name","ether-highlight");
this._highlightDiv.className="timeline-ether-highlight";
var f=c.ether.highlightOpacity;
if(f<100){SimileAjax.Graphics.setOpacity(this._highlightDiv,f)
}d.appendChild(this._highlightDiv)
}};
this.position=function(h,f){this._createHighlightDiv();
var g=Math.round(b.dateToPixelOffset(h));
var i=Math.round(b.dateToPixelOffset(f));
var j=Math.max(i-g,3);
if(a){this._highlightDiv.style.left=g+"px";
this._highlightDiv.style.width=j+"px";
this._highlightDiv.style.height=(b.getViewWidth()-4)+"px"
}else{this._highlightDiv.style.top=g+"px";
this._highlightDiv.style.height=j+"px";
this._highlightDiv.style.width=(b.getViewWidth()-4)+"px"
}}
};
Timeline.LinearEther=function(a){this._params=a;
this._interval=a.interval;
this._pixelsPerInterval=a.pixelsPerInterval
};
Timeline.LinearEther.prototype.initialize=function(b,a){this._band=b;
this._timeline=a;
this._unit=a.getUnit();
if("startsOn" in this._params){this._start=this._unit.parseFromObject(this._params.startsOn)
}else{if("endsOn" in this._params){this._start=this._unit.parseFromObject(this._params.endsOn);
this.shiftPixels(-this._timeline.getPixelLength())
}else{if("centersOn" in this._params){this._start=this._unit.parseFromObject(this._params.centersOn);
this.shiftPixels(-this._timeline.getPixelLength()/2)
}else{this._start=this._unit.makeDefaultValue();
this.shiftPixels(-this._timeline.getPixelLength()/2)
}}}};
Timeline.LinearEther.prototype.setDate=function(a){this._start=this._unit.cloneValue(a)
};
Timeline.LinearEther.prototype.shiftPixels=function(b){var a=this._interval*b/this._pixelsPerInterval;
this._start=this._unit.change(this._start,a)
};
Timeline.LinearEther.prototype.dateToPixelOffset=function(b){var a=this._unit.compare(b,this._start);
return this._pixelsPerInterval*a/this._interval
};
Timeline.LinearEther.prototype.pixelOffsetToDate=function(b){var a=b*this._interval/this._pixelsPerInterval;
return this._unit.change(this._start,a)
};
Timeline.LinearEther.prototype.zoom=function(b){var a=0;
var d=this._band._zoomIndex;
var c=d;
if(b&&(d>0)){c=d-1
}if(!b&&(d<(this._band._zoomSteps.length-1))){c=d+1
}this._band._zoomIndex=c;
this._interval=SimileAjax.DateTime.gregorianUnitLengths[this._band._zoomSteps[c].unit];
this._pixelsPerInterval=this._band._zoomSteps[c].pixelsPerInterval;
a=this._band._zoomSteps[c].unit-this._band._zoomSteps[d].unit;
return a
};
Timeline.HotZoneEther=function(a){this._params=a;
this._interval=a.interval;
this._pixelsPerInterval=a.pixelsPerInterval;
this._theme=a.theme
};
Timeline.HotZoneEther.prototype.initialize=function(e,f){this._band=e;
this._timeline=f;
this._unit=f.getUnit();
this._zones=[{startTime:Number.NEGATIVE_INFINITY,endTime:Number.POSITIVE_INFINITY,magnify:1}];
var a=this._params;
for(var i=0;
i<a.zones.length;
i++){var g=a.zones[i];
var h=this._unit.parseFromObject(g.start);
var c=this._unit.parseFromObject(g.end);
for(var b=0;
b<this._zones.length&&this._unit.compare(c,h)>0;
b++){var d=this._zones[b];
if(this._unit.compare(h,d.endTime)<0){if(this._unit.compare(h,d.startTime)>0){this._zones.splice(b,0,{startTime:d.startTime,endTime:h,magnify:d.magnify});
b++;
d.startTime=h
}if(this._unit.compare(c,d.endTime)<0){this._zones.splice(b,0,{startTime:h,endTime:c,magnify:g.magnify*d.magnify});
b++;
d.startTime=c;
h=c
}else{d.magnify*=g.magnify;
h=d.endTime
}}}}if("startsOn" in this._params){this._start=this._unit.parseFromObject(this._params.startsOn)
}else{if("endsOn" in this._params){this._start=this._unit.parseFromObject(this._params.endsOn);
this.shiftPixels(-this._timeline.getPixelLength())
}else{if("centersOn" in this._params){this._start=this._unit.parseFromObject(this._params.centersOn);
this.shiftPixels(-this._timeline.getPixelLength()/2)
}else{this._start=this._unit.makeDefaultValue();
this.shiftPixels(-this._timeline.getPixelLength()/2)
}}}};
Timeline.HotZoneEther.prototype.setDate=function(a){this._start=this._unit.cloneValue(a)
};
Timeline.HotZoneEther.prototype.shiftPixels=function(a){this._start=this.pixelOffsetToDate(a)
};
Timeline.HotZoneEther.prototype.dateToPixelOffset=function(a){return this._dateDiffToPixelOffset(this._start,a)
};
Timeline.HotZoneEther.prototype.pixelOffsetToDate=function(a){return this._pixelOffsetToDate(a,this._start)
};
Timeline.HotZoneEther.prototype.zoom=function(b){var a=0;
var d=this._band._zoomIndex;
var c=d;
if(b&&(d>0)){c=d-1
}if(!b&&(d<(this._band._zoomSteps.length-1))){c=d+1
}this._band._zoomIndex=c;
this._interval=SimileAjax.DateTime.gregorianUnitLengths[this._band._zoomSteps[c].unit];
this._pixelsPerInterval=this._band._zoomSteps[c].pixelsPerInterval;
a=this._band._zoomSteps[c].unit-this._band._zoomSteps[d].unit;
return a
};
Timeline.HotZoneEther.prototype._dateDiffToPixelOffset=function(f,b){var a=this._getScale();
var e=f;
var c=b;
var i=0;
if(this._unit.compare(e,c)<0){var g=0;
while(g<this._zones.length){if(this._unit.compare(e,this._zones[g].endTime)<0){break
}g++
}while(this._unit.compare(e,c)<0){var h=this._zones[g];
var d=this._unit.earlier(c,h.endTime);
i+=(this._unit.compare(d,e)/(a/h.magnify));
e=d;
g++
}}else{var g=this._zones.length-1;
while(g>=0){if(this._unit.compare(e,this._zones[g].startTime)>0){break
}g--
}while(this._unit.compare(e,c)>0){var h=this._zones[g];
var d=this._unit.later(c,h.startTime);
i+=(this._unit.compare(d,e)/(a/h.magnify));
e=d;
g--
}}return i
};
Timeline.HotZoneEther.prototype._pixelOffsetToDate=function(e,h){var c=this._getScale();
var f=h;
if(e>0){var d=0;
while(d<this._zones.length){if(this._unit.compare(f,this._zones[d].endTime)<0){break
}d++
}while(e>0){var a=this._zones[d];
var b=c/a.magnify;
if(a.endTime==Number.POSITIVE_INFINITY){f=this._unit.change(f,e*b);
e=0
}else{var g=this._unit.compare(a.endTime,f)/b;
if(g>e){f=this._unit.change(f,e*b);
e=0
}else{f=a.endTime;
e-=g
}}d++
}}else{var d=this._zones.length-1;
while(d>=0){if(this._unit.compare(f,this._zones[d].startTime)>0){break
}d--
}e=-e;
while(e>0){var a=this._zones[d];
var b=c/a.magnify;
if(a.startTime==Number.NEGATIVE_INFINITY){f=this._unit.change(f,-e*b);
e=0
}else{var g=this._unit.compare(f,a.startTime)/b;
if(g>e){f=this._unit.change(f,-e*b);
e=0
}else{f=a.startTime;
e-=g
}}d--
}}return f
};
Timeline.HotZoneEther.prototype._getScale=function(){return this._interval/this._pixelsPerInterval
};
Timeline.GregorianDateLabeller=function(b,a){this._locale=b;
this._timeZone=a
};
Timeline.GregorianDateLabeller.monthNames=[];
Timeline.GregorianDateLabeller.dayNames=[];
Timeline.GregorianDateLabeller.labelIntervalFunctions=[];
Timeline.GregorianDateLabeller.getMonthName=function(b,a){return Timeline.GregorianDateLabeller.monthNames[a][b]
};
Timeline.GregorianDateLabeller.prototype.labelInterval=function(a,b){var c=Timeline.GregorianDateLabeller.labelIntervalFunctions[this._locale];
if(c==null){c=Timeline.GregorianDateLabeller.prototype.defaultLabelInterval
}return c.call(this,a,b)
};
Timeline.GregorianDateLabeller.prototype.labelPrecise=function(a){return SimileAjax.DateTime.removeTimeZoneOffset(a,this._timeZone).toUTCString()
};
Timeline.GregorianDateLabeller.prototype.defaultLabelInterval=function(f,e){var d;
var b=false;
f=SimileAjax.DateTime.removeTimeZoneOffset(f,this._timeZone);
switch(e){case SimileAjax.DateTime.MILLISECOND:d=f.getUTCMilliseconds();
break;
case SimileAjax.DateTime.SECOND:d=f.getUTCSeconds();
break;
case SimileAjax.DateTime.MINUTE:var a=f.getUTCMinutes();
if(a==0){d=f.getUTCHours()+":00";
b=true
}else{d=a
}break;
case SimileAjax.DateTime.HOUR:d=f.getUTCHours()+"hr";
break;
case SimileAjax.DateTime.DAY:d=Timeline.GregorianDateLabeller.getMonthName(f.getUTCMonth(),this._locale)+" "+f.getUTCDate();
break;
case SimileAjax.DateTime.WEEK:d=Timeline.GregorianDateLabeller.getMonthName(f.getUTCMonth(),this._locale)+" "+f.getUTCDate();
break;
case SimileAjax.DateTime.MONTH:var a=f.getUTCMonth();
if(a!=0){d=Timeline.GregorianDateLabeller.getMonthName(a,this._locale);
break
}case SimileAjax.DateTime.YEAR:case SimileAjax.DateTime.DECADE:case SimileAjax.DateTime.CENTURY:case SimileAjax.DateTime.MILLENNIUM:var c=f.getUTCFullYear();
if(c>0){d=f.getUTCFullYear()
}else{d=(1-c)+"BC"
}b=(e==SimileAjax.DateTime.MONTH)||(e==SimileAjax.DateTime.DECADE&&c%100==0)||(e==SimileAjax.DateTime.CENTURY&&c%1000==0);
break;
default:d=f.toUTCString()
}return{text:d,emphasized:b}
};
Timeline.OriginalEventPainter=function(a){this._params=a;
this._onSelectListeners=[];
this._filterMatcher=null;
this._highlightMatcher=null;
this._frc=null;
this._eventIdToElmt={}
};
Timeline.OriginalEventPainter.prototype.initialize=function(b,a){this._band=b;
this._timeline=a;
this._backLayer=null;
this._eventLayer=null;
this._lineLayer=null;
this._highlightLayer=null;
this._eventIdToElmt=null
};
Timeline.OriginalEventPainter.prototype.addOnSelectListener=function(a){this._onSelectListeners.push(a)
};
Timeline.OriginalEventPainter.prototype.removeOnSelectListener=function(b){for(var a=0;
a<this._onSelectListeners.length;
a++){if(this._onSelectListeners[a]==b){this._onSelectListeners.splice(a,1);
break
}}};
Timeline.OriginalEventPainter.prototype.getFilterMatcher=function(){return this._filterMatcher
};
Timeline.OriginalEventPainter.prototype.setFilterMatcher=function(a){this._filterMatcher=a
};
Timeline.OriginalEventPainter.prototype.getHighlightMatcher=function(){return this._highlightMatcher
};
Timeline.OriginalEventPainter.prototype.setHighlightMatcher=function(a){this._highlightMatcher=a
};
Timeline.OriginalEventPainter.prototype.paint=function(){var b=this._band.getEventSource();
if(b==null){return
}this._eventIdToElmt={};
this._prepareForPainting();
var f=this._params.theme.event;
var h=Math.max(f.track.height,f.tape.height+this._frc.getLineHeight());
var i={trackOffset:f.track.gap,trackHeight:h,trackGap:f.track.gap,trackIncrement:h+f.track.gap,icon:f.instant.icon,iconWidth:f.instant.iconWidth,iconHeight:f.instant.iconHeight,labelWidth:f.label.width};
var a=this._band.getMinDate();
var c=this._band.getMaxDate();
var e=(this._filterMatcher!=null)?this._filterMatcher:function(k){return true
};
var d=(this._highlightMatcher!=null)?this._highlightMatcher:function(k){return -1
};
var j=b.getEventReverseIterator(a,c);
while(j.hasNext()){var g=j.next();
if(e(g)){this.paintEvent(g,i,this._params.theme,d(g))
}}this._highlightLayer.style.display="block";
this._lineLayer.style.display="block";
this._eventLayer.style.display="block"
};
Timeline.OriginalEventPainter.prototype.softPaint=function(){};
Timeline.OriginalEventPainter.prototype._prepareForPainting=function(){var b=this._band;
if(this._backLayer==null){this._backLayer=this._band.createLayerDiv(0,"timeline-band-events");
this._backLayer.style.visibility="hidden";
var a=document.createElement("span");
a.className="timeline-event-label";
this._backLayer.appendChild(a);
this._frc=SimileAjax.Graphics.getFontRenderingContext(a)
}this._frc.update();
this._tracks=[];
if(this._highlightLayer!=null){b.removeLayerDiv(this._highlightLayer)
}this._highlightLayer=b.createLayerDiv(105,"timeline-band-highlights");
this._highlightLayer.style.display="none";
if(this._lineLayer!=null){b.removeLayerDiv(this._lineLayer)
}this._lineLayer=b.createLayerDiv(110,"timeline-band-lines");
this._lineLayer.style.display="none";
if(this._eventLayer!=null){b.removeLayerDiv(this._eventLayer)
}this._eventLayer=b.createLayerDiv(115,"timeline-band-events");
this._eventLayer.style.display="none"
};
Timeline.OriginalEventPainter.prototype.paintEvent=function(d,c,b,a){if(d.isInstant()){this.paintInstantEvent(d,c,b,a)
}else{this.paintDurationEvent(d,c,b,a)
}};
Timeline.OriginalEventPainter.prototype.paintInstantEvent=function(d,c,b,a){if(d.isImprecise()){this.paintImpreciseInstantEvent(d,c,b,a)
}else{this.paintPreciseInstantEvent(d,c,b,a)
}};
Timeline.OriginalEventPainter.prototype.paintDurationEvent=function(d,c,b,a){if(d.isImprecise()){this.paintImpreciseDurationEvent(d,c,b,a)
}else{this.paintPreciseDurationEvent(d,c,b,a)
}};
Timeline.OriginalEventPainter.prototype.paintPreciseInstantEvent=function(j,e,b,d){var a=this._timeline.getDocument();
var l=j.getText();
var p=j.getStart();
var o=Math.round(this._band.dateToPixelOffset(p));
var t=Math.round(o+e.iconWidth/2);
var r=Math.round(o-e.iconWidth/2);
var q=this._frc.computeSize(l);
var k=t+b.event.label.offsetFromLine;
var n=k+q.width;
var g=n;
var h=this._findFreeTrack(g);
var f=Math.round(e.trackOffset+h*e.trackIncrement+e.trackHeight/2-q.height/2);
var s=this._paintEventIcon(j,h,r,e,b);
var c=this._paintEventLabel(j,l,k,f,q.width,q.height,b);
var i=this;
var m=function(v,w,u){return i._onClickInstantEvent(s.elmt,w,j)
};
SimileAjax.DOM.registerEvent(s.elmt,"mousedown",m);
SimileAjax.DOM.registerEvent(c.elmt,"mousedown",m);
this._createHighlightDiv(d,s,b);
this._eventIdToElmt[j.getID()]=s.elmt;
this._tracks[h]=r
};
Timeline.OriginalEventPainter.prototype.paintImpreciseInstantEvent=function(l,g,b,e){var a=this._timeline.getDocument();
var n=l.getText();
var r=l.getStart();
var d=l.getEnd();
var q=Math.round(this._band.dateToPixelOffset(r));
var w=Math.round(this._band.dateToPixelOffset(d));
var x=Math.round(q+g.iconWidth/2);
var u=Math.round(q-g.iconWidth/2);
var s=this._frc.computeSize(n);
var m=x+b.event.label.offsetFromLine;
var p=m+s.width;
var i=Math.max(p,w);
var j=this._findFreeTrack(i);
var h=Math.round(g.trackOffset+j*g.trackIncrement+g.trackHeight/2-s.height/2);
var v=this._paintEventIcon(l,j,u,g,b);
var c=this._paintEventLabel(l,n,m,h,s.width,s.height,b);
var f=l.getColor();
f=f!=null?f:b.event.instant.impreciseColor;
var t=this._paintEventTape(l,j,q,w,f,b.event.instant.impreciseOpacity,g,b);
var k=this;
var o=function(z,A,y){return k._onClickInstantEvent(v.elmt,A,l)
};
SimileAjax.DOM.registerEvent(v.elmt,"mousedown",o);
SimileAjax.DOM.registerEvent(t.elmt,"mousedown",o);
SimileAjax.DOM.registerEvent(c.elmt,"mousedown",o);
this._createHighlightDiv(e,v,b);
this._eventIdToElmt[l.getID()]=v.elmt;
this._tracks[j]=u
};
Timeline.OriginalEventPainter.prototype.paintPreciseDurationEvent=function(l,g,b,e){var a=this._timeline.getDocument();
var n=l.getText();
var r=l.getStart();
var d=l.getEnd();
var q=Math.round(this._band.dateToPixelOffset(r));
var u=Math.round(this._band.dateToPixelOffset(d));
var s=this._frc.computeSize(n);
var m=q;
var p=m+s.width;
var i=Math.max(p,u);
var j=this._findFreeTrack(i);
var h=Math.round(g.trackOffset+j*g.trackIncrement+b.event.tape.height);
var f=l.getColor();
f=f!=null?f:b.event.duration.color;
var t=this._paintEventTape(l,j,q,u,f,100,g,b);
var c=this._paintEventLabel(l,n,m,h,s.width,s.height,b);
var k=this;
var o=function(v,w,x){return k._onClickDurationEvent(t.elmt,w,l)
};
SimileAjax.DOM.registerEvent(t.elmt,"mousedown",o);
SimileAjax.DOM.registerEvent(c.elmt,"mousedown",o);
this._createHighlightDiv(e,t,b);
this._eventIdToElmt[l.getID()]=t.elmt;
this._tracks[j]=q
};
Timeline.OriginalEventPainter.prototype.paintImpreciseDurationEvent=function(o,g,b,e){var a=this._timeline.getDocument();
var q=o.getText();
var u=o.getStart();
var h=o.getLatestStart();
var d=o.getEnd();
var m=o.getEarliestEnd();
var t=Math.round(this._band.dateToPixelOffset(u));
var w=Math.round(this._band.dateToPixelOffset(h));
var z=Math.round(this._band.dateToPixelOffset(d));
var v=Math.round(this._band.dateToPixelOffset(m));
var x=this._frc.computeSize(q);
var p=w;
var s=p+x.width;
var k=Math.max(s,z);
var l=this._findFreeTrack(k);
var j=Math.round(g.trackOffset+l*g.trackIncrement+b.event.tape.height);
var f=o.getColor();
f=f!=null?f:b.event.duration.color;
var i=this._paintEventTape(o,l,t,z,b.event.duration.impreciseColor,b.event.duration.impreciseOpacity,g,b);
var y=this._paintEventTape(o,l,w,v,f,100,g,b);
var c=this._paintEventLabel(o,q,p,j,x.width,x.height,b);
var n=this;
var r=function(A,B,C){return n._onClickDurationEvent(y.elmt,B,o)
};
SimileAjax.DOM.registerEvent(y.elmt,"mousedown",r);
SimileAjax.DOM.registerEvent(c.elmt,"mousedown",r);
this._createHighlightDiv(e,y,b);
this._eventIdToElmt[o.getID()]=y.elmt;
this._tracks[l]=t
};
Timeline.OriginalEventPainter.prototype._findFreeTrack=function(b){for(var c=0;
c<this._tracks.length;
c++){var a=this._tracks[c];
if(a>b){break
}}return c
};
Timeline.OriginalEventPainter.prototype._paintEventIcon=function(e,c,b,i,j){var g=e.getIcon();
g=g!=null?g:i.icon;
var h=i.trackOffset+c*i.trackIncrement+i.trackHeight/2;
var f=Math.round(h-i.iconHeight/2);
var a=SimileAjax.Graphics.createTranslucentImage(g);
var d=this._timeline.getDocument().createElement("div");
d.className="timeline-event-icon";
d.style.left=b+"px";
d.style.top=f+"px";
d.appendChild(a);
if(e._title!=null){d.title=e._title
}this._eventLayer.appendChild(d);
return{left:b,top:f,width:i.iconWidth,height:i.iconHeight,elmt:d}
};
Timeline.OriginalEventPainter.prototype._paintEventLabel=function(f,e,b,i,d,h,j){var g=this._timeline.getDocument();
var c=g.createElement("div");
c.className="timeline-event-label";
c.style.left=b+"px";
c.style.width=d+"px";
c.style.top=i+"px";
c.innerHTML=e;
if(f._title!=null){c.title=f._title
}var a=f.getTextColor();
if(a==null){a=f.getColor()
}if(a!=null){c.style.color=a
}var k=f.getClassName();
if(k!=null){c.className+=" "+k
}this._eventLayer.appendChild(c);
return{left:b,top:i,width:d,height:h,elmt:c}
};
Timeline.OriginalEventPainter.prototype._paintEventTape=function(f,c,a,d,m,b,i,j){var n=d-a;
var o=j.event.tape.height;
var h=i.trackOffset+c*i.trackIncrement;
var e=this._timeline.getDocument().createElement("div");
e.className="timeline-event-tape";
e.style.left=a+"px";
e.style.width=n+"px";
e.style.top=h+"px";
if(f._title!=null){e.title=f._title
}if(m!=null){e.style.backgroundColor=m
}var g=f.getTapeImage();
var l=f.getTapeRepeat();
l=l!=null?l:"repeat";
if(g!=null){e.style.backgroundImage="url("+g+")";
e.style.backgroundRepeat=l
}SimileAjax.Graphics.setOpacity(e,b);
var k=f.getClassName();
if(k!=null){e.className+=" "+k
}this._eventLayer.appendChild(e);
return{left:a,top:h,width:n,height:o,elmt:e}
};
Timeline.OriginalEventPainter.prototype._createHighlightDiv=function(a,f,d){if(a>=0){var e=this._timeline.getDocument();
var b=d.event;
var g=b.highlightColors[Math.min(a,b.highlightColors.length-1)];
var c=e.createElement("div");
c.style.position="absolute";
c.style.overflow="hidden";
c.style.left=(f.left-2)+"px";
c.style.width=(f.width+4)+"px";
c.style.top=(f.top-2)+"px";
c.style.height=(f.height+4)+"px";
this._highlightLayer.appendChild(c)
}};
Timeline.OriginalEventPainter.prototype._onClickInstantEvent=function(c,a,d){var b=SimileAjax.DOM.getPageCoordinates(c);
this._showBubble(b.left+Math.ceil(c.offsetWidth/2),b.top+Math.ceil(c.offsetHeight/2),d);
this._fireOnSelect(d.getID());
a.cancelBubble=true;
SimileAjax.DOM.cancelEvent(a);
return false
};
Timeline.OriginalEventPainter.prototype._onClickDurationEvent=function(b,f,e){if("pageX" in f){var a=f.pageX;
var c=f.pageY
}else{var d=SimileAjax.DOM.getPageCoordinates(b);
var a=f.offsetX+d.left;
var c=f.offsetY+d.top
}this._showBubble(a,c,e);
this._fireOnSelect(e.getID());
f.cancelBubble=true;
SimileAjax.DOM.cancelEvent(f);
return false
};
Timeline.OriginalEventPainter.prototype.showBubble=function(a){var c=this._eventIdToElmt[a.getID()];
if(c){var b=SimileAjax.DOM.getPageCoordinates(c);
this._showBubble(b.left+c.offsetWidth/2,b.top+c.offsetHeight/2,a)
}};
Timeline.OriginalEventPainter.prototype._showBubble=function(a,b,d){var c=document.createElement("div");
d.fillInfoBubble(c,this._params.theme,this._band.getLabeller());
SimileAjax.WindowManager.cancelPopups();
SimileAjax.Graphics.createBubbleForContentAndPoint(c,a,b,this._params.theme.event.bubble.width)
};
Timeline.OriginalEventPainter.prototype._fireOnSelect=function(a){for(var b=0;
b<this._onSelectListeners.length;
b++){this._onSelectListeners[b](a)
}};
Timeline.OverviewEventPainter=function(a){this._params=a;
this._onSelectListeners=[];
this._filterMatcher=null;
this._highlightMatcher=null
};
Timeline.OverviewEventPainter.prototype.initialize=function(b,a){this._band=b;
this._timeline=a;
this._eventLayer=null;
this._highlightLayer=null
};
Timeline.OverviewEventPainter.prototype.addOnSelectListener=function(a){this._onSelectListeners.push(a)
};
Timeline.OverviewEventPainter.prototype.removeOnSelectListener=function(b){for(var a=0;
a<this._onSelectListeners.length;
a++){if(this._onSelectListeners[a]==b){this._onSelectListeners.splice(a,1);
break
}}};
Timeline.OverviewEventPainter.prototype.getFilterMatcher=function(){return this._filterMatcher
};
Timeline.OverviewEventPainter.prototype.setFilterMatcher=function(a){this._filterMatcher=a
};
Timeline.OverviewEventPainter.prototype.getHighlightMatcher=function(){return this._highlightMatcher
};
Timeline.OverviewEventPainter.prototype.setHighlightMatcher=function(a){this._highlightMatcher=a
};
Timeline.OverviewEventPainter.prototype.paint=function(){var b=this._band.getEventSource();
if(b==null){return
}this._prepareForPainting();
var f=this._params.theme.event;
var h={trackOffset:f.overviewTrack.offset,trackHeight:f.overviewTrack.height,trackGap:f.overviewTrack.gap,trackIncrement:f.overviewTrack.height+f.overviewTrack.gap};
var a=this._band.getMinDate();
var c=this._band.getMaxDate();
var e=(this._filterMatcher!=null)?this._filterMatcher:function(j){return true
};
var d=(this._highlightMatcher!=null)?this._highlightMatcher:function(j){return -1
};
var i=b.getEventReverseIterator(a,c);
while(i.hasNext()){var g=i.next();
if(e(g)){this.paintEvent(g,h,this._params.theme,d(g))
}}this._highlightLayer.style.display="block";
this._eventLayer.style.display="block"
};
Timeline.OverviewEventPainter.prototype.softPaint=function(){};
Timeline.OverviewEventPainter.prototype._prepareForPainting=function(){var a=this._band;
this._tracks=[];
if(this._highlightLayer!=null){a.removeLayerDiv(this._highlightLayer)
}this._highlightLayer=a.createLayerDiv(105,"timeline-band-highlights");
this._highlightLayer.style.display="none";
if(this._eventLayer!=null){a.removeLayerDiv(this._eventLayer)
}this._eventLayer=a.createLayerDiv(110,"timeline-band-events");
this._eventLayer.style.display="none"
};
Timeline.OverviewEventPainter.prototype.paintEvent=function(d,c,b,a){if(d.isInstant()){this.paintInstantEvent(d,c,b,a)
}else{this.paintDurationEvent(d,c,b,a)
}};
Timeline.OverviewEventPainter.prototype.paintInstantEvent=function(h,e,c,a){var d=h.getStart();
var b=Math.round(this._band.dateToPixelOffset(d));
var g=h.getColor();
g=g!=null?g:c.event.duration.color;
var f=this._paintEventTick(h,b,g,100,e,c);
this._createHighlightDiv(a,f,c)
};
Timeline.OverviewEventPainter.prototype.paintDurationEvent=function(e,f,i,c){var d=e.getLatestStart();
var h=e.getEarliestEnd();
var g=Math.round(this._band.dateToPixelOffset(d));
var b=Math.round(this._band.dateToPixelOffset(h));
var j=0;
for(;
j<this._tracks.length;
j++){if(b<this._tracks[j]){break
}}this._tracks[j]=b;
var k=e.getColor();
k=k!=null?k:i.event.duration.color;
var a=this._paintEventTape(e,j,g,b,k,100,f,i);
this._createHighlightDiv(c,a,i)
};
Timeline.OverviewEventPainter.prototype._paintEventTape=function(g,c,a,f,l,b,j,k){var i=j.trackOffset+c*j.trackIncrement;
var d=f-a;
var h=j.trackHeight;
var e=this._timeline.getDocument().createElement("div");
e.className="timeline-small-event-tape";
e.style.left=a+"px";
e.style.width=d+"px";
e.style.top=i+"px";
if(b<100){SimileAjax.Graphics.setOpacity(e,b)
}this._eventLayer.appendChild(e);
return{left:a,top:i,width:d,height:h,elmt:e}
};
Timeline.OverviewEventPainter.prototype._paintEventTick=function(f,b,a,c,i,j){var g=j.event.overviewTrack.tickHeight;
var h=i.trackOffset-g;
var d=1;
var e=this._timeline.getDocument().createElement("div");
e.className="timeline-small-event-icon";
e.style.left=b+"px";
e.style.top=h+"px";
var k=f.getClassName();
if(k){e.className+=" small-"+k
}if(c<100){SimileAjax.Graphics.setOpacity(e,c)
}this._eventLayer.appendChild(e);
return{left:b,top:h,width:d,height:g,elmt:e}
};
Timeline.OverviewEventPainter.prototype._createHighlightDiv=function(a,f,d){if(a>=0){var e=this._timeline.getDocument();
var b=d.event;
var g=b.highlightColors[Math.min(a,b.highlightColors.length-1)];
var c=e.createElement("div");
c.style.position="absolute";
c.style.overflow="hidden";
c.style.left=(f.left-1)+"px";
c.style.width=(f.width+2)+"px";
c.style.top=(f.top-1)+"px";
c.style.height=(f.height+2)+"px";
c.style.background=g;
this._highlightLayer.appendChild(c)
}};
Timeline.OverviewEventPainter.prototype.showBubble=function(a){};
Timeline.DefaultEventSource=function(a){this._events=(a instanceof Object)?a:new SimileAjax.EventIndex();
this._listeners=[]
};
Timeline.DefaultEventSource.prototype.addListener=function(a){this._listeners.push(a)
};
Timeline.DefaultEventSource.prototype.removeListener=function(b){for(var a=0;
a<this._listeners.length;
a++){if(this._listeners[a]==b){this._listeners.splice(a,1);
break
}}};
Timeline.DefaultEventSource.prototype.loadXML=function(j,d){var c=this._getBaseURL(d);
var i=j.documentElement.getAttribute("wiki-url");
var g=j.documentElement.getAttribute("wiki-section");
var k=j.documentElement.getAttribute("date-time-format");
var a=this._events.getUnit().getParser(k);
var b=j.documentElement.firstChild;
var h=false;
while(b!=null){if(b.nodeType==1){var e="";
if(b.firstChild!=null&&b.firstChild.nodeType==3){e=b.firstChild.nodeValue
}var f=new Timeline.DefaultEventSource.Event({id:b.getAttribute("id"),start:a(b.getAttribute("start")),end:a(b.getAttribute("end")),latestStart:a(b.getAttribute("latestStart")),earliestEnd:a(b.getAttribute("earliestEnd")),instant:b.getAttribute("isDuration")!="true",text:b.getAttribute("title"),description:e,image:this._resolveRelativeURL(b.getAttribute("image"),c),link:this._resolveRelativeURL(b.getAttribute("link"),c),icon:this._resolveRelativeURL(b.getAttribute("icon"),c),color:b.getAttribute("color"),textColor:b.getAttribute("textColor"),hoverText:b.getAttribute("hoverText"),classname:b.getAttribute("classname"),tapeImage:b.getAttribute("tapeImage"),tapeRepeat:b.getAttribute("tapeRepeat"),caption:b.getAttribute("caption"),eventID:b.getAttribute("eventID")});
f._node=b;
f.getProperty=function(l){return this._node.getAttribute(l)
};
f.setWikiInfo(i,g);
this._events.add(f);
h=true
}b=b.nextSibling
}if(h){this._fire("onAddMany",[])
}};
Timeline.DefaultEventSource.prototype.loadJSON=function(i,c){var b=this._getBaseURL(c);
var g=false;
if(i&&i.events){var h=("wikiURL" in i)?i.wikiURL:null;
var f=("wikiSection" in i)?i.wikiSection:null;
var k=("dateTimeFormat" in i)?i.dateTimeFormat:null;
var a=this._events.getUnit().getParser(k);
for(var j=0;
j<i.events.length;
j++){var d=i.events[j];
var e=new Timeline.DefaultEventSource.Event({id:("id" in d)?d.id:undefined,start:a(d.start),end:a(d.end),latestStart:a(d.latestStart),earliestEnd:a(d.earliestEnd),instant:d.isDuration||false,text:d.title,description:d.description,image:this._resolveRelativeURL(d.image,b),link:this._resolveRelativeURL(d.link,b),icon:this._resolveRelativeURL(d.icon,b),color:d.color,textColor:d.textColor,hoverText:d.hoverText,classname:d.classname,tapeImage:d.tapeImage,tapeRepeat:d.tapeRepeat,caption:d.caption,eventID:d.eventID});
e._obj=d;
e.getProperty=function(l){return this._obj[l]
};
e.setWikiInfo(h,f);
this._events.add(e);
g=true
}}if(g){this._fire("onAddMany",[])
}};
Timeline.DefaultEventSource.prototype.loadSPARQL=function(i,c){var a=this._getBaseURL(c);
var j="iso8601";
var k=this._events.getUnit().getParser(j);
if(i==null){return
}var l=i.documentElement.firstChild;
while(l!=null&&(l.nodeType!=1||l.nodeName!="results")){l=l.nextSibling
}var h=null;
var f=null;
if(l!=null){h=l.getAttribute("wiki-url");
f=l.getAttribute("wiki-section");
l=l.firstChild
}var g=false;
while(l!=null){if(l.nodeType==1){var b={};
var d=l.firstChild;
while(d!=null){if(d.nodeType==1&&d.firstChild!=null&&d.firstChild.nodeType==1&&d.firstChild.firstChild!=null&&d.firstChild.firstChild.nodeType==3){b[d.getAttribute("name")]=d.firstChild.firstChild.nodeValue
}d=d.nextSibling
}if(b.start==null&&b.date!=null){b.start=b.date
}var e=new Timeline.DefaultEventSource.Event({id:b.id,start:k(b.start),end:k(b.end),latestStart:k(b.latestStart),earliestEnd:k(b.earliestEnd),instant:b.isDuration!="true",text:b.title,description:b.description,image:this._resolveRelativeURL(b.image,a),link:this._resolveRelativeURL(b.link,a),icon:this._resolveRelativeURL(b.icon,a),color:b.color,textColor:b.textColor,hoverText:b.hoverText,caption:b.caption,classname:b.classname,tapeImage:b.tapeImage,tapeRepeat:b.tapeRepeat,eventID:b.eventID});
e._bindings=b;
e.getProperty=function(m){return this._bindings[m]
};
e.setWikiInfo(h,f);
this._events.add(e);
g=true
}l=l.nextSibling
}if(g){this._fire("onAddMany",[])
}};
Timeline.DefaultEventSource.prototype.add=function(a){this._events.add(a);
this._fire("onAddOne",[a])
};
Timeline.DefaultEventSource.prototype.addMany=function(a){for(var b=0;
b<a.length;
b++){this._events.add(a[b])
}this._fire("onAddMany",[])
};
Timeline.DefaultEventSource.prototype.clear=function(){this._events.removeAll();
this._fire("onClear",[])
};
Timeline.DefaultEventSource.prototype.getEvent=function(a){return this._events.getEvent(a)
};
Timeline.DefaultEventSource.prototype.getEventIterator=function(a,b){return this._events.getIterator(a,b)
};
Timeline.DefaultEventSource.prototype.getEventReverseIterator=function(a,b){return this._events.getReverseIterator(a,b)
};
Timeline.DefaultEventSource.prototype.getAllEventIterator=function(){return this._events.getAllIterator()
};
Timeline.DefaultEventSource.prototype.getCount=function(){return this._events.getCount()
};
Timeline.DefaultEventSource.prototype.getEarliestDate=function(){return this._events.getEarliestDate()
};
Timeline.DefaultEventSource.prototype.getLatestDate=function(){return this._events.getLatestDate()
};
Timeline.DefaultEventSource.prototype._fire=function(e,a){for(var d=0;
d<this._listeners.length;
d++){var c=this._listeners[d];
if(e in c){try{c[e].apply(c,a)
}catch(b){SimileAjax.Debug.exception(b)
}}}};
Timeline.DefaultEventSource.prototype._getBaseURL=function(a){if(a.indexOf("://")<0){var b=this._getBaseURL(document.location.href);
if(a.substr(0,1)=="/"){a=b.substr(0,b.indexOf("/",b.indexOf("://")+3))+a
}else{a=b+a
}}var c=a.lastIndexOf("/");
if(c<0){return""
}else{return a.substr(0,c+1)
}};
Timeline.DefaultEventSource.prototype._resolveRelativeURL=function(a,b){if(a==null||a==""){return a
}else{if(a.indexOf("://")>0){return a
}else{if(a.substr(0,1)=="/"){return b.substr(0,b.indexOf("/",b.indexOf("://")+3))+a
}else{return b+a
}}}};
Timeline.DefaultEventSource.Event=function(a){function b(d){return(a[d]!=null&&a[d]!="")?a[d]:null
}var c=(a.id)?a.id.trim():"";
this._id=c.length>0?c:("e"+Math.floor(Math.random()*1000000));
this._instant=a.instant||(a.end==null);
this._start=a.start;
this._end=(a.end!=null)?a.end:a.start;
this._latestStart=(a.latestStart!=null)?a.latestStart:(a.instant?this._end:this._start);
this._earliestEnd=(a.earliestEnd!=null)?a.earliestEnd:(a.instant?this._start:this._end);
this._eventID=b("eventID");
this._text=SimileAjax.HTML.deEntify(a.text);
this._description=SimileAjax.HTML.deEntify(a.description);
this._image=b("image");
this._link=b("link");
this._title=b("hoverText");
this._title=b("caption");
this._icon=b("icon");
this._color=b("color");
this._textColor=b("textColor");
this._classname=b("classname");
this._tapeImage=b("tapeImage");
this._tapeRepeat=b("tapeRepeat");
this._wikiURL=null;
this._wikiSection=null
};
Timeline.DefaultEventSource.Event.prototype={getID:function(){return this._id
},isInstant:function(){return this._instant
},isImprecise:function(){return this._start!=this._latestStart||this._end!=this._earliestEnd
},getStart:function(){return this._start
},getEnd:function(){return this._end
},getLatestStart:function(){return this._latestStart
},getEarliestEnd:function(){return this._earliestEnd
},getEventID:function(){return this._eventID
},getText:function(){return this._text
},getDescription:function(){return this._description
},getImage:function(){return this._image
},getLink:function(){return this._link
},getIcon:function(){return this._icon
},getColor:function(){return this._color
},getTextColor:function(){return this._textColor
},getClassName:function(){return this._classname
},getTapeImage:function(){return this._tapeImage
},getTapeRepeat:function(){return this._tapeRepeat
},getProperty:function(a){return null
},getWikiURL:function(){return this._wikiURL
},getWikiSection:function(){return this._wikiSection
},setWikiInfo:function(b,a){this._wikiURL=b;
this._wikiSection=a
},fillDescription:function(a){a.innerHTML=this._description
},fillWikiInfo:function(b){if(this._wikiURL!=null&&this._wikiSection!=null){var c=this.getProperty("wikiID");
if(c==null||c.length==0){c=this.getText()
}c=c.replace(/\s/g,"_");
var d=this._wikiURL+this._wikiSection.replace(/\s/g,"_")+"/"+c;
var a=document.createElement("a");
a.href=d;
a.target="new";
a.innerHTML=Timeline.strings[Timeline.clientLocale].wikiLinkLabel;
b.appendChild(document.createTextNode("["));
b.appendChild(a);
b.appendChild(document.createTextNode("]"))
}else{b.style.display="none"
}},fillTime:function(a,b){if(this._instant){if(this.isImprecise()){a.appendChild(a.ownerDocument.createTextNode(b.labelPrecise(this._start)));
a.appendChild(a.ownerDocument.createElement("br"));
a.appendChild(a.ownerDocument.createTextNode(b.labelPrecise(this._end)))
}else{a.appendChild(a.ownerDocument.createTextNode(b.labelPrecise(this._start)))
}}else{if(this.isImprecise()){a.appendChild(a.ownerDocument.createTextNode(b.labelPrecise(this._start)+" ~ "+b.labelPrecise(this._latestStart)));
a.appendChild(a.ownerDocument.createElement("br"));
a.appendChild(a.ownerDocument.createTextNode(b.labelPrecise(this._earliestEnd)+" ~ "+b.labelPrecise(this._end)))
}else{a.appendChild(a.ownerDocument.createTextNode(b.labelPrecise(this._start)));
a.appendChild(a.ownerDocument.createElement("br"));
a.appendChild(a.ownerDocument.createTextNode(b.labelPrecise(this._end)))
}}},fillInfoBubble:function(d,n,f){var h=d.ownerDocument;
var i=this.getText();
var k=this.getLink();
var c=this.getImage();
if(c!=null){var a=h.createElement("img");
a.src=c;
n.event.bubble.imageStyler(a);
d.appendChild(a)
}var g=h.createElement("div");
var b=h.createTextNode(i);
if(k!=null){var j=h.createElement("a");
j.href=k;
j.appendChild(b);
g.appendChild(j)
}else{g.appendChild(b)
}n.event.bubble.titleStyler(g);
d.appendChild(g);
var e=h.createElement("div");
this.fillDescription(e);
n.event.bubble.bodyStyler(e);
d.appendChild(e);
var l=h.createElement("div");
this.fillTime(l,f);
n.event.bubble.timeStyler(l);
d.appendChild(l);
var m=h.createElement("div");
this.fillWikiInfo(m);
n.event.bubble.wikiStyler(m);
d.appendChild(m)
}};
Timeline.ClassicTheme=new Object();
Timeline.ClassicTheme.implementations=[];
Timeline.ClassicTheme.create=function(b){if(b==null){b=Timeline.getDefaultLocale()
}var a=Timeline.ClassicTheme.implementations[b];
if(a==null){a=Timeline.ClassicTheme._Impl
}return new a()
};
Timeline.ClassicTheme._Impl=function(){this.firstDayOfWeek=0;
this.ether={backgroundColors:[],highlightOpacity:50,interval:{line:{show:true,opacity:25},weekend:{opacity:30},marker:{hAlign:"Bottom",vAlign:"Right"}}};
this.event={track:{height:10,gap:2},overviewTrack:{offset:20,tickHeight:6,height:2,gap:1},tape:{height:4},instant:{icon:Timeline.urlPrefix+"images/dull-blue-circle.png",iconWidth:10,iconHeight:10,impreciseOpacity:20},duration:{impreciseOpacity:20},label:{backgroundOpacity:50,offsetFromLine:3},highlightColors:[],bubble:{width:250,height:125,titleStyler:function(a){a.className="timeline-event-bubble-title"
},bodyStyler:function(a){a.className="timeline-event-bubble-body"
},imageStyler:function(a){a.className="timeline-event-bubble-image"
},wikiStyler:function(a){a.className="timeline-event-bubble-wiki"
},timeStyler:function(a){a.className="timeline-event-bubble-time"
}}};
this.mouseWheel="scroll"
};
Timeline.strings={};
Timeline.getDefaultLocale=function(){return Timeline.clientLocale
};
Timeline.create=function(d,a,c,b){return new Timeline._Impl(d,a,c,b)
};
Timeline.HORIZONTAL=0;
Timeline.VERTICAL=1;
Timeline._defaultTheme=null;
Timeline.createBandInfo=function(h){var g=("theme" in h)?h.theme:Timeline.getDefaultTheme();
var a=("eventSource" in h)?h.eventSource:null;
var f=new Timeline.LinearEther({centersOn:("date" in h)?h.date:new Date(),interval:SimileAjax.DateTime.gregorianUnitLengths[h.intervalUnit],pixelsPerInterval:h.intervalPixels,theme:g});
var b=new Timeline.GregorianEtherPainter({unit:h.intervalUnit,multiple:("multiple" in h)?h.multiple:1,theme:g,align:("align" in h)?h.align:undefined});
var e={showText:("showEventText" in h)?h.showEventText:true,theme:g};
if("eventPainterParams" in h){for(var d in h.eventPainterParams){e[d]=h.eventPainterParams[d]
}}if("trackHeight" in h){e.trackHeight=h.trackHeight
}if("trackGap" in h){e.trackGap=h.trackGap
}var c=("overview" in h&&h.overview)?"overview":("layout" in h?h.layout:"original");
var i;
if("eventPainter" in h){i=new h.eventPainter(e)
}else{switch(c){case"overview":i=new Timeline.OverviewEventPainter(e);
break;
case"detailed":i=new Timeline.DetailedEventPainter(e);
break;
default:i=new Timeline.OriginalEventPainter(e)
}}return{width:h.width,eventSource:a,timeZone:("timeZone" in h)?h.timeZone:0,ether:f,etherPainter:b,eventPainter:i,theme:g,zoomIndex:("zoomIndex" in h)?h.zoomIndex:0,zoomSteps:("zoomSteps" in h)?h.zoomSteps:null}
};
Timeline.createHotZoneBandInfo=function(h){var g=("theme" in h)?h.theme:Timeline.getDefaultTheme();
var a=("eventSource" in h)?h.eventSource:null;
var f=new Timeline.HotZoneEther({centersOn:("date" in h)?h.date:new Date(),interval:SimileAjax.DateTime.gregorianUnitLengths[h.intervalUnit],pixelsPerInterval:h.intervalPixels,zones:h.zones,theme:g});
var b=new Timeline.HotZoneGregorianEtherPainter({unit:h.intervalUnit,zones:h.zones,theme:g,align:("align" in h)?h.align:undefined});
var e={showText:("showEventText" in h)?h.showEventText:true,theme:g};
if("eventPainterParams" in h){for(var d in h.eventPainterParams){e[d]=h.eventPainterParams[d]
}}if("trackHeight" in h){e.trackHeight=h.trackHeight
}if("trackGap" in h){e.trackGap=h.trackGap
}var c=("overview" in h&&h.overview)?"overview":("layout" in h?h.layout:"original");
var i;
if("eventPainter" in h){i=new h.eventPainter(e)
}else{switch(c){case"overview":i=new Timeline.OverviewEventPainter(e);
break;
case"detailed":i=new Timeline.DetailedEventPainter(e);
break;
default:i=new Timeline.OriginalEventPainter(e)
}}return{width:h.width,eventSource:a,timeZone:("timeZone" in h)?h.timeZone:0,ether:f,etherPainter:b,eventPainter:i,theme:g,zoomIndex:("zoomIndex" in h)?h.zoomIndex:0,zoomSteps:("zoomSteps" in h)?h.zoomSteps:null}
};
Timeline.getDefaultTheme=function(){if(Timeline._defaultTheme==null){Timeline._defaultTheme=Timeline.ClassicTheme.create(Timeline.getDefaultLocale())
}return Timeline._defaultTheme
};
Timeline.setDefaultTheme=function(a){Timeline._defaultTheme=a
};
Timeline.loadXML=function(a,c){var b=function(e,f,g){alert("Failed to load data xml from "+a+"\n"+e)
};
var d=function(e){var f=e.responseXML;
if(!f.documentElement&&e.responseStream){f.load(e.responseStream)
}c(f,a)
};
SimileAjax.XmlHttp.get(a,b,d)
};
Timeline.loadJSON=function(url,f){var fError=function(statusText,status,xmlhttp){alert("Failed to load json data from "+url+"\n"+statusText)
};
var fDone=function(xmlhttp){f(eval("("+xmlhttp.responseText+")"),url)
};
SimileAjax.XmlHttp.get(url,fError,fDone)
};
Timeline._Impl=function(d,a,c,b){SimileAjax.WindowManager.initialize();
this._containerDiv=d;
this._bandInfos=a;
this._orientation=c==null?Timeline.HORIZONTAL:c;
this._unit=(b!=null)?b:SimileAjax.NativeDateUnit;
this._initialize()
};
Timeline._Impl.prototype.dispose=function(){for(var a=0;
a<this._bands.length;
a++){this._bands[a].dispose()
}this._bands=null;
this._bandInfos=null;
this._containerDiv.innerHTML=""
};
Timeline._Impl.prototype.getBandCount=function(){return this._bands.length
};
Timeline._Impl.prototype.getBand=function(a){return this._bands[a]
};
Timeline._Impl.prototype.layout=function(){this._distributeWidths()
};
Timeline._Impl.prototype.paint=function(){for(var a=0;
a<this._bands.length;
a++){this._bands[a].paint()
}};
Timeline._Impl.prototype.getDocument=function(){return this._containerDiv.ownerDocument
};
Timeline._Impl.prototype.addDiv=function(a){this._containerDiv.appendChild(a)
};
Timeline._Impl.prototype.removeDiv=function(a){this._containerDiv.removeChild(a)
};
Timeline._Impl.prototype.isHorizontal=function(){return this._orientation==Timeline.HORIZONTAL
};
Timeline._Impl.prototype.isVertical=function(){return this._orientation==Timeline.VERTICAL
};
Timeline._Impl.prototype.getPixelLength=function(){return this._orientation==Timeline.HORIZONTAL?this._containerDiv.offsetWidth:this._containerDiv.offsetHeight
};
Timeline._Impl.prototype.getPixelWidth=function(){return this._orientation==Timeline.VERTICAL?this._containerDiv.offsetWidth:this._containerDiv.offsetHeight
};
Timeline._Impl.prototype.getUnit=function(){return this._unit
};
Timeline._Impl.prototype.loadXML=function(e,c){var a=this;
var b=function(f,g,h){alert("Failed to load data xml from "+e+"\n"+f);
a.hideLoadingMessage()
};
var d=function(f){try{var g=f.responseXML;
if(!g.documentElement&&f.responseStream){g.load(f.responseStream)
}c(g,e)
}finally{a.hideLoadingMessage()
}};
this.showLoadingMessage();
window.setTimeout(function(){SimileAjax.XmlHttp.get(e,b,d)
},0)
};
Timeline._Impl.prototype.loadJSON=function(url,f){var tl=this;
var fError=function(statusText,status,xmlhttp){alert("Failed to load json data from "+url+"\n"+statusText);
tl.hideLoadingMessage()
};
var fDone=function(xmlhttp){try{f(eval("("+xmlhttp.responseText+")"),url)
}finally{tl.hideLoadingMessage()
}};
this.showLoadingMessage();
window.setTimeout(function(){SimileAjax.XmlHttp.get(url,fError,fDone)
},0)
};
Timeline._Impl.prototype._initialize=function(){var b=this._containerDiv;
var e=b.ownerDocument;
b.className=b.className.split(" ").concat("timeline-container").join(" ");
var g=(this.isHorizontal())?"horizontal":"vertical";
b.className+=" timeline-"+g;
while(b.firstChild){b.removeChild(b.firstChild)
}var a=SimileAjax.Graphics.createTranslucentImage(Timeline.urlPrefix+(this.isHorizontal()?"images/copyright-vertical.png":"images/copyright.png"));
a.className="timeline-copyright";
a.title="Timeline (c) SIMILE - http://simile.mit.edu/timeline/";
SimileAjax.DOM.registerEvent(a,"click",function(){window.location="http://simile.mit.edu/timeline/"
});
b.appendChild(a);
this._bands=[];
for(var h=0;
h<this._bandInfos.length;
h++){var c=new Timeline._Band(this,this._bandInfos[h],h);
this._bands.push(c)
}this._distributeWidths();
for(var h=0;
h<this._bandInfos.length;
h++){var d=this._bandInfos[h];
if("syncWith" in d){this._bands[h].setSyncWithBand(this._bands[d.syncWith],("highlight" in d)?d.highlight:false)
}}var f=SimileAjax.Graphics.createMessageBubble(e);
f.containerDiv.className="timeline-message-container";
b.appendChild(f.containerDiv);
f.contentDiv.className="timeline-message";
f.contentDiv.innerHTML="<img src='"+Timeline.urlPrefix+"images/progress-running.gif' /> Loading...";
this.showLoadingMessage=function(){f.containerDiv.style.display="block"
};
this.hideLoadingMessage=function(){f.containerDiv.style.display="none"
}
};
Timeline._Impl.prototype._distributeWidths=function(){var h=this.getPixelLength();
var c=this.getPixelWidth();
var b=0;
for(var i=0;
i<this._bands.length;
i++){var e=this._bands[i];
var f=this._bandInfos[i];
var j=f.width;
var g=j.indexOf("%");
if(g>0){var d=parseInt(j.substr(0,g));
var a=d*c/100
}else{var a=parseInt(j)
}e.setBandShiftAndWidth(b,a);
e.setViewLength(h);
b+=a
}};
Timeline._Impl.prototype.zoom=function(e,a,b,c){var f=new RegExp("^timeline-band-([0-9]+)$");
var d=null;
var g=f.exec(c.id);
if(g){d=parseInt(g[1])
}if(d!=null){this._bands[d].zoom(e,a,b,c)
}this.paint()
};
Timeline._Band=function(g,b,f){this._timeline=g;
this._bandInfo=b;
this._index=f;
this._locale=("locale" in b)?b.locale:Timeline.getDefaultLocale();
this._timeZone=("timeZone" in b)?b.timeZone:0;
this._labeller=("labeller" in b)?b.labeller:(("createLabeller" in g.getUnit())?g.getUnit().createLabeller(this._locale,this._timeZone):new Timeline.GregorianDateLabeller(this._locale,this._timeZone));
this._theme=b.theme;
this._zoomIndex=("zoomIndex" in b)?b.zoomIndex:0;
this._zoomSteps=("zoomSteps" in b)?b.zoomSteps:null;
this._dragging=false;
this._changing=false;
this._originalScrollSpeed=5;
this._scrollSpeed=this._originalScrollSpeed;
this._onScrollListeners=[];
var a=this;
this._syncWithBand=null;
this._syncWithBandHandler=function(h){a._onHighlightBandScroll()
};
this._selectorListener=function(h){a._onHighlightBandScroll()
};
var d=this._timeline.getDocument().createElement("div");
d.className="timeline-band-input";
this._timeline.addDiv(d);
this._keyboardInput=document.createElement("input");
this._keyboardInput.type="text";
d.appendChild(this._keyboardInput);
SimileAjax.DOM.registerEventWithObject(this._keyboardInput,"keydown",this,"_onKeyDown");
SimileAjax.DOM.registerEventWithObject(this._keyboardInput,"keyup",this,"_onKeyUp");
this._div=this._timeline.getDocument().createElement("div");
this._div.id="timeline-band-"+f;
this._div.className="timeline-band timeline-band-"+f;
this._timeline.addDiv(this._div);
SimileAjax.DOM.registerEventWithObject(this._div,"mousedown",this,"_onMouseDown");
SimileAjax.DOM.registerEventWithObject(this._div,"mousemove",this,"_onMouseMove");
SimileAjax.DOM.registerEventWithObject(this._div,"mouseup",this,"_onMouseUp");
SimileAjax.DOM.registerEventWithObject(this._div,"mouseout",this,"_onMouseOut");
SimileAjax.DOM.registerEventWithObject(this._div,"dblclick",this,"_onDblClick");
var c=this._theme!=null?this._theme.mouseWheel:"scroll";
if(c==="zoom"||c==="scroll"||this._zoomSteps){if(SimileAjax.Platform.browser.isFirefox){SimileAjax.DOM.registerEventWithObject(this._div,"DOMMouseScroll",this,"_onMouseScroll")
}else{SimileAjax.DOM.registerEventWithObject(this._div,"mousewheel",this,"_onMouseScroll")
}}this._innerDiv=this._timeline.getDocument().createElement("div");
this._innerDiv.className="timeline-band-inner";
this._div.appendChild(this._innerDiv);
this._ether=b.ether;
b.ether.initialize(this,g);
this._etherPainter=b.etherPainter;
b.etherPainter.initialize(this,g);
this._eventSource=b.eventSource;
if(this._eventSource){this._eventListener={onAddMany:function(){a._onAddMany()
},onClear:function(){a._onClear()
}};
this._eventSource.addListener(this._eventListener)
}this._eventPainter=b.eventPainter;
b.eventPainter.initialize(this,g);
this._decorators=("decorators" in b)?b.decorators:[];
for(var e=0;
e<this._decorators.length;
e++){this._decorators[e].initialize(this,g)
}};
Timeline._Band.SCROLL_MULTIPLES=5;
Timeline._Band.prototype.dispose=function(){this.closeBubble();
if(this._eventSource){this._eventSource.removeListener(this._eventListener);
this._eventListener=null;
this._eventSource=null
}this._timeline=null;
this._bandInfo=null;
this._labeller=null;
this._ether=null;
this._etherPainter=null;
this._eventPainter=null;
this._decorators=null;
this._onScrollListeners=null;
this._syncWithBandHandler=null;
this._selectorListener=null;
this._div=null;
this._innerDiv=null;
this._keyboardInput=null
};
Timeline._Band.prototype.addOnScrollListener=function(a){this._onScrollListeners.push(a)
};
Timeline._Band.prototype.removeOnScrollListener=function(b){for(var a=0;
a<this._onScrollListeners.length;
a++){if(this._onScrollListeners[a]==b){this._onScrollListeners.splice(a,1);
break
}}};
Timeline._Band.prototype.setSyncWithBand=function(b,a){if(this._syncWithBand){this._syncWithBand.removeOnScrollListener(this._syncWithBandHandler)
}this._syncWithBand=b;
this._syncWithBand.addOnScrollListener(this._syncWithBandHandler);
this._highlight=a;
this._positionHighlight()
};
Timeline._Band.prototype.getLocale=function(){return this._locale
};
Timeline._Band.prototype.getTimeZone=function(){return this._timeZone
};
Timeline._Band.prototype.getLabeller=function(){return this._labeller
};
Timeline._Band.prototype.getIndex=function(){return this._index
};
Timeline._Band.prototype.getEther=function(){return this._ether
};
Timeline._Band.prototype.getEtherPainter=function(){return this._etherPainter
};
Timeline._Band.prototype.getEventSource=function(){return this._eventSource
};
Timeline._Band.prototype.getEventPainter=function(){return this._eventPainter
};
Timeline._Band.prototype.layout=function(){this.paint()
};
Timeline._Band.prototype.paint=function(){this._etherPainter.paint();
this._paintDecorators();
this._paintEvents()
};
Timeline._Band.prototype.softLayout=function(){this.softPaint()
};
Timeline._Band.prototype.softPaint=function(){this._etherPainter.softPaint();
this._softPaintDecorators();
this._softPaintEvents()
};
Timeline._Band.prototype.setBandShiftAndWidth=function(a,b){var c=this._keyboardInput.parentNode;
var d=a+Math.floor(b/2);
if(this._timeline.isHorizontal()){this._div.style.top=a+"px";
this._div.style.height=b+"px";
c.style.top=d+"px";
c.style.left="-1em"
}else{this._div.style.left=a+"px";
this._div.style.width=b+"px";
c.style.left=d+"px";
c.style.top="-1em"
}};
Timeline._Band.prototype.getViewWidth=function(){if(this._timeline.isHorizontal()){return this._div.offsetHeight
}else{return this._div.offsetWidth
}};
Timeline._Band.prototype.setViewLength=function(a){this._viewLength=a;
this._recenterDiv();
this._onChanging()
};
Timeline._Band.prototype.getViewLength=function(){return this._viewLength
};
Timeline._Band.prototype.getTotalViewLength=function(){return Timeline._Band.SCROLL_MULTIPLES*this._viewLength
};
Timeline._Band.prototype.getViewOffset=function(){return this._viewOffset
};
Timeline._Band.prototype.getMinDate=function(){return this._ether.pixelOffsetToDate(this._viewOffset)
};
Timeline._Band.prototype.getMaxDate=function(){return this._ether.pixelOffsetToDate(this._viewOffset+Timeline._Band.SCROLL_MULTIPLES*this._viewLength)
};
Timeline._Band.prototype.getMinVisibleDate=function(){return this._ether.pixelOffsetToDate(0)
};
Timeline._Band.prototype.getMaxVisibleDate=function(){return this._ether.pixelOffsetToDate(this._viewLength)
};
Timeline._Band.prototype.getCenterVisibleDate=function(){return this._ether.pixelOffsetToDate(this._viewLength/2)
};
Timeline._Band.prototype.setMinVisibleDate=function(a){if(!this._changing){this._moveEther(Math.round(-this._ether.dateToPixelOffset(a)))
}};
Timeline._Band.prototype.setMaxVisibleDate=function(a){if(!this._changing){this._moveEther(Math.round(this._viewLength-this._ether.dateToPixelOffset(a)))
}};
Timeline._Band.prototype.setCenterVisibleDate=function(a){if(!this._changing){this._moveEther(Math.round(this._viewLength/2-this._ether.dateToPixelOffset(a)))
}};
Timeline._Band.prototype.dateToPixelOffset=function(a){return this._ether.dateToPixelOffset(a)-this._viewOffset
};
Timeline._Band.prototype.pixelOffsetToDate=function(a){return this._ether.pixelOffsetToDate(a+this._viewOffset)
};
Timeline._Band.prototype.createLayerDiv=function(c,a){var b=this._timeline.getDocument().createElement("div");
b.className="timeline-band-layer"+(typeof a=="string"?(" "+a):"");
b.style.zIndex=c;
this._innerDiv.appendChild(b);
var d=this._timeline.getDocument().createElement("div");
d.className="timeline-band-layer-inner";
if(SimileAjax.Platform.browser.isIE){d.style.cursor="move"
}else{d.style.cursor="-moz-grab"
}b.appendChild(d);
return d
};
Timeline._Band.prototype.removeLayerDiv=function(a){this._innerDiv.removeChild(a.parentNode)
};
Timeline._Band.prototype.scrollToCenter=function(a,b){var c=this._ether.dateToPixelOffset(a);
if(c<-this._viewLength/2){this.setCenterVisibleDate(this.pixelOffsetToDate(c+this._viewLength))
}else{if(c>3*this._viewLength/2){this.setCenterVisibleDate(this.pixelOffsetToDate(c-this._viewLength))
}}this._autoScroll(Math.round(this._viewLength/2-this._ether.dateToPixelOffset(a)),b)
};
Timeline._Band.prototype.showBubbleForEvent=function(b){var a=this.getEventSource().getEvent(b);
if(a){var c=this;
this.scrollToCenter(a.getStart(),function(){c._eventPainter.showBubble(a)
})
}};
Timeline._Band.prototype.zoom=function(e,a,b,c){if(!this._zoomSteps){return
}a+=this._viewOffset;
var d=this._ether.pixelOffsetToDate(a);
var f=this._ether.zoom(e);
this._etherPainter.zoom(f);
this._moveEther(Math.round(-this._ether.dateToPixelOffset(d)));
this._moveEther(a)
};
Timeline._Band.prototype._onMouseDown=function(c,a,b){this.closeBubble();
this._dragging=true;
this._dragX=a.clientX;
this._dragY=a.clientY
};
Timeline._Band.prototype._onMouseMove=function(c,a,b){if(this._dragging){var d=a.clientX-this._dragX;
var e=a.clientY-this._dragY;
this._dragX=a.clientX;
this._dragY=a.clientY;
this._moveEther(this._timeline.isHorizontal()?d:e);
this._positionHighlight()
}};
Timeline._Band.prototype._onMouseUp=function(c,a,b){this._dragging=false;
this._keyboardInput.focus()
};
Timeline._Band.prototype._onMouseOut=function(c,d,b){var a=SimileAjax.DOM.getEventRelativeCoordinates(d,c);
a.x+=this._viewOffset;
if(a.x<0||a.x>c.offsetWidth||a.y<0||a.y>c.offsetHeight){this._dragging=false
}};
Timeline._Band.prototype._onMouseScroll=function(g,f,c){var d=new Date();
d=d.getTime();
if(!this._lastScrollTime||((d-this._lastScrollTime)>50)){this._lastScrollTime=d;
var e=0;
if(f.wheelDelta){e=f.wheelDelta/120
}else{if(f.detail){e=-f.detail/3
}}var h=this._theme.mouseWheel;
if(this._zoomSteps||h==="zoom"){var i=SimileAjax.DOM.getEventRelativeCoordinates(f,g);
if(e!=0){var a;
if(e>0){a=true
}if(e<0){a=false
}this._timeline.zoom(a,i.x,i.y,g)
}}else{if(h==="scroll"){var b=50*(e<0?-1:1);
this._moveEther(b)
}}}if(f.stopPropagation){f.stopPropagation()
}f.cancelBubble=true;
if(f.preventDefault){f.preventDefault()
}f.returnValue=false
};
Timeline._Band.prototype._onDblClick=function(d,e,b){var a=SimileAjax.DOM.getEventRelativeCoordinates(e,d);
var c=a.x-(this._viewLength/2-this._viewOffset);
this._autoScroll(-c)
};
Timeline._Band.prototype._onKeyDown=function(c,a,b){if(!this._dragging){switch(a.keyCode){case 27:break;
case 37:case 38:this._scrollSpeed=Math.min(50,Math.abs(this._scrollSpeed*1.05));
this._moveEther(this._scrollSpeed);
break;
case 39:case 40:this._scrollSpeed=-Math.min(50,Math.abs(this._scrollSpeed*1.05));
this._moveEther(this._scrollSpeed);
break;
default:return true
}this.closeBubble();
SimileAjax.DOM.cancelEvent(a);
return false
}return true
};
Timeline._Band.prototype._onKeyUp=function(c,a,b){if(!this._dragging){this._scrollSpeed=this._originalScrollSpeed;
switch(a.keyCode){case 35:this.setCenterVisibleDate(this._eventSource.getLatestDate());
break;
case 36:this.setCenterVisibleDate(this._eventSource.getEarliestDate());
break;
case 33:this._autoScroll(this._timeline.getPixelLength());
break;
case 34:this._autoScroll(-this._timeline.getPixelLength());
break;
default:return true
}this.closeBubble();
SimileAjax.DOM.cancelEvent(a);
return false
}return true
};
Timeline._Band.prototype._autoScroll=function(b,c){var a=this;
var d=SimileAjax.Graphics.createAnimation(function(f,e){a._moveEther(e)
},0,b,1000,c);
d.run()
};
Timeline._Band.prototype._moveEther=function(a){this.closeBubble();
this._viewOffset+=a;
this._ether.shiftPixels(-a);
if(this._timeline.isHorizontal()){this._div.style.left=this._viewOffset+"px"
}else{this._div.style.top=this._viewOffset+"px"
}if(this._viewOffset>-this._viewLength*0.5||this._viewOffset<-this._viewLength*(Timeline._Band.SCROLL_MULTIPLES-1.5)){this._recenterDiv()
}else{this.softLayout()
}this._onChanging()
};
Timeline._Band.prototype._onChanging=function(){this._changing=true;
this._fireOnScroll();
this._setSyncWithBandDate();
this._changing=false
};
Timeline._Band.prototype._fireOnScroll=function(){for(var a=0;
a<this._onScrollListeners.length;
a++){this._onScrollListeners[a](this)
}};
Timeline._Band.prototype._setSyncWithBandDate=function(){if(this._syncWithBand){var a=this._ether.pixelOffsetToDate(this.getViewLength()/2);
this._syncWithBand.setCenterVisibleDate(a)
}};
Timeline._Band.prototype._onHighlightBandScroll=function(){if(this._syncWithBand){var a=this._syncWithBand.getCenterVisibleDate();
var b=this._ether.dateToPixelOffset(a);
this._moveEther(Math.round(this._viewLength/2-b));
if(this._highlight){this._etherPainter.setHighlight(this._syncWithBand.getMinVisibleDate(),this._syncWithBand.getMaxVisibleDate())
}}};
Timeline._Band.prototype._onAddMany=function(){this._paintEvents()
};
Timeline._Band.prototype._onClear=function(){this._paintEvents()
};
Timeline._Band.prototype._positionHighlight=function(){if(this._syncWithBand){var a=this._syncWithBand.getMinVisibleDate();
var b=this._syncWithBand.getMaxVisibleDate();
if(this._highlight){this._etherPainter.setHighlight(a,b)
}}};
Timeline._Band.prototype._recenterDiv=function(){this._viewOffset=-this._viewLength*(Timeline._Band.SCROLL_MULTIPLES-1)/2;
if(this._timeline.isHorizontal()){this._div.style.left=this._viewOffset+"px";
this._div.style.width=(Timeline._Band.SCROLL_MULTIPLES*this._viewLength)+"px"
}else{this._div.style.top=this._viewOffset+"px";
this._div.style.height=(Timeline._Band.SCROLL_MULTIPLES*this._viewLength)+"px"
}this.layout()
};
Timeline._Band.prototype._paintEvents=function(){this._eventPainter.paint()
};
Timeline._Band.prototype._softPaintEvents=function(){this._eventPainter.softPaint()
};
Timeline._Band.prototype._paintDecorators=function(){for(var a=0;
a<this._decorators.length;
a++){this._decorators[a].paint()
}};
Timeline._Band.prototype._softPaintDecorators=function(){for(var a=0;
a<this._decorators.length;
a++){this._decorators[a].softPaint()
}};
Timeline._Band.prototype.closeBubble=function(){SimileAjax.WindowManager.cancelPopups()
};
Timeline.NativeDateUnit=new Object();
Timeline.NativeDateUnit.createLabeller=function(b,a){return new Timeline.GregorianDateLabeller(b,a)
};
Timeline.NativeDateUnit.makeDefaultValue=function(){return new Date()
};
Timeline.NativeDateUnit.cloneValue=function(a){return new Date(a.getTime())
};
Timeline.NativeDateUnit.getParser=function(a){if(typeof a=="string"){a=a.toLowerCase()
}return(a=="iso8601"||a=="iso 8601")?Timeline.DateTime.parseIso8601DateTime:Timeline.DateTime.parseGregorianDateTime
};
Timeline.NativeDateUnit.parseFromObject=function(a){return Timeline.DateTime.parseGregorianDateTime(a)
};
Timeline.NativeDateUnit.toNumber=function(a){return a.getTime()
};
Timeline.NativeDateUnit.fromNumber=function(a){return new Date(a)
};
Timeline.NativeDateUnit.compare=function(b,c){var d,a;
if(typeof b=="object"){d=b.getTime()
}else{d=Number(b)
}if(typeof c=="object"){a=c.getTime()
}else{a=Number(c)
}return d-a
};
Timeline.NativeDateUnit.earlier=function(b,a){return Timeline.NativeDateUnit.compare(b,a)<0?b:a
};
Timeline.NativeDateUnit.later=function(b,a){return Timeline.NativeDateUnit.compare(b,a)>0?b:a
};
Timeline.NativeDateUnit.change=function(a,b){return new Date(a.getTime()+b)
};