/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.simile.timeline;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.wicketstuff.simile.timeline.ITimelineEvent;
import org.wicketstuff.simile.timeline.TimelineModel;
import org.wicketstuff.simile.timeline.json.JsonUtils;
import org.wicketstuff.simile.timeline.model.BandInfoParameters;

public class Timeline
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final String TIMELINE_PARAMS_JAVASCRIPT = Timeline.class.getName() + "PARAMS_JS";
    private transient JsonUtils jsonUtils = new JsonUtils();
    private String timelineMarkupId;
    private String timelineDataId;

    public Timeline(String id, IModel<TimelineModel> model) {
        super(id, (IModel)new CompoundPropertyModel(model));
        ArrayList<BandInfoParameters> bandInfo = new ArrayList<BandInfoParameters>();
        BandInfoParameters upperBand = new BandInfoParameters();
        upperBand.setIntervalPixels(70);
        upperBand.setHighlight(true);
        bandInfo.add(upperBand);
        BandInfoParameters lowerBand = new BandInfoParameters();
        lowerBand.setIntervalUnit(BandInfoParameters.DateTime.YEAR);
        lowerBand.setIntervalPixels(200);
        lowerBand.setWidth("200px");
        bandInfo.add(lowerBand);
        this.init(id, model, bandInfo);
    }

    public Timeline(String id, IModel<TimelineModel> model, List<BandInfoParameters> bandInfo) {
        super(id, (IModel)new CompoundPropertyModel(model));
        this.init(id, model, bandInfo);
    }

    private void init(String id, IModel<?> model, List<BandInfoParameters> bandInfo) {
        WebMarkupContainer tl = new WebMarkupContainer("tl");
        tl.setOutputMarkupId(true);
        this.add(new Component[]{tl});
        this.timelineMarkupId = tl.getMarkupId();
        WebMarkupContainer timelineData = new WebMarkupContainer("timelineData");
        timelineData.setOutputMarkupId(true);
        timelineData.add(new Component[]{new ListView<ITimelineEvent>("events"){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<ITimelineEvent> item) {
                item.add(new Behavior[]{new AttributeModifier("title", (IModel)new PropertyModel((Object)item.getModel(), "title"))});
                item.add(new Behavior[]{new AttributeModifier("start", (IModel)new PropertyModel((Object)item.getModel(), "startFormatted"))});
                item.add(new Behavior[]{new AttributeModifier("end", (IModel)new PropertyModel((Object)item.getModel(), "endFormatted"))});
                item.add(new Behavior[]{new AttributeModifier("link", (IModel)new PropertyModel((Object)item.getModel(), "link"))});
                item.add(new Behavior[]{new AttributeModifier("isDuration", (IModel)new PropertyModel((Object)item.getModel(), "isDuration"))});
                item.add(new Behavior[]{new AttributeModifier("color", (IModel)new PropertyModel((Object)item.getModel(), "color"))});
                Label child = new Label("text", (IModel)new PropertyModel((Object)item.getModel(), "text"));
                child.setRenderBodyOnly(true);
                child.setEscapeModelStrings(false);
                item.add(new Component[]{child});
            }
        }});
        this.add(new Component[]{timelineData});
        this.timelineDataId = timelineData.getMarkupId();
        StringBuffer loadScript = new StringBuffer();
        loadScript.append("function " + this.getLoadScriptName() + "() {\n");
        loadScript.append("var theme = Timeline.ClassicTheme.create();\n");
        loadScript.append("theme.event.bubble.width = 320;\n");
        loadScript.append("theme.event.bubble.height = 220;\n");
        loadScript.append("theme.ether.backgroundColors[1] = theme.ether.backgroundColors[0];\n");
        loadScript.append("var eventSource = new Timeline.DefaultEventSource(0);");
        loadScript.append("timeLineOnLoad('" + this.timelineMarkupId + "', '" + this.timelineDataId + "', theme, eventSource, " + this.jsonUtils.convertBandInfos(bandInfo) + ");\n");
        loadScript.append("}");
        this.add(new Component[]{new Label("loadScript", (Serializable)((Object)loadScript.toString())).setEscapeModelStrings(false)});
    }

    private String getLoadScriptName() {
        return "timeLineLoad" + this.timelineMarkupId;
    }

    public void renderHead(IHeaderResponse response) {
        PageParameters pp = new PageParameters();
        pp.add("timeline-use-local-resources", (Object)"true");
        pp.add("bundle", (Object)"true");
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new PackageResourceReference(((Object)((Object)this)).getClass(), "./timeline_js/timeline-api.js"), (PageParameters)pp, (String)"timeline-api"));
        StringBuffer parameters = new StringBuffer("");
        parameters.append("Timeline_ajax_url='").append(this.timelineUrl()).append("';\n");
        response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)parameters.toString(), (String)TIMELINE_PARAMS_JAVASCRIPT));
        response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)(this.getLoadScriptName() + "()")));
    }

    private CharSequence timelineUrl() {
        return this.urlFor((ResourceReference)new PackageResourceReference(((Object)((Object)this)).getClass(), "timeline_ajax/simile-ajax-api.js"), new PageParameters());
    }
}

