/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.sitemap;

import java.util.Date;
import org.apache.wicket.extensions.sitemap.ISiteMapEntry;

public class BasicSiteMapEntry
implements ISiteMapEntry {
    private final String url;
    private final Date modified;
    private final double priority;
    private final ISiteMapEntry.CHANGEFREQ frequency;
    private static final double DEFAULT_PRIORITY = 0.5;

    public BasicSiteMapEntry(String url) {
        this.url = url;
        this.modified = new Date();
        this.priority = 0.5;
        this.frequency = ISiteMapEntry.CHANGEFREQ.WEEKLY;
    }

    public BasicSiteMapEntry(String url, Date modified, double priority, ISiteMapEntry.CHANGEFREQ frequency) {
        this.url = url;
        this.modified = modified;
        this.frequency = frequency;
        if (priority > 1.0) {
            priority = 1.0;
        }
        if (priority < 0.0) {
            priority = 0.0;
        }
        this.priority = priority;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public Date getModified() {
        return this.modified;
    }

    @Override
    public Double getPriority() {
        return this.priority;
    }

    @Override
    public ISiteMapEntry.CHANGEFREQ getFrequency() {
        return this.frequency;
    }
}

