/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.sitemap;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Observable;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.wicket.extensions.sitemap.IOffsetSiteMapEntryIterable;
import org.apache.wicket.extensions.sitemap.ISiteMapEntry;
import org.apache.wicket.request.cycle.RequestCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SiteMapFeed
extends Observable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SiteMapFeed.class);
    private final IOffsetSiteMapEntryIterable.SiteMapIterable entries;
    private int entriesWritten;
    private static final String HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n";
    private static final SimpleDateFormat SITEMAP_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private int bytesWritten;
    private static final String FOOTER = "</urlset>";
    private static final int URL_MAX_LENGTH = 2048;

    public SiteMapFeed(IOffsetSiteMapEntryIterable.SiteMapIterable entries) {
        this.entries = entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFeed(PrintWriter writer) throws IOException {
        IOffsetSiteMapEntryIterable.SiteMapIterator it = this.entries.iterator();
        try {
            this.entriesWritten = 0;
            this.bytesWritten = 0;
            writer.append(HEADER);
            this.bytesWritten += HEADER.length();
            while (it.hasNext()) {
                ISiteMapEntry entry = (ISiteMapEntry)it.next();
                String urlStr = entry.getUrl();
                if (urlStr != null) {
                    this.writeSingleEntry(writer, entry, urlStr);
                    continue;
                }
                LOGGER.warn("url entry {} for sitemap {} was null, but this is a required attribute..", (Object)entry, (Object)RequestCycle.get().getRequest());
            }
            writer.append(FOOTER);
            this.bytesWritten += FOOTER.length();
            this.setChanged();
            this.notifyObservers();
        }
        finally {
            it.close();
        }
    }

    private void writeSingleEntry(PrintWriter writer, ISiteMapEntry entry, String urlStr) throws IOException {
        Double prio;
        ISiteMapEntry.CHANGEFREQ frequency;
        StringBuilder sb = new StringBuilder();
        ++this.entriesWritten;
        sb.append("<url>\n");
        sb.append("<loc>");
        sb.append(StringEscapeUtils.escapeXml((String)urlStr));
        if (urlStr.length() > 2048) {
            LOGGER.warn("url {} was too long (>2048 bytes) in sitemap {}", (Object)urlStr, (Object)RequestCycle.get().getRequest());
        }
        sb.append("</loc>\n");
        Date modified = entry.getModified();
        if (modified != null) {
            sb.append("<lastmod>");
            sb.append(SITEMAP_DATE_FORMAT.format(modified));
            sb.append("</lastmod>\n");
        }
        if ((frequency = entry.getFrequency()) != null) {
            sb.append("<changefreq>");
            sb.append(frequency.toString().toLowerCase());
            sb.append("</changefreq>\n");
        }
        if ((prio = entry.getPriority()) != null) {
            prio = SiteMapFeed.normalizePriority(entry, prio);
            sb.append("<priority>");
            sb.append(prio);
            sb.append("</priority>\n");
        }
        sb.append("</url>\n");
        this.bytesWritten += sb.length();
        writer.append(sb);
        if (writer.checkError()) {
            throw new IOException("remote side closed connection? stopping to generate sitemap.");
        }
        this.setChanged();
        this.notifyObservers();
    }

    private static Double normalizePriority(ISiteMapEntry entry, Double prio) {
        if (prio > 1.0) {
            LOGGER.warn("priority {} was out of bounds for entry {}, setting to 1.0", (Object)prio, (Object)entry);
            prio = 1.0;
        }
        if (prio < 0.0) {
            LOGGER.warn("priority {} was out of bounds for entry {}, setting to 0.0", (Object)prio, (Object)entry);
            prio = 0.0;
        }
        return prio;
    }

    public int getBytesWritten() {
        return this.bytesWritten;
    }

    public int getEntriesWritten() {
        return this.entriesWritten;
    }
}

