/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.sitemap;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.extensions.sitemap.IOffsetSiteMapEntryIterable;
import org.apache.wicket.extensions.sitemap.SiteMapFeed;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;

public abstract class SiteMapIndex
extends ResourceReference
implements Observer {
    private static final long serialVersionUID = 1L;
    private static final String PARAM_SITEMAP_OFFSET = "offset";
    private static final String PARAM_SITEMAP_SOURCEINDEX = "sourceindex";
    private static final String HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<sitemapindex xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n";
    private static final String FOOTER = "</sitemapindex>";
    private static final int MAX_BYTES_SITEMAP = 0xA00000;
    private static final int MAX_ENTRIES_PER_SITEMAP = 50000;
    private static final SimpleDateFormat STRIPPED_DAY_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private String domain;

    public SiteMapIndex() {
        super("sitemap.xml");
    }

    public IResource getResource() {
        return new SiteMapResourceResponse();
    }

    public String getDomain() {
        if (this.domain == null) {
            Request rawRequest = RequestCycle.get().getRequest();
            if (!(rawRequest instanceof WebRequest)) {
                throw new WicketRuntimeException("sitemap.xml generation is only possible for http requests");
            }
            WebRequest wr = (WebRequest)rawRequest;
            this.domain = "http://" + ((HttpServletRequest)wr.getContainerRequest()).getHeader("host");
        }
        return this.domain;
    }

    @Override
    public void update(Observable o, Object arg) {
        SiteMapFeed siteMapFeed;
        if (o instanceof SiteMapFeed && ((siteMapFeed = (SiteMapFeed)o).getEntriesWritten() > 50000 || siteMapFeed.getBytesWritten() > 0xA00000)) {
            throw new IllegalStateException("please adjust block sizes for this sitemap.");
        }
    }

    public abstract IOffsetSiteMapEntryIterable[] getDataSources();

    private class SiteMapResourceResponse
    extends AbstractResource {
        private static final long serialVersionUID = 1L;

        private SiteMapResourceResponse() {
        }

        protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
            AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) {
                    PrintWriter w = new PrintWriter(attributes.getResponse().getOutputStream());
                    final Integer index = attributes.getParameters().get(SiteMapIndex.PARAM_SITEMAP_OFFSET).toOptionalInteger();
                    final Integer sourceIndex = attributes.getParameters().get(SiteMapIndex.PARAM_SITEMAP_SOURCEINDEX).toOptionalInteger();
                    try {
                        if (index != null && sourceIndex != null) {
                            SiteMapFeed feed = new SiteMapFeed(new IOffsetSiteMapEntryIterable.SiteMapIterable(){

                                @Override
                                public IOffsetSiteMapEntryIterable.SiteMapIterator iterator() {
                                    return SiteMapIndex.this.getDataSources()[sourceIndex].getIterator(index);
                                }
                            });
                            feed.addObserver(SiteMapIndex.this);
                            feed.writeFeed(w);
                        } else {
                            w.write(SiteMapIndex.HEADER);
                            int sourceNumber = 0;
                            for (IOffsetSiteMapEntryIterable dataBlock : SiteMapIndex.this.getDataSources()) {
                                int upperLimitNumblocks = dataBlock.getUpperLimitNumblocks();
                                for (int i = 0; i < upperLimitNumblocks; ++i) {
                                    w.append("<sitemap>\n<loc>");
                                    PageParameters params = new PageParameters();
                                    params.add(SiteMapIndex.PARAM_SITEMAP_SOURCEINDEX, (Object)String.valueOf(sourceNumber));
                                    params.add(SiteMapIndex.PARAM_SITEMAP_OFFSET, (Object)String.valueOf(i * dataBlock.getElementsPerSiteMap()));
                                    String url = SiteMapIndex.this.getDomain() + "/" + RequestCycle.get().mapUrlFor((ResourceReference)SiteMapIndex.this, params);
                                    w.append(StringEscapeUtils.escapeXml((String)url));
                                    Date changed = dataBlock.changedDate();
                                    w.append("</loc>\n");
                                    if (changed != null) {
                                        w.append("<lastmod>");
                                        w.append(STRIPPED_DAY_FORMAT.format(dataBlock.changedDate()));
                                        w.append("</lastmod>\n");
                                    }
                                    w.append("</sitemap>\n");
                                }
                                ++sourceNumber;
                            }
                            w.write(SiteMapIndex.FOOTER);
                        }
                        w.flush();
                    }
                    catch (IOException e) {
                        throw new WicketRuntimeException("unable to construct sitemap.xml for request: " + ((HttpServletRequest)((WebRequest)attributes.getRequest()).getContainerRequest()).getRemoteAddr(), (Throwable)e);
                    }
                    finally {
                        w.close();
                    }
                }
            });
            response.setFileName("sitemap.xml");
            return response;
        }
    }
}

