/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.springreference;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import org.wicketstuff.springreference.AbstractSpringReferenceSupporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSpringReference<T>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4097373492449915070L;
    private final Class<T> clazz;
    private String name;
    private final boolean clazzBasedOnlyLookup;
    private transient WeakReference<T> instanceRef;

    protected AbstractSpringReference(Class<T> clazz, String name) {
        this.clazz = clazz;
        this.name = name;
        this.clazzBasedOnlyLookup = name == null;
    }

    public T get() {
        Object instance;
        WeakReference<T> ref = this.instanceRef;
        if (ref == null || (instance = ref.get()) == null) {
            instance = this.getSupporter().findAndSetInstance(this);
        }
        return instance;
    }

    public AbstractSpringReference<T> clone() {
        try {
            return (AbstractSpringReference)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
        result = 31 * result + (this.clazzBasedOnlyLookup ? 1231 : 1237);
        AbstractSpringReferenceSupporter supporter = this.getSupporter();
        result = 31 * result + (supporter == null ? 0 : supporter.hashCode());
        if (!this.clazzBasedOnlyLookup) {
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSpringReference other = (AbstractSpringReference)obj;
        if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
            return false;
        }
        if (this.clazzBasedOnlyLookup != other.clazzBasedOnlyLookup) {
            return false;
        }
        if (!this.clazzBasedOnlyLookup && (this.name == null ? other.name != null : !this.name.equals(other.name))) {
            return false;
        }
        return this.getSupporter() == other.getSupporter();
    }

    protected abstract AbstractSpringReferenceSupporter getSupporter();

    protected void setInstanceRef(WeakReference<T> instanceRef) {
        this.instanceRef = instanceRef;
    }

    protected String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected Class<T> getClazz() {
        return this.clazz;
    }

    protected boolean isClazzBasedOnlyLookup() {
        return this.clazzBasedOnlyLookup;
    }
}

