/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.springreference;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.wicketstuff.springreference.AbstractSpringReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSpringReferenceSupporter {
    private final Map<String, WeakReference<?>> singletonCache = new ConcurrentHashMap();
    private final Map<String, String> beanNameCache = new ConcurrentHashMap<String, String>();

    public <T> T findAndSetInstance(AbstractSpringReference<T> ref) {
        Object instance;
        WeakReference<Object> instanceRef;
        String clazzName = ref.getClazz().getName();
        if (ref.isClazzBasedOnlyLookup() && (instanceRef = this.singletonCache.get(clazzName)) != null && (instance = instanceRef.get()) != null) {
            ref.setInstanceRef(instanceRef);
            return instance;
        }
        String name = ref.getName();
        if (name == null) {
            name = this.findBeanName(ref);
            ref.setName(name);
        }
        String singletonCacheKey = clazzName + " " + name;
        instanceRef = this.singletonCache.get(singletonCacheKey);
        boolean singleton = true;
        if (instanceRef == null || (instance = instanceRef.get()) == null) {
            ApplicationContext applicationContext = this.getApplicationContext();
            instance = applicationContext.getBean(name, ref.getClazz());
            singleton = applicationContext.isSingleton(name);
            if (singleton) {
                instanceRef = new WeakReference(instance);
                this.singletonCache.put(singletonCacheKey, instanceRef);
            }
        }
        if (ref.isClazzBasedOnlyLookup() && singleton) {
            this.singletonCache.put(clazzName, instanceRef);
        }
        ref.setInstanceRef(instanceRef);
        return instance;
    }

    protected <T> String findBeanName(AbstractSpringReference<T> ref) {
        Class<T> clazz = ref.getClazz();
        String clazzName = clazz.getName();
        String name = this.beanNameCache.get(clazzName);
        if (name != null) {
            return name;
        }
        ApplicationContext applicationContext = this.getApplicationContext();
        Object[] names = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)applicationContext, clazz);
        if (names.length != 1) {
            if (applicationContext instanceof ConfigurableApplicationContext) {
                ConfigurableListableBeanFactory fact = ((ConfigurableApplicationContext)applicationContext).getBeanFactory();
                LinkedList<Object> autowireCandidates = new LinkedList<Object>();
                LinkedList<Object> primaries = new LinkedList<Object>();
                for (Object n : names) {
                    BeanDefinition beanDefinition = this.getBeanDefinition(fact, (String)n);
                    if (beanDefinition == null || !beanDefinition.isAutowireCandidate()) continue;
                    autowireCandidates.add(n);
                    if (!beanDefinition.isPrimary()) continue;
                    primaries.add(n);
                }
                if (!primaries.isEmpty()) {
                    names = primaries.toArray(new String[primaries.size()]);
                } else if (!autowireCandidates.isEmpty()) {
                    names = autowireCandidates.toArray(new String[autowireCandidates.size()]);
                }
            }
            if (names.length != 1) {
                throw new IllegalStateException("Zero or more than one spring bean candidates. Type: " + clazz + ", candidates: " + Arrays.toString(names));
            }
        }
        name = names[0];
        this.beanNameCache.put(clazzName, name);
        return name;
    }

    protected BeanDefinition getBeanDefinition(ConfigurableListableBeanFactory fact, String name) {
        if (fact.containsBeanDefinition(name)) {
            return fact.getBeanDefinition(name);
        }
        BeanFactory parent = fact.getParentBeanFactory();
        if (parent instanceof ConfigurableListableBeanFactory) {
            return this.getBeanDefinition((ConfigurableListableBeanFactory)parent, name);
        }
        return null;
    }

    protected abstract ApplicationContext getApplicationContext();

    public void clearCache() {
        this.beanNameCache.clear();
        this.singletonCache.clear();
    }
}

