/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.springreference;

import javax.servlet.ServletContext;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.lang.Args;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.wicketstuff.springreference.AbstractSpringReferenceSupporter;

public class SpringReferenceSupporter
extends AbstractSpringReferenceSupporter {
    private static MetaDataKey<SpringReferenceSupporter> LOCATOR_KEY = new MetaDataKey<SpringReferenceSupporter>(){
        private static final long serialVersionUID = 5075847072788088007L;
    };
    private final ApplicationContext applicationContext;

    public SpringReferenceSupporter(ApplicationContext applicationContext) {
        Args.notNull((Object)applicationContext, (String)"applicationContext");
        this.applicationContext = applicationContext;
    }

    public static void register(WebApplication application) {
        Args.notNull((Object)application, (String)"application");
        ServletContext servletContext = application.getServletContext();
        WebApplicationContext applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        SpringReferenceSupporter.register((Application)application, new SpringReferenceSupporter((ApplicationContext)applicationContext));
    }

    public static void register(Application application, SpringReferenceSupporter supporter) {
        Args.notNull((Object)application, (String)"application");
        application.setMetaData(LOCATOR_KEY, (Object)supporter);
    }

    protected static SpringReferenceSupporter get() {
        return (SpringReferenceSupporter)Application.get().getMetaData(LOCATOR_KEY);
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

