/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.stateless;

import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.parameter.INamedParameters;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.encoding.UrlEncoder;

final class StatelessEncoder {
    static Url mergeParameters(Url url, PageParameters params) {
        if (params == null) {
            return url;
        }
        Charset charset = url.getCharset();
        Url mergedUrl = Url.parse((CharSequence)url.toString(), (Charset)charset);
        UrlEncoder urlEncoder = UrlEncoder.QUERY_INSTANCE;
        HashSet<String> setParameters = new HashSet<String>();
        int indexedCount = params.getIndexedCount();
        if (indexedCount > 0) {
            String lastSegment;
            int jsessionidIndex;
            String jsessionidString = null;
            List segments = mergedUrl.getSegments();
            if (segments.size() > 0 && (jsessionidIndex = (lastSegment = (String)segments.get(segments.size() - 1)).indexOf(";jsessionid=")) != -1) {
                segments.set(segments.size() - 1, lastSegment.substring(0, jsessionidIndex));
                jsessionidString = lastSegment.substring(jsessionidIndex);
            }
            for (int i = 0; i < indexedCount; ++i) {
                segments.add(params.get(i).toString());
            }
            if (jsessionidString != null) {
                segments.set(segments.size() - 1, ((String)segments.get(segments.size() - 1)).concat(jsessionidString));
            }
        }
        for (INamedParameters.NamedPair pair : params.getAllNamed()) {
            String key = urlEncoder.encode(pair.getKey(), charset);
            String value = urlEncoder.encode(pair.getValue(), charset);
            if (setParameters.contains(key)) {
                mergedUrl.addQueryParameter(key, (Object)value);
                continue;
            }
            mergedUrl.setQueryParameter(key, (Object)value);
            setParameters.add(key);
        }
        return mergedUrl;
    }

    private StatelessEncoder() {
    }
}

