/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.stateless;

import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.wicketstuff.stateless.StatelessEncoder;

public abstract class StatelessLink<T>
extends Link<T> {
    private static final long serialVersionUID = 397549666360107292L;
    private final PageParameters parameters;

    public StatelessLink(String id) {
        this(id, null, null);
    }

    public StatelessLink(String id, IModel<T> model) {
        this(id, model, null);
    }

    public StatelessLink(String id, IModel<T> model, PageParameters params) {
        super(id, model);
        this.setMarkupId(id);
        this.parameters = params;
    }

    protected final PageParameters getPageParameters() {
        return this.parameters;
    }

    protected boolean getStatelessHint() {
        return true;
    }

    protected CharSequence getURL() {
        Url url = Url.parse((CharSequence)((Object)super.getURL()).toString());
        Url mergedUrl = StatelessEncoder.mergeParameters(url, this.parameters);
        return mergedUrl.toString();
    }
}

