/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.tinymce;

import java.util.Collections;
import java.util.UUID;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.IHeaderResponse;
import wicket.contrib.tinymce.TinyMceBehavior;
import wicket.contrib.tinymce.settings.TinyMCESettings;

public class InPlaceEditBehavior
extends TinyMceBehavior {
    private static final long serialVersionUID = 1L;
    private String startEditorScriptName;

    public InPlaceEditBehavior(TinyMCESettings settings, Component triggerComponent) {
        super(settings);
        if (triggerComponent != null) {
            triggerComponent.add(new Behavior[]{this.createTriggerBehavior()});
        }
    }

    private Behavior createTriggerBehavior() {
        return new Behavior(){
            private static final long serialVersionUID = 1L;

            public void onComponentTag(Component component, ComponentTag tag) {
                super.onComponentTag(component, tag);
                tag.put("onclick", (CharSequence)(InPlaceEditBehavior.this.getStartEditorScriptName() + "();"));
            }
        };
    }

    protected String getRenderOnDomReadyJavascript(IHeaderResponse response) {
        return null;
    }

    protected String getRenderJavascript(IHeaderResponse response) {
        return "function " + this.getStartEditorScriptName() + "() {" + this.getAddTinyMceSettingsScript(TinyMCESettings.Mode.none, Collections.EMPTY_LIST) + " tinyMCE.execCommand('mceAddControl',true,'" + this.getComponent().getMarkupId(true) + "');" + "}";
    }

    public final String getStartEditorScriptName() {
        if (this.startEditorScriptName == null) {
            String uuid = UUID.randomUUID().toString().replace('-', '_');
            this.startEditorScriptName = "startmce_" + uuid;
        }
        return this.startEditorScriptName;
    }
}

