/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.tinymce;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import wicket.contrib.tinymce.InPlaceEditBehavior;
import wicket.contrib.tinymce.InPlaceSaveBehavior;
import wicket.contrib.tinymce.settings.Button;
import wicket.contrib.tinymce.settings.TinyMCESettings;
import wicket.contrib.tinymce.settings.WicketSavePlugin;

public class InPlaceEditComponent
extends AbstractTextComponent {
    private static final long serialVersionUID = 1L;
    private InPlaceSaveBehavior inPlaceSaveBehavior;
    private InPlaceEditBehavior inPlaceEditBehavior;
    private TinyMCESettings settings;

    public InPlaceEditComponent(String id, IModel model) {
        super(id, model);
        this.init((Component)this);
    }

    public InPlaceEditComponent(String id, IModel model, Component triggerComponent) {
        super(id, model);
        this.init(triggerComponent);
    }

    public InPlaceEditComponent(String id, String text) {
        super(id, (IModel)new Model((Serializable)((Object)text)));
        this.init((Component)this);
    }

    public InPlaceEditComponent(String id, String text, Component triggerComponent) {
        super(id, (IModel)new Model((Serializable)((Object)text)));
        this.init(triggerComponent);
    }

    private void init(Component triggerComponent) {
        this.setEscapeModelStrings(false);
        this.setOutputMarkupId(true);
        this.settings = new TinyMCESettings(TinyMCESettings.Theme.advanced);
        this.inPlaceSaveBehavior = this.createSaveBehavior();
        if (this.inPlaceSaveBehavior != null) {
            this.add(new Behavior[]{this.inPlaceSaveBehavior});
            WicketSavePlugin savePlugin = new WicketSavePlugin(this.inPlaceSaveBehavior);
            this.settings.add(savePlugin.getSaveButton(), TinyMCESettings.Toolbar.first, TinyMCESettings.Position.before);
            this.settings.add(savePlugin.getCancelButton(), TinyMCESettings.Toolbar.first, TinyMCESettings.Position.before);
            this.settings.add(Button.separator, TinyMCESettings.Toolbar.first, TinyMCESettings.Position.before);
        }
        this.inPlaceEditBehavior = this.createEditBehavior(triggerComponent);
        if (this.inPlaceEditBehavior != null) {
            this.add(new Behavior[]{this.inPlaceEditBehavior});
        }
    }

    protected InPlaceEditBehavior createEditBehavior(Component triggerComponent) {
        return new InPlaceEditBehavior(this.getSettings(), triggerComponent);
    }

    protected InPlaceSaveBehavior createSaveBehavior() {
        return new InPlaceSaveBehavior();
    }

    public TinyMCESettings getSettings() {
        return this.settings;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.remove("name");
    }

    public String getInputName() {
        return this.getMarkupId();
    }

    public final void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        this.replaceComponentTagBody(markupStream, openTag, this.getValue());
    }

    public final String getStartEditorScriptName() {
        return this.inPlaceEditBehavior.getStartEditorScriptName();
    }

    public InPlaceSaveBehavior getInPlaceSaveBehavior() {
        return this.inPlaceSaveBehavior;
    }

    public InPlaceEditBehavior getInPlaceEditBehavior() {
        return this.inPlaceEditBehavior;
    }
}

