/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.tinymce;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.IAjaxRegionMarkupIdProvider;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.http.WebRequest;
import wicket.contrib.tinymce.settings.TinyMCESettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinyMceBehavior
extends Behavior
implements IAjaxRegionMarkupIdProvider {
    private static final long serialVersionUID = 3L;
    private Component component;
    private TinyMCESettings settings;
    private boolean rendered = false;

    public TinyMceBehavior() {
        this(new TinyMCESettings());
    }

    public TinyMceBehavior(TinyMCESettings settings) {
        this.settings = settings;
    }

    public void beforeRender(Component component) {
        component.getResponse().write((CharSequence)String.format("<div id=\"%s\">", this.getAjaxRegionMarkupId(component)));
    }

    public void afterRender(Component component) {
        component.getResponse().write((CharSequence)"</div>");
    }

    public void renderHead(Component c, IHeaderResponse response) {
        super.renderHead(c, response);
        if (this.component == null) {
            throw new IllegalStateException("TinyMceBehavior is not bound to a component");
        }
        ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(TinyMCESettings.javaScriptReference(), null);
        Url url = new Url();
        List segments = url.getSegments();
        segments.add(Application.get().getMapperContext().getNamespace());
        segments.add(Application.get().getMapperContext().getResourceIdentifier());
        segments.add(handler.getResourceReference().getScope().getName());
        this.settings.setDocumentBaseUrl(url.toString());
        if (this.mayRenderJavascriptDirect()) {
            response.renderJavaScriptReference(TinyMCESettings.javaScriptReference());
        } else {
            TinyMCESettings.lazyLoadTinyMCEResource(response);
        }
        String renderOnDomReady = this.getAddTinyMceSettingsScript(TinyMCESettings.Mode.exact, Collections.singletonList(this.component));
        response.renderOnDomReadyJavaScript(renderOnDomReady);
    }

    private boolean mayRenderJavascriptDirect() {
        return RequestCycle.get().getRequest() instanceof WebRequest && !((WebRequest)RequestCycle.get().getRequest()).isAjax();
    }

    protected String getAddTinyMceSettingsScript(TinyMCESettings.Mode mode, Collection<Component> components) {
        StringBuffer script = new StringBuffer();
        if (this.rendered) {
            for (Component c : components) {
                String tryToRemoveJS = "try{tinyMCE.remove(tinyMCE.get('%s'));}catch(e){}\n";
                script.append(String.format(tryToRemoveJS, c.getMarkupId()));
            }
        }
        script.append(this.settings.getLoadPluginJavaScript());
        script.append(" tinyMCE.init({" + this.settings.toJavaScript(mode, components) + " });\n");
        script.append(this.settings.getAdditionalPluginJavaScript());
        this.rendered = true;
        return script.toString();
    }

    public void bind(Component component) {
        if (this.component != null) {
            throw new IllegalStateException("TinyMceBehavior can not bind to more than one component");
        }
        super.bind(component);
        if (this.isMarkupIdRequired()) {
            component.setOutputMarkupId(true);
        }
        this.component = component;
    }

    protected boolean isMarkupIdRequired() {
        return true;
    }

    protected Component getComponent() {
        return this.component;
    }

    public String getAjaxRegionMarkupId(Component component) {
        return component.getMarkupId() + "_wrapper_component";
    }
}

