/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.tinymce.image;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.apache.wicket.Component;
import org.apache.wicket.IResourceListener;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wicket.contrib.tinymce.image.FileResourceStream;
import wicket.contrib.tinymce.image.ImageFileDescription;
import wicket.contrib.tinymce.image.ImageUploadContentPanel;
import wicket.contrib.tinymce.image.ImageUploadHelper;

public class ImageUploadPanel
extends Panel
implements IResourceListener {
    private static final long serialVersionUID = -5848356532326545817L;
    private static final Logger log = LoggerFactory.getLogger(ImageUploadPanel.class);
    private static final ResourceReference IMAGE_UPLOAD_JS_RESOURCE = new JavaScriptResourceReference(ImageUploadPanel.class, "imageUpload.js");
    private ModalWindow modalWindow;
    private ImageUploadBehavior imageUploadBehavior;

    public ImageUploadPanel(String pId) {
        super(pId);
        this.setOutputMarkupId(true);
        Component[] componentArray = new Component[1];
        this.modalWindow = new ModalWindow("imageUploadDialog");
        componentArray[0] = this.modalWindow;
        this.add(componentArray);
        this.modalWindow.setTitle((IModel)new ResourceModel("title.label"));
        this.modalWindow.setInitialHeight(100);
        this.modalWindow.setInitialWidth(350);
        this.modalWindow.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 1L;

            public void onClose(AjaxRequestTarget pTarget) {
                ImageUploadPanel.this.resetModalContent();
            }
        });
        Behavior[] behaviorArray = new Behavior[1];
        this.imageUploadBehavior = new ImageUploadBehavior();
        behaviorArray[0] = this.imageUploadBehavior;
        this.add(behaviorArray);
    }

    public void resetModalContent() {
        this.modalWindow.setContent((Component)new EmptyPanel(this.modalWindow.getContentId()));
    }

    public void onResourceRequested() {
        String fileName = RequestCycle.get().getRequest().getQueryParameters().getParameterValue("filename").toString();
        if (Strings.isEmpty((CharSequence)fileName)) {
            log.warn("There is no file name of image");
            return;
        }
        String contentType = RequestCycle.get().getRequest().getQueryParameters().getParameterValue("contenttype").toString();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(ImageUploadHelper.getTemporaryDirPath() + File.separatorChar + fileName);
        }
        catch (FileNotFoundException ex) {
            log.error("Problem with getting image - " + ex.getMessage(), (Throwable)ex);
            throw new RuntimeException("Problem with getting image");
        }
        RequestCycle.get().scheduleRequestHandlerAfterCurrent((IRequestHandler)new ResourceStreamRequestHandler((IResourceStream)new FileResourceStream(contentType, inputStream)));
    }

    public ImageUploadBehavior getImageUploadBehavior() {
        return this.imageUploadBehavior;
    }

    public class ImageUploadBehavior
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 7786779421116467886L;

        protected void respond(AjaxRequestTarget pTarget) {
            ImageUploadContentPanel content = new ImageUploadContentPanel(ImageUploadPanel.this.modalWindow.getContentId()){
                private static final long serialVersionUID = 1L;

                public void onImageUploaded(ImageFileDescription pImageFileDescription, AjaxRequestTarget pTarget) {
                    ImageUploadPanel.this.modalWindow.close(pTarget);
                    ImageUploadPanel.this.resetModalContent();
                    CharSequence url = ImageUploadPanel.this.urlFor(IResourceListener.INTERFACE);
                    XmlTag xmlImageTag = ImageUploadHelper.createImageTag(pImageFileDescription, url);
                    pTarget.appendJavaScript((CharSequence)("putImage('" + xmlImageTag.toString() + "');"));
                }
            };
            ImageUploadPanel.this.modalWindow.setContent((Component)content);
            pTarget.appendJavaScript((CharSequence)"saveBookmark();");
            ImageUploadPanel.this.modalWindow.show(pTarget);
        }

        public String getCallbackName() {
            return "showImageUploadDialog";
        }

        public void renderHead(Component c, IHeaderResponse pResponse) {
            String script = this.getCallbackName() + " = function () { " + this.getCallbackScript() + " }";
            pResponse.renderOnDomReadyJavaScript(script);
            pResponse.renderJavaScriptReference(IMAGE_UPLOAD_JS_RESOURCE);
        }
    }
}

