/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.tinymce.settings;

import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.event.StringWordTokenizer;
import com.swabunga.spell.event.WordTokenizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.resource.IResourceStreamWriter;
import org.apache.wicket.util.resource.StringBufferResourceStream;
import org.apache.wicket.util.time.Time;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JazzySpellChecker
extends AbstractResource {
    protected static final String dictFile = "wicket/contrib/tinymce/jazzy/english.0";
    private SpellDictionary dict;
    private StringBufferResourceStream resourceStream;
    protected static final String contentType = "application/json";
    private static final Logger LOG = LoggerFactory.getLogger(JazzySpellChecker.class);
    private static final long serialVersionUID = 1L;

    public JazzySpellChecker() {
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(dictFile);
        InputStreamReader reader = new InputStreamReader(inputStream);
        try {
            this.dict = new SpellDictionaryHashMap((Reader)reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.resourceStream = new StringBufferResourceStream(contentType);
    }

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        this.buildResourceStream();
        if (attributes.getResponse() instanceof WebResponse) {
            ((WebResponse)attributes.getResponse()).setHeader("Cache-Control", "no-cache, must-revalidate");
        }
        AbstractResource.ResourceResponse resourceResponse = new AbstractResource.ResourceResponse();
        resourceResponse.setWriteCallback(new AbstractResource.WriteCallback(){

            public void writeData(IResource.Attributes attributes) {
                ((IResourceStreamWriter)JazzySpellChecker.this.resourceStream).write(attributes.getResponse());
                try {
                    JazzySpellChecker.this.resourceStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return resourceResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildResourceStream() {
        String cmd = null;
        String id = null;
        JSONArray paramArray = null;
        HttpServletRequest req = ((ServletWebRequest)RequestCycle.get().getRequest()).getContainerRequest();
        BufferedReader reader = null;
        try {
            ServletInputStream sis = req.getInputStream();
            reader = new BufferedReader(new InputStreamReader((InputStream)sis, "UTF-8"));
            JSONObject json = new JSONObject(new JSONTokener((Reader)reader));
            id = json.getString("id");
            cmd = json.getString("method");
            paramArray = json.getJSONArray("params");
        }
        catch (IOException e) {
            this.jsonError("I/O exception while parsing");
        }
        catch (JSONException e) {
            this.jsonError("Could not parse command");
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (paramArray == null) {
            this.handleEmptyCheckList(cmd, id);
        } else if ("checkWords".equals(cmd)) {
            this.doSpell(cmd, id, paramArray);
        } else if ("getSuggestions".equals(cmd)) {
            this.doSuggest(cmd, id, paramArray);
        } else {
            this.jsonError("Unknown command");
        }
    }

    private void handleEmptyCheckList(String cmd, String id) {
        this.respond(null, cmd, id);
    }

    private void doSuggest(String cmd, String id, JSONArray paramArray) {
        SpellChecker checker = new SpellChecker(this.dict);
        String word = paramArray.optString(1);
        List suggestions = checker.getSuggestions(word, 2);
        this.respond(suggestions.iterator(), cmd, id);
    }

    private void doSpell(String cmd, String id, JSONArray paramArray) {
        SpellChecker checker = new SpellChecker(this.dict);
        final HashSet errors = new HashSet();
        checker.addSpellCheckListener(new SpellCheckListener(){

            public void spellingError(SpellCheckEvent event) {
                errors.add(event.getInvalidWord());
            }
        });
        JSONArray words = paramArray.optJSONArray(1);
        checker.checkSpelling((WordTokenizer)new StringWordTokenizer(words.toString()));
        this.respond(errors.iterator(), cmd, id);
    }

    private void respond(Iterator<String> words, String cmd, String id) {
        JSONArray array = new JSONArray();
        if (words != null) {
            while (words.hasNext()) {
                array.put((Object)words.next());
            }
        }
        JSONObject response = new JSONObject();
        try {
            response.put("id", (Object)id);
            response.put("error", (Object)null);
            response.put("result", (Object)array);
            this.setResponse(response.toString());
        }
        catch (JSONException e) {
            this.jsonError("Failed to construct response");
        }
    }

    private void setResponse(String response) {
        this.resourceStream.clear();
        this.resourceStream.append((CharSequence)response);
        this.resourceStream.setLastModified(Time.now());
    }

    private void jsonError(String message) {
        this.setResponse("{\"error\":\"" + message + "\"}");
        LOG.debug("Error message return from RPC call: {}", (Object)message);
    }
}

