/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.tinymce.settings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.Session;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wicket.contrib.tinymce.InPlaceEditBehavior;
import wicket.contrib.tinymce.settings.Button;
import wicket.contrib.tinymce.settings.Control;
import wicket.contrib.tinymce.settings.Enum;
import wicket.contrib.tinymce.settings.Plugin;
import wicket.contrib.tinymce.settings.PluginButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinyMCESettings
implements Serializable {
    private static final long serialVersionUID = 3L;
    private static final Logger LOG = LoggerFactory.getLogger(TinyMCESettings.class);
    public static final ResourceReference REFERENCE = new JavaScriptResourceReference(InPlaceEditBehavior.class, "tiny_mce/tiny_mce_src.js");
    public static final ResourceReference REFERENCE_MIN = new JavaScriptResourceReference(InPlaceEditBehavior.class, "tiny_mce/tiny_mce.js");
    public static final Set<Language> languages = new HashSet<Language>(Arrays.asList(Language.values()));
    private Theme theme;
    private Location toolbarLocation;
    private Location statusbarLocation;
    private Align toolbarAlign;
    private Language language;
    private EntityEncoding entityEncoding;
    private boolean resizing = false;
    private boolean horizontalResizing = true;
    private boolean resizingUseCookie = true;
    @Deprecated
    private boolean autoResize = false;
    private boolean readOnly = false;
    private Set<Plugin> plugins = new ListOrderedSet();
    private List<Control> controls = new LinkedList<Control>();
    private Set<Button> disabledButtons = new ListOrderedSet();
    private Map<Toolbar, List<Button>> toolbarButtons;
    private Boolean convertUrls = null;
    private Boolean removeScriptHost = null;
    private Boolean relativeUrls = null;
    private String blockFormats = null;
    private ResourceReference contentCss = null;
    private String documentBaseUrl;
    private List<String> customSettings;

    public TinyMCESettings() {
        this(Theme.simple);
    }

    public TinyMCESettings(Theme theme) {
        this(theme, TinyMCESettings.selectLang());
    }

    public TinyMCESettings(Theme theme, Language lang) {
        this.theme = theme;
        this.language = lang;
    }

    private static Language selectLang() {
        try {
            return Language.valueOf(Session.get().getLocale().getLanguage());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Theme getTheme() {
        return this.theme;
    }

    public Language getLanguage() {
        return this.language;
    }

    public String getDocumentBaseUrl() {
        return this.documentBaseUrl;
    }

    public void setDocumentBaseUrl(String documentBaseUrl) {
        this.documentBaseUrl = documentBaseUrl;
    }

    public void addCustomSetting(String customSetting) {
        if (this.customSettings == null) {
            this.customSettings = new ArrayList<String>();
        }
        this.customSettings.add(customSetting);
    }

    public String[] getCustomSettings() {
        return this.customSettings.toArray(new String[this.customSettings.size()]);
    }

    public ResourceReference getContentCss() {
        return this.contentCss;
    }

    public void setContentCss(ResourceReference contentCss) {
        this.contentCss = contentCss;
    }

    @Deprecated
    public boolean getAutoResize() {
        return this.autoResize;
    }

    @Deprecated
    public void setAutoResize(boolean auto_resize) {
        this.autoResize = auto_resize;
    }

    public String getBlockFormats() {
        return this.blockFormats;
    }

    public void setBlockFormats(String blockFormats) {
        this.blockFormats = blockFormats;
    }

    public void setToolbarLocation(Location toolbarLocation) {
        this.toolbarLocation = toolbarLocation;
    }

    public Location getToolbarLocation() {
        return this.toolbarLocation;
    }

    public void setStatusbarLocation(Location statusbarLocation) {
        this.statusbarLocation = statusbarLocation;
    }

    public Location getStatusbarLocation() {
        return this.statusbarLocation;
    }

    public void setToolbarAlign(Align toolbarAlign) {
        this.toolbarAlign = toolbarAlign;
    }

    public Align getToolbarAlign() {
        return this.toolbarAlign;
    }

    public void setEntityEncoding(EntityEncoding entityEncoding) {
        this.entityEncoding = entityEncoding;
    }

    public EntityEncoding getEntityEncoding() {
        return this.entityEncoding;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setResizing(boolean resizing) {
        this.resizing = resizing;
    }

    public boolean getResizing() {
        return this.resizing;
    }

    public void setHorizontalResizing(boolean horizontalResizing) {
        this.horizontalResizing = horizontalResizing;
    }

    public boolean getHorizontalResizing() {
        return this.horizontalResizing;
    }

    public boolean getResizingUseCookie() {
        return this.resizingUseCookie;
    }

    public void setResizingUseCookie(boolean resizingUseCookie) {
        this.resizingUseCookie = resizingUseCookie;
    }

    public void setConvertUrls(boolean convertUrls) {
        this.convertUrls = convertUrls;
    }

    public Boolean getConvertUrls() {
        return this.convertUrls;
    }

    public void setRemoveScriptHost(Boolean removeScriptHost) {
        this.removeScriptHost = removeScriptHost;
    }

    public Boolean getRemoveScriptHost() {
        return this.removeScriptHost;
    }

    public void setRelativeUrls(Boolean relativeUrls) {
        this.relativeUrls = relativeUrls;
    }

    public Boolean getRelativeUrls() {
        return this.relativeUrls;
    }

    public void add(Button button, Toolbar toolbar, Position position) {
        if (button instanceof PluginButton) {
            this.register(((PluginButton)button).getPlugin());
        }
        this.controls.add(new Control(button, toolbar, position));
    }

    @Deprecated
    public void add(PluginButton button, Toolbar toolbar, Position position) {
        this.register(button.getPlugin());
        this.controls.add(new Control(button, toolbar, position));
    }

    public void disableButton(Button button) {
        this.disabledButtons.add(button);
    }

    public void setToolbarButtons(Toolbar toolbar, List<Button> buttons) {
        if (!Theme.advanced.equals(this.theme)) {
            throw new IllegalArgumentException("setToolbarButtons is only applicable for advanced theme");
        }
        if (this.toolbarButtons == null) {
            this.toolbarButtons = new HashMap<Toolbar, List<Button>>();
        }
        if (buttons == null) {
            this.toolbarButtons.remove(toolbar);
        } else {
            this.toolbarButtons.put(toolbar, buttons);
        }
    }

    public List<Button> getToolbarButtons(Toolbar toolbar) {
        List<Button> result = null;
        if (this.toolbarButtons != null) {
            result = this.toolbarButtons.get(toolbar);
        }
        return result;
    }

    public void register(Plugin plugin) {
        this.plugins.add(plugin);
    }

    Set<Plugin> getPlugins() {
        return this.plugins;
    }

    public final String toJavaScript(Mode mode, Collection<Component> components) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n\t").append("mode : \"" + mode.getName() + "\"");
        if (Mode.exact.equals(mode)) {
            this.addElements(components, buffer);
        }
        if (this.language != null) {
            buffer.append(",\n\t").append("language : ").append("\"").append(this.language.toString()).append("\"");
        }
        buffer.append(",\n\t").append("theme : ").append("\"").append(this.theme.getName()).append("\"");
        buffer.append(this.toJavaScript());
        return buffer.toString();
    }

    String toJavaScript() {
        StringBuffer buffer = new StringBuffer();
        if (this.convertUrls != null) {
            buffer.append(",\n\t").append("convert_urls : ").append(this.convertUrls);
        }
        if (this.relativeUrls != null) {
            buffer.append(",\n\t").append("relative_urls : ").append(this.relativeUrls);
        }
        if (this.removeScriptHost != null) {
            buffer.append(",\n\t").append("remove_script_host : ").append(this.removeScriptHost);
        }
        if (this.autoResize) {
            buffer.append(",\n\tauto_resize : true");
        }
        if (this.readOnly) {
            buffer.append(",\n\treadonly : true");
        }
        if (this.contentCss != null) {
            buffer.append(",\n\t").append("content_css : \"").append(RequestCycle.get().urlFor(this.contentCss, null)).append("\"");
        }
        if (this.documentBaseUrl != null) {
            buffer.append(",\n\t").append("document_base_url : \"").append(this.documentBaseUrl).append("\"");
        }
        if (this.entityEncoding != null) {
            buffer.append(",\n\t").append("entity_encoding : \"").append(this.entityEncoding).append("\"");
        }
        if (Theme.advanced.equals(this.theme)) {
            this.appendAdvancedSettings(buffer);
        }
        this.appendPluginSettings(buffer);
        this.appendCustomSettings(buffer);
        return buffer.toString();
    }

    private void appendCustomSettings(StringBuffer buffer) {
        if (this.customSettings != null) {
            for (String line : this.customSettings) {
                buffer.append(",\n\t").append(line);
            }
        }
    }

    private void addElements(Collection<Component> components, StringBuffer buffer) {
        if (components.size() > 0) {
            buffer.append(",\n\telements : \"");
            Iterator<Component> iterator = components.iterator();
            while (iterator.hasNext()) {
                Component component = iterator.next();
                buffer.append(component.getMarkupId());
                if (!iterator.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append("\"");
        } else {
            LOG.warn("tinymce is set to \"exact\" mode but there are no components attached");
        }
    }

    private void appendPluginSettings(StringBuffer buffer) {
        if (this.plugins.size() > 0) {
            for (Plugin plugin : this.plugins) {
                plugin.definePluginSettings(buffer);
            }
        }
    }

    public String getLoadPluginJavaScript() {
        StringBuffer loadPluginJavaScript = new StringBuffer();
        if (this.plugins.size() > 0) {
            for (Plugin plugin : this.plugins) {
                String pluginPath = plugin.getPluginPath();
                if (pluginPath == null || pluginPath.equals("")) continue;
                loadPluginJavaScript.append("tinymce.PluginManager.load('");
                loadPluginJavaScript.append(plugin.getName());
                loadPluginJavaScript.append("','");
                loadPluginJavaScript.append(pluginPath);
                loadPluginJavaScript.append("');\n");
            }
        }
        return loadPluginJavaScript.toString();
    }

    public String getAdditionalPluginJavaScript() {
        StringBuffer buffer = new StringBuffer();
        if (this.plugins.size() > 0) {
            for (Plugin plugin : this.plugins) {
                plugin.definePluginExtensions(buffer);
            }
        }
        return buffer.toString();
    }

    private void appendAdvancedSettings(StringBuffer buffer) {
        this.addDisabledButtons(buffer);
        this.addPlugins(buffer);
        this.addButtons(buffer);
        this.addButtons1_Before(buffer);
        this.addButtons1_After(buffer);
        this.addButtons2_Before(buffer);
        this.addButtons2_After(buffer);
        this.addButtons3_Before(buffer);
        this.addButtons3_After(buffer);
        this.addButtons4(buffer);
        this.addToolbarLocation(buffer);
        this.addStatusbarLocation(buffer);
        this.addToolbarAlign(buffer);
        this.addResizing(buffer);
        this.addBlockFormats(buffer);
    }

    void addPlugins(StringBuffer buffer) {
        if (this.plugins.size() > 0) {
            buffer.append(",\n\t").append("plugins : ").append("\"");
            Iterator<Plugin> iterator = this.plugins.iterator();
            int count = 0;
            while (iterator.hasNext()) {
                String pluginPath;
                Plugin plugin = iterator.next();
                if (count > 0) {
                    buffer.append(", ");
                }
                if ((pluginPath = plugin.getPluginPath()) != null && !pluginPath.equals("")) {
                    buffer.append("-");
                }
                buffer.append(plugin.getName());
                ++count;
            }
            buffer.append("\"");
        }
    }

    private void addButtons(StringBuffer buffer) {
        if (this.toolbarButtons != null) {
            for (int i = 1; i <= 3; ++i) {
                Toolbar toolbar = this.getToolbar(i);
                List<Button> buttons = this.toolbarButtons.get(toolbar);
                if (buttons == null) continue;
                buffer.append(",\n\ttheme_advanced_buttons").append(i).append(" : \"").append(this.enumAsString(buttons)).append("\"");
            }
        }
    }

    private Toolbar getToolbar(int index) {
        if (index == 1) {
            return Toolbar.first;
        }
        if (index == 2) {
            return Toolbar.second;
        }
        if (index == 3) {
            return Toolbar.third;
        }
        if (index == 4) {
            return Toolbar.fourth;
        }
        throw new IllegalArgumentException("Not a valid toolbar index: " + index);
    }

    private void addButtons1_Before(StringBuffer buffer) {
        ControlPredicate predicate = new ControlPredicate(Toolbar.first, Position.before);
        Collection result = CollectionUtils.select(this.controls, (Predicate)predicate);
        if (result.size() > 0) {
            buffer.append(",\n\t").append("theme_advanced_buttons1_add_before : ").append("\"").append(this.controlsAsString(result)).append("\"");
        }
    }

    private void addButtons1_After(StringBuffer buffer) {
        ControlPredicate predicate = new ControlPredicate(Toolbar.first, Position.after);
        Collection result = CollectionUtils.select(this.controls, (Predicate)predicate);
        if (result.size() > 0) {
            buffer.append(",\n\t").append("theme_advanced_buttons1_add : ").append("\"").append(this.controlsAsString(result)).append("\"");
        }
    }

    private void addButtons2_Before(StringBuffer buffer) {
        ControlPredicate predicate = new ControlPredicate(Toolbar.second, Position.before);
        Collection result = CollectionUtils.select(this.controls, (Predicate)predicate);
        if (result.size() > 0) {
            buffer.append(",\n\t").append("theme_advanced_buttons2_add_before: ").append("\"").append(this.controlsAsString(result)).append("\"");
        }
    }

    private void addButtons2_After(StringBuffer buffer) {
        ControlPredicate predicate = new ControlPredicate(Toolbar.second, Position.after);
        Collection result = CollectionUtils.select(this.controls, (Predicate)predicate);
        if (result.size() > 0) {
            buffer.append(",\n\t").append("theme_advanced_buttons2_add : ").append("\"").append(this.controlsAsString(result)).append("\"");
        }
    }

    private void addButtons3_Before(StringBuffer buffer) {
        ControlPredicate predicate = new ControlPredicate(Toolbar.third, Position.before);
        Collection result = CollectionUtils.select(this.controls, (Predicate)predicate);
        if (result.size() > 0) {
            buffer.append(",\n\t").append("theme_advanced_buttons3_add_before : ").append("\"").append(this.controlsAsString(result)).append("\"");
        }
    }

    private void addButtons3_After(StringBuffer buffer) {
        ControlPredicate predicate = new ControlPredicate(Toolbar.third, Position.after);
        Collection result = CollectionUtils.select(this.controls, (Predicate)predicate);
        if (result.size() > 0) {
            buffer.append(",\n\t").append("theme_advanced_buttons3_add : ").append("\"").append(this.controlsAsString(result)).append("\"");
        }
    }

    private void addButtons4(StringBuffer buffer) {
        ControlPredicate predicate = new ControlPredicate(Toolbar.fourth, Position.before);
        Collection result = CollectionUtils.select(this.controls, (Predicate)predicate);
        if (result.size() > 0) {
            buffer.append(",\n\t").append("theme_advanced_buttons4 : ").append("\"").append(this.controlsAsString(result)).append("\"");
        }
        if ((result = CollectionUtils.select(this.controls, (Predicate)(predicate = new ControlPredicate(Toolbar.fourth, Position.after)))).size() > 0) {
            buffer.append(",\n\t").append("theme_advanced_buttons4 : ").append("\"").append(this.controlsAsString(result)).append("\"");
        }
    }

    void addDisabledButtons(StringBuffer buffer) {
        if (this.disabledButtons.size() > 0) {
            String value = this.enumAsString(this.disabledButtons);
            buffer.append(",\n\t").append("theme_advanced_disable : ").append("\"").append(value).append("\"");
        }
    }

    private String controlsAsString(Collection controls) {
        ArrayList<Button> buttons = new ArrayList<Button>();
        for (Control control : controls) {
            buttons.add(control.getButton());
        }
        return this.enumAsString(buttons);
    }

    private String enumAsString(Collection enums) {
        StringBuffer buffer = new StringBuffer();
        for (Enum enumObject : enums) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append(enumObject.getName());
        }
        return buffer.toString();
    }

    void addResizing(StringBuffer buffer) {
        if (this.resizing) {
            buffer.append(",\n\ttheme_advanced_resizing : true");
            this.addHorizontalResizing(buffer);
            this.addResizingUseCookie(buffer);
        }
    }

    private void addHorizontalResizing(StringBuffer buffer) {
        if (!this.horizontalResizing) {
            buffer.append(",\n\ttheme_advanced_resize_horizontal : false");
        }
    }

    private void addResizingUseCookie(StringBuffer buffer) {
        if (!this.resizingUseCookie) {
            buffer.append(",\n\ttheme_advanced_resizing_use_cookie : false");
        }
    }

    void addBlockFormats(StringBuffer buffer) {
        if (this.blockFormats != null) {
            buffer.append(",\n\ttheme_advanced_blockformats : \"").append(this.blockFormats).append("\"");
        }
    }

    void addToolbarAlign(StringBuffer buffer) {
        if (this.toolbarAlign != null) {
            buffer.append(",\n\t").append("theme_advanced_toolbar_align : ").append("\"").append(this.toolbarAlign.getName()).append("\"");
        }
    }

    void addToolbarLocation(StringBuffer buffer) {
        if (this.toolbarLocation != null) {
            buffer.append(",\n\t").append("theme_advanced_toolbar_location : ").append("\"").append(this.toolbarLocation.getName()).append("\"");
        }
    }

    void addStatusbarLocation(StringBuffer buffer) {
        if (this.statusbarLocation != null) {
            buffer.append(",\n\t").append("theme_advanced_statusbar_location : ").append("\"").append(this.statusbarLocation.getName()).append("\"");
        }
    }

    public static ResourceReference javaScriptReference() {
        Application app = Application.get();
        if (RuntimeConfigurationType.DEVELOPMENT.equals((Object)app.getConfigurationType())) {
            return REFERENCE;
        }
        return REFERENCE_MIN;
    }

    public static void lazyLoadTinyMCEResource(IHeaderResponse response) {
        String url = ((Object)RequestCycle.get().urlFor(TinyMCESettings.javaScriptReference(), null)).toString();
        String base = url.substring(0, url.lastIndexOf("/"));
        response.renderJavaScript((CharSequence)("window.tinyMCEPreInit = {base : '" + base + "', suffix : '', query : ''};"), "tinyMceHackPreload");
        response.renderJavaScriptReference(TinyMCESettings.javaScriptReference());
        response.renderJavaScript((CharSequence)"window.tinymce.dom.Event.domLoaded = true;", "tinyMceHackPostload");
    }

    public static class EntityEncoding
    extends Enum {
        private static final long serialVersionUID = 1L;
        public static final EntityEncoding named = new EntityEncoding("named");
        public static final EntityEncoding numeric = new EntityEncoding("numeric");
        public static final EntityEncoding raw = new EntityEncoding("raw");

        protected EntityEncoding(String name) {
            super(name);
        }
    }

    public static class Toolbar
    extends Enum {
        private static final long serialVersionUID = 1L;
        public static final Toolbar first = new Toolbar("first");
        public static final Toolbar second = new Toolbar("second");
        public static final Toolbar third = new Toolbar("third");
        public static final Toolbar fourth = new Toolbar("fourth");

        public Toolbar(String name) {
            super(name);
        }
    }

    public static class Position
    extends Enum {
        private static final long serialVersionUID = 1L;
        public static final Position before = new Position("before");
        public static final Position after = new Position("after");

        public Position(String name) {
            super(name);
        }
    }

    public static class Align
    extends Enum {
        private static final long serialVersionUID = 1L;
        public static final Align left = new Align("left");
        public static final Align center = new Align("center");
        public static final Align right = new Align("right");

        private Align(String name) {
            super(name);
        }
    }

    public static class Location
    extends Enum {
        private static final long serialVersionUID = 1L;
        public static final Location top = new Location("top");
        public static final Location bottom = new Location("bottom");

        private Location(String name) {
            super(name);
        }
    }

    public static class Theme
    extends Enum {
        private static final long serialVersionUID = 1L;
        public static final Theme simple = new Theme("simple");
        public static final Theme advanced = new Theme("advanced");

        private Theme(String name) {
            super(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Language {
        ar,
        bg,
        bs,
        ca,
        ch,
        cs,
        da,
        de,
        el,
        en,
        es,
        et,
        fa,
        fi,
        fr,
        gl,
        he,
        hr,
        hu,
        ia,
        ii,
        is,
        it,
        ja,
        ko,
        lt,
        lv,
        mk,
        ms,
        nb,
        nl,
        nn,
        pl,
        pt,
        ro,
        ru,
        sc,
        se,
        si,
        sk,
        sl,
        sr,
        sv,
        tr,
        tt,
        tw,
        uk,
        vi,
        zh;

    }

    public static class Mode
    extends Enum {
        private static final long serialVersionUID = 1L;
        public static final Mode none = new Mode("none");
        public static final Mode exact = new Mode("exact");

        private Mode(String name) {
            super(name);
        }
    }

    private class ControlPredicate
    implements Predicate {
        private Toolbar toolbar;
        private Position position;

        public ControlPredicate(Toolbar toolbar, Position position) {
            this.toolbar = toolbar;
            this.position = position;
        }

        public boolean evaluate(Object object) {
            Control control = (Control)object;
            return this.toolbar.equals(control.getToolbar()) && this.position.equals(control.getPosition());
        }
    }
}

