/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.tinymce.settings;

import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.util.string.JavaScriptUtils;
import wicket.contrib.tinymce.InPlaceSaveBehavior;
import wicket.contrib.tinymce.settings.Plugin;
import wicket.contrib.tinymce.settings.PluginButton;

public class WicketSavePlugin
extends Plugin {
    private static final long serialVersionUID = 1L;
    private PluginButton saveButton = new PluginButton("save", this);
    private PluginButton cancelButton = new PluginButton("cancel", this);
    private String saveCallbackname;
    private String cancelCallbackname;
    private StringResourceModel saveMessage;

    public WicketSavePlugin(InPlaceSaveBehavior behavior) {
        super("wicketsave");
        this.saveCallbackname = behavior.getSaveCallbackName();
        this.cancelCallbackname = behavior.getCancelCallbackName();
        this.saveMessage = new StringResourceModel("wicket_updating_mess", behavior.getTheComponent(), null, new Object[0]);
    }

    public PluginButton getSaveButton() {
        return this.saveButton;
    }

    public PluginButton getCancelButton() {
        return this.cancelButton;
    }

    protected void definePluginSettings(StringBuffer buffer) {
        super.definePluginSettings(buffer);
        buffer.append(",\n\tsave_onwicketsavecallback: '" + this.saveCallbackname + "'");
        buffer.append(",\n\tsave_onwicketcancelcallback: '" + this.cancelCallbackname + "'");
        buffer.append(",\n\twicket_updating_mess: '" + JavaScriptUtils.escapeQuotes((CharSequence)this.saveMessage.getString()) + "'");
    }
}

