/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.tinymce;

import java.util.Collection;
import java.util.Collections;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.resource.ResourceReference;
import wicket.contrib.tinymce.settings.TinyMCESettings;

public class TinyMceBehavior
extends Behavior {
    private static final long serialVersionUID = 3L;
    private Component component;
    private TinyMCESettings settings;
    private boolean rendered = false;

    public TinyMceBehavior() {
        this(new TinyMCESettings());
    }

    public TinyMceBehavior(TinyMCESettings settings) {
        this.settings = settings;
    }

    public void renderHead(Component c, IHeaderResponse response) {
        super.renderHead(c, response);
        if (this.component == null) {
            throw new IllegalStateException("TinyMceBehavior is not bound to a component");
        }
        if (this.mayRenderJavascriptDirect()) {
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)TinyMCESettings.javaScriptReference()));
        } else {
            TinyMCESettings.lazyLoadTinyMCEResource(response);
        }
        String renderOnDomReady = this.getAddTinyMceSettingsScript(TinyMCESettings.Mode.exact, Collections.singletonList(this.component));
        response.render(this.wrapTinyMceSettingsScript(renderOnDomReady, this.component));
    }

    protected HeaderItem wrapTinyMceSettingsScript(String settingScript, Component component) {
        return OnDomReadyHeaderItem.forScript((CharSequence)settingScript);
    }

    private boolean mayRenderJavascriptDirect() {
        return RequestCycle.get().getRequest() instanceof WebRequest && !((WebRequest)RequestCycle.get().getRequest()).isAjax();
    }

    protected String getAddTinyMceSettingsScript(TinyMCESettings.Mode mode, Collection<Component> components) {
        StringBuffer script = new StringBuffer();
        if (this.rendered) {
            for (Component c : components) {
                String tryToRemoveJS = "try{tinyMCE.remove(tinyMCE.get('%s'));}catch(e){}\n";
                script.append(String.format(tryToRemoveJS, c.getMarkupId()));
            }
        }
        script.append(this.settings.getLoadPluginJavaScript());
        script.append(" tinyMCE.init({" + this.settings.toJavaScript(mode, components) + " });\n");
        script.append(this.settings.getAdditionalPluginJavaScript());
        this.rendered = true;
        return script.toString();
    }

    public void bind(Component component) {
        if (this.component != null) {
            throw new IllegalStateException("TinyMceBehavior can not bind to more than one component");
        }
        super.bind(component);
        if (this.isMarkupIdRequired()) {
            component.setOutputMarkupId(true);
        }
        this.component = component;
    }

    protected boolean isMarkupIdRequired() {
        return true;
    }

    protected Component getComponent() {
        return this.component;
    }
}

