/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.ClusterRoleScopeRestriction;
import io.fabric8.openshift.api.model.ClusterRoleScopeRestrictionBuilder;
import io.fabric8.openshift.api.model.ClusterRoleScopeRestrictionFluent;
import io.fabric8.openshift.api.model.ScopeRestriction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ScopeRestrictionFluent<A extends ScopeRestrictionFluent<A>>
extends BaseFluent<A> {
    private ClusterRoleScopeRestrictionBuilder clusterRole;
    private List<String> literals = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public ScopeRestrictionFluent() {
    }

    public ScopeRestrictionFluent(ScopeRestriction instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ScopeRestriction instance) {
        ScopeRestriction scopeRestriction = instance = instance != null ? instance : new ScopeRestriction();
        if (instance != null) {
            this.withClusterRole(instance.getClusterRole());
            this.withLiterals(instance.getLiterals());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ClusterRoleScopeRestriction buildClusterRole() {
        return this.clusterRole != null ? this.clusterRole.build() : null;
    }

    public A withClusterRole(ClusterRoleScopeRestriction clusterRole) {
        this._visitables.remove("clusterRole");
        if (clusterRole != null) {
            this.clusterRole = new ClusterRoleScopeRestrictionBuilder(clusterRole);
            this._visitables.get("clusterRole").add(this.clusterRole);
        } else {
            this.clusterRole = null;
            this._visitables.get("clusterRole").remove(this.clusterRole);
        }
        return (A)this;
    }

    public boolean hasClusterRole() {
        return this.clusterRole != null;
    }

    public ClusterRoleNested<A> withNewClusterRole() {
        return new ClusterRoleNested(null);
    }

    public ClusterRoleNested<A> withNewClusterRoleLike(ClusterRoleScopeRestriction item) {
        return new ClusterRoleNested(item);
    }

    public ClusterRoleNested<A> editClusterRole() {
        return this.withNewClusterRoleLike(Optional.ofNullable(this.buildClusterRole()).orElse(null));
    }

    public ClusterRoleNested<A> editOrNewClusterRole() {
        return this.withNewClusterRoleLike(Optional.ofNullable(this.buildClusterRole()).orElse(new ClusterRoleScopeRestrictionBuilder().build()));
    }

    public ClusterRoleNested<A> editOrNewClusterRoleLike(ClusterRoleScopeRestriction item) {
        return this.withNewClusterRoleLike(Optional.ofNullable(this.buildClusterRole()).orElse(item));
    }

    public A addToLiterals(int index, String item) {
        if (this.literals == null) {
            this.literals = new ArrayList<String>();
        }
        this.literals.add(index, item);
        return (A)this;
    }

    public A setToLiterals(int index, String item) {
        if (this.literals == null) {
            this.literals = new ArrayList<String>();
        }
        this.literals.set(index, item);
        return (A)this;
    }

    public A addToLiterals(String ... items) {
        if (this.literals == null) {
            this.literals = new ArrayList<String>();
        }
        for (String item : items) {
            this.literals.add(item);
        }
        return (A)this;
    }

    public A addAllToLiterals(Collection<String> items) {
        if (this.literals == null) {
            this.literals = new ArrayList<String>();
        }
        for (String item : items) {
            this.literals.add(item);
        }
        return (A)this;
    }

    public A removeFromLiterals(String ... items) {
        if (this.literals == null) {
            return (A)this;
        }
        for (String item : items) {
            this.literals.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromLiterals(Collection<String> items) {
        if (this.literals == null) {
            return (A)this;
        }
        for (String item : items) {
            this.literals.remove(item);
        }
        return (A)this;
    }

    public List<String> getLiterals() {
        return this.literals;
    }

    public String getLiteral(int index) {
        return this.literals.get(index);
    }

    public String getFirstLiteral() {
        return this.literals.get(0);
    }

    public String getLastLiteral() {
        return this.literals.get(this.literals.size() - 1);
    }

    public String getMatchingLiteral(Predicate<String> predicate) {
        for (String item : this.literals) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingLiteral(Predicate<String> predicate) {
        for (String item : this.literals) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withLiterals(List<String> literals) {
        if (literals != null) {
            this.literals = new ArrayList<String>();
            for (String item : literals) {
                this.addToLiterals(item);
            }
        } else {
            this.literals = null;
        }
        return (A)this;
    }

    public A withLiterals(String ... literals) {
        if (this.literals != null) {
            this.literals.clear();
            this._visitables.remove("literals");
        }
        if (literals != null) {
            for (String item : literals) {
                this.addToLiterals(item);
            }
        }
        return (A)this;
    }

    public boolean hasLiterals() {
        return this.literals != null && !this.literals.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScopeRestrictionFluent that = (ScopeRestrictionFluent)o;
        if (!Objects.equals(this.clusterRole, that.clusterRole)) {
            return false;
        }
        if (!Objects.equals(this.literals, that.literals)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clusterRole, this.literals, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterRole != null) {
            sb.append("clusterRole:");
            sb.append(this.clusterRole + ",");
        }
        if (this.literals != null && !this.literals.isEmpty()) {
            sb.append("literals:");
            sb.append(this.literals + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ClusterRoleNested<N>
    extends ClusterRoleScopeRestrictionFluent<ClusterRoleNested<N>>
    implements Nested<N> {
        ClusterRoleScopeRestrictionBuilder builder;

        ClusterRoleNested(ClusterRoleScopeRestriction item) {
            this.builder = new ClusterRoleScopeRestrictionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ScopeRestrictionFluent.this.withClusterRole(this.builder.build());
        }

        public N endClusterRole() {
            return this.and();
        }
    }
}

