/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel.maven;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.jboss.logging.Logger;

class RemoteArtifactVersionsFilter {
    private static final Logger LOG = Logger.getLogger(RemoteArtifactVersionsFilter.class);
    private final RepositorySystemSession session;
    private final Artifact artifact;
    private final List<RemoteRepository> repositories;
    private final Set<String> remoteRepositoryIds;
    private final VersionRangeResult versionRangeResult;

    RemoteArtifactVersionsFilter(RepositorySystemSession session, VersionRangeResult versionRangeResult) {
        this.session = session;
        this.artifact = versionRangeResult.getRequest().getArtifact();
        this.versionRangeResult = versionRangeResult;
        this.repositories = versionRangeResult.getRequest().getRepositories();
        this.remoteRepositoryIds = this.repositories.stream().map(RemoteRepository::getId).collect(Collectors.toSet());
    }

    boolean accept(Version version) {
        if (this.repositories.isEmpty()) {
            return false;
        }
        if (this.versionRangeResult.getRepository(version) != null && this.remoteRepositoryIds.contains(this.versionRangeResult.getRepository(version).getId())) {
            return true;
        }
        for (RemoteRepository repository : this.repositories) {
            DefaultMetadata artifactMetadata = new DefaultMetadata(this.artifact.getGroupId(), this.artifact.getArtifactId(), "maven-metadata.xml", Metadata.Nature.RELEASE);
            String pathForRemoteMetadata = this.session.getLocalRepositoryManager().getPathForRemoteMetadata(artifactMetadata, repository, null);
            File metadataFile = new File(this.session.getLocalRepository().getBasedir(), pathForRemoteMetadata);
            if (!metadataFile.exists()) continue;
            try {
                Metadata metadata = new MetadataXpp3Reader().read(new FileReader(metadataFile));
                if (!metadata.getVersioning().getVersions().contains(version.toString())) continue;
                return true;
            }
            catch (IOException | XmlPullParserException e) {
                LOG.warn((Object)("Failed to parse version information in " + metadataFile + ", skipping."), e);
            }
        }
        return false;
    }
}

