/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel.proxy;

import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.wildfly.channel.proxy.Settings;

enum SettingsFactory {
    HTTP("http.proxyHost", "http.proxyPort", "http.proxyUser", "http.proxyPassword", "http.proxyProtocol", "http", 80),
    HTTPS("https.proxyHost", "https.proxyPort", "https.proxyUser", "https.proxyPassword", "https.proxyProtocol", "https", 443);

    private String host;
    private String port;
    private String username;
    private String password;
    private String protocol;
    private String defaultProtocol;
    private int defaultPort;

    private SettingsFactory(String host, String port, String username, String password, String protocol, String defaultProtocol, int defaultPort) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.protocol = protocol;
        this.defaultProtocol = defaultProtocol;
        this.defaultPort = defaultPort;
    }

    public Settings createFromProperties(Properties properties) {
        String proxyHost = properties.getProperty(this.host);
        int proxyPort = Optional.ofNullable(properties.getProperty(this.port)).map(Integer::parseInt).orElse(this.defaultPort);
        String proxyProtocol = Optional.ofNullable(properties.getProperty(this.protocol)).orElse(this.defaultProtocol);
        String proxyUsername = properties.getProperty(this.username);
        String proxyPassword = properties.getProperty(this.password);
        Settings.Credentials credentials = null;
        if (proxyUsername != null && proxyPassword != null) {
            credentials = new Settings.Credentials(proxyUsername, proxyPassword);
        }
        return new Settings(proxyHost, proxyPort, proxyProtocol, credentials);
    }

    public Settings createFromSystemProperties() {
        return this.createFromProperties(System.getProperties());
    }

    public void setProperties(Settings settings, Properties properties) {
        properties.setProperty(this.host, settings.getHost());
        properties.setProperty(this.port, String.valueOf(settings.getPort()));
        properties.setProperty(this.protocol, settings.getProtocol());
        if (settings.hasCredentials()) {
            Settings.Credentials credentials = settings.getCredentials();
            properties.setProperty(this.username, credentials.getUsername());
            properties.setProperty(this.password, credentials.getPassword());
        }
    }

    public void setSystemProperties(Settings settings) {
        this.setProperties(settings, System.getProperties());
    }

    public void cleanupProperties(Properties properties) {
        for (String key : List.of(this.host, this.port, this.username, this.password)) {
            properties.remove(key);
        }
    }

    public String getProtocol() {
        return this.name().toLowerCase();
    }
}

