/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.wildfly.channel.Channel;
import org.wildfly.glow.Arguments;
import org.wildfly.glow.MetadataProvider;
import org.wildfly.glow.OutputFormat;
import org.wildfly.glow.Utils;

public class BaseArgumentsBuilder {
    protected Set<String> executionProfiles = Collections.emptySet();
    protected Set<String> userEnabledAddOns = Collections.emptySet();
    protected List<Path> binaries;
    protected Path provisioningXML;
    protected OutputFormat output;
    protected String executionContext;
    protected boolean suggest;
    protected String version;
    protected String configName;
    protected Set<String> layersForJndi = Collections.emptySet();
    protected boolean verbose;
    protected boolean techPreview;
    protected Set<String> excludeJarsFromScan = Collections.emptySet();
    protected String packageStability;
    protected String configStability;
    protected String defaultConfigStability;
    protected boolean isCli;
    protected List<Channel> channels;
    protected Set<String> spaces;
    protected MetadataProvider metadataProvider;

    protected BaseArgumentsBuilder() {
    }

    public Arguments build() {
        Set<Pattern> excludeJarsFromScan = this.excludeJarsFromScan.stream().map(v -> Pattern.compile(Utils.escapePattern(v))).collect(Collectors.toSet());
        return new Arguments(this.executionContext, this.executionProfiles, this.userEnabledAddOns, this.binaries, this.provisioningXML, this.output, this.suggest, this.version, this.configName, this.layersForJndi, this.verbose, this.techPreview, excludeJarsFromScan, this.configStability, this.packageStability, this.defaultConfigStability, this.isCli, this.channels, this.spaces, this.metadataProvider);
    }
}

