/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli.commands;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.galleon.util.IoUtils;
import org.wildfly.glow.MetadataProvider;
import org.wildfly.glow.Space;
import org.wildfly.glow.WildFlyMavenMetadataProvider;
import org.wildfly.glow.WildFlyMetadataProvider;
import org.wildfly.glow.cli.support.AbstractCommand;
import org.wildfly.glow.maven.MavenResolver;
import picocli.CommandLine;

@CommandLine.Command(name="show-server-versions", sortOptions=true)
public class ShowServerVersionsCommand
extends AbstractCommand {
    @CommandLine.Option(names={"-sp", "--spaces"}, split=",", paramLabel="<space1,space2, ...>")
    Set<String> spaces = new LinkedHashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws Exception {
        Integer n;
        block6: {
            this.print("WildFly server versions in the " + Space.DEFAULT.getName() + " space:");
            Path tmpMetadataDirectory = null;
            try {
                MetadataProvider metadataProvider;
                String prop = System.getProperty("wildfly-glow-galleon-feature-packs-url");
                if (prop == null) {
                    tmpMetadataDirectory = Files.createTempDirectory("wildfly-glow-metadata", new FileAttribute[0]);
                    metadataProvider = new WildFlyMavenMetadataProvider(MavenResolver.newMavenResolver(), tmpMetadataDirectory);
                } else {
                    tmpMetadataDirectory = null;
                    metadataProvider = new WildFlyMetadataProvider(new URI(prop));
                }
                this.print(metadataProvider.getAllVersions());
                for (String space : this.spaces) {
                    this.print("WildFly server versions in the " + space + " space:");
                    this.print(metadataProvider.getAllVersions(space));
                }
                this.print("@|bold WildFly server version can be set using the|@ @|fg(yellow) %s=<server version>|@ @|bold option of the|@ @|fg(yellow) %s|@ @|bold command|@", "--server-version", "scan");
                n = 0;
                if (tmpMetadataDirectory == null) break block6;
            }
            catch (Throwable throwable) {
                if (tmpMetadataDirectory != null) {
                    IoUtils.recursiveDelete(tmpMetadataDirectory);
                }
                throw throwable;
            }
            IoUtils.recursiveDelete(tmpMetadataDirectory);
        }
        return n;
    }
}

