/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.deployment.openshift.api;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import io.fabric8.openshift.client.OpenShiftClient;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.wildfly.glow.Env;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.deployment.openshift.api.Deployer;
import org.wildfly.glow.deployment.openshift.api.OpenShiftSupport;
import org.wildfly.glow.deployment.openshift.api.Utils;

public class AbstractDatabaseDeployer
implements Deployer {
    private static final String SAMPLEDB = "sampledb";
    private static final String PASSWORD = "admin";
    private static final String USER = "admin";
    private static final String SERVICE_PORT_ENV_SUFFIX = "_SERVICE_PORT";
    private static final String SERVICE_HOST_ENV_SUFFIX = "_SERVICE_HOST";
    private final String dbName;
    private final String image;
    private final String envRadical;
    private final int port;
    private final Map<String, String> CONNECTION_MAP = new HashMap<String, String>();
    private final Map<String, String> APP_MAP = new HashMap<String, String>();

    protected AbstractDatabaseDeployer(String dbName, String image, String dbEnvRadical, String envRadical, String host, int port) {
        this.dbName = dbName;
        this.image = image;
        this.envRadical = envRadical;
        this.port = port;
        this.CONNECTION_MAP.put(dbEnvRadical + "_DATABASE", SAMPLEDB);
        this.CONNECTION_MAP.put(dbEnvRadical + "_PASSWORD", "admin");
        this.CONNECTION_MAP.put(dbEnvRadical + "_USER", "admin");
        this.APP_MAP.put(envRadical + "_DATABASE", SAMPLEDB);
        this.APP_MAP.put(envRadical + "_PASSWORD", "admin");
        this.APP_MAP.put(envRadical + "_USER", "admin");
        this.APP_MAP.put(envRadical + SERVICE_PORT_ENV_SUFFIX, "" + port);
        this.APP_MAP.put(envRadical + SERVICE_HOST_ENV_SUFFIX, host);
    }

    @Override
    public Map<String, String> disabledDeploy(String appHost, String appName, String matching, Map<String, String> env) {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put(this.envRadical + SERVICE_HOST_ENV_SUFFIX, this.dbName + " server host name.");
        ret.put(this.envRadical + SERVICE_PORT_ENV_SUFFIX, this.dbName + "server port.");
        ret.putAll(this.getExistingEnv(env));
        return ret;
    }

    private Map<String, String> getExistingEnv(Map<String, String> env) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            if (!entry.getKey().startsWith(this.envRadical + "_")) continue;
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    @Override
    public Map<String, String> deploy(GlowMessageWriter writer, Path target, OpenShiftClient osClient, Map<String, String> env, String appHost, String appName, String matching, Map<String, String> extraEnv, boolean dryRun) throws Exception {
        writer.info("Deploying " + this.dbName);
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("deployment", this.dbName);
        ContainerPort port = new ContainerPort();
        port.setContainerPort(this.port);
        port.setProtocol("TCP");
        ArrayList<ContainerPort> ports = new ArrayList<ContainerPort>();
        ports.add(port);
        ArrayList<EnvVar> vars = new ArrayList<EnvVar>();
        for (Map.Entry<String, String> entry : this.CONNECTION_MAP.entrySet()) {
            String val = extraEnv.get(entry.getKey());
            vars.add(((EnvVarBuilder)((EnvVarBuilder)new EnvVar().toBuilder().withName(entry.getKey())).withValue(val == null ? entry.getValue() : val)).build());
        }
        Container container = new Container();
        container.setName(this.dbName);
        container.setImage(this.image);
        container.setPorts(ports);
        container.setEnv(vars);
        container.setImagePullPolicy("IfNotPresent");
        Deployment deployment = ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.StrategyNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(this.dbName)).endMetadata()).withNewSpec().withReplicas(1)).withNewSelector().withMatchLabels(labels)).endSelector()).withNewTemplate().withNewMetadata().withLabels(labels)).endMetadata()).withNewSpec().withContainers(container)).withRestartPolicy("Always")).endSpec()).endTemplate()).withNewStrategy().withType("RollingUpdate")).endStrategy()).endSpec()).build();
        if (!dryRun) {
            ((Resource)osClient.resources(Deployment.class).resource(deployment)).createOr(Updatable::update);
        }
        Utils.persistResource(OpenShiftSupport.getDeployersDirectory(target), deployment, this.dbName + "-deployment.yaml");
        IntOrString v = new IntOrString();
        v.setValue(this.port);
        Service service = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(this.dbName)).endMetadata()).withNewSpec().withPorts(((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePort().toBuilder().withName(this.port + "-tcp")).withProtocol("TCP")).withPort(this.port)).withTargetPort(v)).build())).withType("ClusterIP")).withSessionAffinity("None")).withSelector(labels)).endSpec()).build();
        if (!dryRun) {
            ((ServiceResource)osClient.services().resource(service)).createOr(Updatable::update);
        }
        Utils.persistResource(OpenShiftSupport.getDeployersDirectory(target), service, this.dbName + "-service.yaml");
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.putAll(this.getExistingEnv(env));
        ret.putAll(this.APP_MAP);
        if (dryRun) {
            writer.info("Resources for " + this.dbName + " have been generated");
        } else {
            writer.info(this.dbName + " server has been deployed");
        }
        return ret;
    }

    @Override
    public Set<String> getSupportedLayers() {
        HashSet<String> ret = new HashSet<String>();
        ret.add(this.dbName + "-datasource");
        ret.add(this.dbName + "-driver");
        return ret;
    }

    @Override
    public String getName() {
        return this.dbName;
    }

    @Override
    public Map<String, String> handleBuildTimeDefault(Set<String> buildEnv, MavenRepoManager mvnResolver) throws Exception {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String s : buildEnv) {
            String val = this.computeBuildTimeValue(s, mvnResolver);
            if (val == null) continue;
            map.put(s, val);
        }
        return map;
    }

    protected String computeBuildTimeValue(String name, MavenRepoManager mvnResolver) throws Exception {
        return null;
    }

    @Override
    public Set<Env> getResolvedEnvs(Set<Env> input) {
        HashSet<Env> envs = new HashSet<Env>();
        for (Env env : input) {
            if (this.APP_MAP.containsKey(env.getName())) {
                envs.add(env);
                continue;
            }
            if (!env.getName().startsWith(this.envRadical + "_")) continue;
            envs.add(env);
        }
        return envs;
    }
}

