/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.error;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wildfly.glow.AddOn;
import org.wildfly.glow.ContextLookupInfo;
import org.wildfly.glow.DataSourceDefinitionInfo;
import org.wildfly.glow.Env;
import org.wildfly.glow.Layer;
import org.wildfly.glow.LayerMapping;
import org.wildfly.glow.ResourceInjectionJndiInfo;
import org.wildfly.glow.error.DatasourceErrorIdentification;
import org.wildfly.glow.error.IdentifiedError;
import org.wildfly.glow.error.JndiErrorIdentification;

public class ErrorIdentificationSession {
    private final DatasourceErrorIdentification ds = new DatasourceErrorIdentification();
    private final JndiErrorIdentification jndiErrorIdentification = new JndiErrorIdentification();
    private final List<IdentifiedError> set = new ArrayList<IdentifiedError>();

    public void addError(IdentifiedError error) {
        this.set.add(error);
    }

    public void collectErrors(Path rootPath) throws Exception {
        this.ds.collectErrors(rootPath);
    }

    public void collectEndOfScanErrors(boolean verbose, Map<String, ResourceInjectionJndiInfo> resourceInjectionInfos, Set<ContextLookupInfo> initialContextLookupInfos, Map<String, DataSourceDefinitionInfo> datasourceDefinitionInfos, Set<String> allClasses) {
        this.jndiErrorIdentification.collectErrors(verbose, resourceInjectionInfos, initialContextLookupInfos, allClasses);
        this.ds.setDataSourceDefinitionInfos(datasourceDefinitionInfos);
    }

    public Map<Layer, Set<Env>> refreshErrors(Set<Layer> allBaseLayers, LayerMapping mapping, Set<AddOn> enabledAddOns) throws Exception {
        Map<Layer, Set<Env>> stronglySuggested = this.ds.refreshErrors(allBaseLayers);
        for (IdentifiedError error : this.getErrors()) {
            Set<AddOn> possibleFixingAddons;
            if (error.isFixed() || (possibleFixingAddons = mapping.getFixedByAddons().get(error.getId())) == null) continue;
            error.getPossibleAddons().addAll(possibleFixingAddons);
        }
        return stronglySuggested;
    }

    public List<IdentifiedError> getErrors() {
        ArrayList<IdentifiedError> ret = new ArrayList<IdentifiedError>();
        ret.addAll(this.set);
        ret.addAll(this.ds.getErrors());
        ret.addAll(this.jndiErrorIdentification.getErrors());
        return ret;
    }

    public boolean hasErrors() {
        for (IdentifiedError err : this.getErrors()) {
            if (err.isFixed()) continue;
            return true;
        }
        return false;
    }
}

