/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.error;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wildfly.glow.ContextLookupInfo;
import org.wildfly.glow.Layer;
import org.wildfly.glow.ResourceInjectionJndiInfo;
import org.wildfly.glow.Utils;
import org.wildfly.glow.error.AmbiguousResourceInjectionError;
import org.wildfly.glow.error.IdentifiedError;
import org.wildfly.glow.error.NamingContextLookupError;

public class JndiErrorIdentification {
    public static final String JNDI_LAYERS_ARGUMENT = "--add-layers-for-jndi";
    public static final String JNDI_LAYERS_ARGUMENT_EXPLANATION = "In the case some layers are missing, consider adding them manually with the --add-layers-for-jndi parameter.";
    public static final String AMBIGUOUS_RESOURCE_INJECTION = "ambiguous-resource-injection";
    public static final String AMBIGUOUS_RESOURCE_INJECTION_DESCRIPTION = "ambiguous resource injection";
    private static final String AMBIGUOUS_RESOURCE_INJECTION_SUGGESTION = "A @Resource annotation is weakly typed and can not be used to identify a class from the deployment or from a layer. In the case some layers are missing, consider adding them manually with the --add-layers-for-jndi parameter. Alternatively, refactor your application to make them strongly typed";
    public static final String NAMING_CONTEXT_LOOKUP = "naming-context-lookup";
    public static final String NAMING_CONTEXT_LOOKUP_DESCRIPTION = "jakarta.naming.Context or InitialContext lookup";
    private static final String CONTEXT_LOOKUP_SUGGESTION = "A jakarta.naming.Context.lookup() call was detected. This can not be used to identify a class from the deployment or from a layer. In the case some layers are missing, consider adding them manually with the --add-layers-for-jndi parameter.";
    static final String ENABLE_VERBOSE = "Enable verbose output to see the locations.";
    private Map<String, Set<IdentifiedError>> errors = new HashMap<String, Set<IdentifiedError>>();

    public void collectErrors(boolean verbose, Map<String, ResourceInjectionJndiInfo> resourceInjectionInfos, Set<ContextLookupInfo> initialContextLookupInfos, Set<String> allClasses) {
        Set errorSet;
        for (String resourceInjectionType : resourceInjectionInfos.keySet()) {
            errorSet = this.errors.computeIfAbsent(AMBIGUOUS_RESOURCE_INJECTION, s -> new HashSet());
            ResourceInjectionJndiInfo info = resourceInjectionInfos.get(resourceInjectionType);
            Set<Layer> resourceInjectionTypeLayers = info.getLayers();
            if (!resourceInjectionTypeLayers.isEmpty() && !Utils.layersAreBanned(resourceInjectionTypeLayers) && !info.getResourceClassName().equals("javax.naming.Context") || allClasses.contains(resourceInjectionType)) continue;
            errorSet.add(AmbiguousResourceInjectionError.create(verbose, AMBIGUOUS_RESOURCE_INJECTION, AMBIGUOUS_RESOURCE_INJECTION_DESCRIPTION, info));
        }
        for (ContextLookupInfo contextLookupInfo : initialContextLookupInfos) {
            errorSet = this.errors.computeIfAbsent(NAMING_CONTEXT_LOOKUP, s -> new HashSet());
            errorSet.add(NamingContextLookupError.create(verbose, NAMING_CONTEXT_LOOKUP, NAMING_CONTEXT_LOOKUP_DESCRIPTION, contextLookupInfo));
        }
    }

    List<IdentifiedError> getErrors() {
        ArrayList<IdentifiedError> ret = new ArrayList<IdentifiedError>();
        for (Set<IdentifiedError> err : this.errors.values()) {
            ret.addAll(err);
        }
        return ret;
    }
}

