/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.logging.Logger;

class ReusableInputStream
extends InputStream {
    private static final Logger LOGGER = Logger.getLogger(ReusableInputStream.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final String name;
    private final Path content;
    private final Thread shutdownHook;
    private boolean closed;
    private InputStream delegate;

    ReusableInputStream(InputStream content, String name) {
        this.name = name;
        this.content = ReusableInputStream.createContent(content, name);
        this.shutdownHook = new Thread(new Thread(() -> {
            try {
                Files.deleteIfExists(this.content);
            }
            catch (IOException e) {
                LOGGER.errorf((Throwable)e, "Failed to content file delete file %s for deployment %s.", (Object)this.content, (Object)name);
            }
        }));
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.closed = false;
    }

    @Override
    public int read() throws IOException {
        return this.getDelegate().read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.getDelegate().read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.getDelegate().read(b, off, len);
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        return this.getDelegate().readAllBytes();
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        return this.getDelegate().readNBytes(len);
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        return this.getDelegate().readNBytes(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.getDelegate().skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.getDelegate().available();
    }

    @Override
    public void close() {
        this.close(false);
    }

    @Override
    public void mark(int readlimit) {
        try {
            this.getDelegate().mark(readlimit);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create the delegate.", e);
        }
    }

    @Override
    public void reset() {
        this.close(false);
    }

    @Override
    public boolean markSupported() {
        try {
            return this.getDelegate().markSupported();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create the delegate.", e);
        }
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        return this.getDelegate().transferTo(out);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ReusableInputStream)) {
            return false;
        }
        ReusableInputStream other = (ReusableInputStream)obj;
        return Objects.equals(this.name, other.name);
    }

    public String toString() {
        return "ReusableInputStream[" + this.name + "]";
    }

    void close(boolean deleteContent) {
        this.lock.lock();
        try {
            if (this.delegate != null) {
                this.delegate.close();
                this.delegate = null;
            }
            if (deleteContent) {
                this.closed = true;
                Files.deleteIfExists(this.content);
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close delegate stream.", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private InputStream getDelegate() throws IOException {
        this.lock.lock();
        try {
            if (this.closed) {
                throw new IllegalStateException("This stream has been closed and can no longer be read from.");
            }
            if (this.delegate == null) {
                this.delegate = Files.newInputStream(this.content, new OpenOption[0]);
            }
            InputStream inputStream = this.delegate;
            return inputStream;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static Path createContent(InputStream content, String name) {
        Path path;
        block8: {
            InputStream inputStream = content;
            try {
                Path file = Files.createTempFile("deployment-", "-" + name, new FileAttribute[0]);
                Files.copy(content, file, StandardCopyOption.REPLACE_EXISTING);
                path = file;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to copy the content " + String.valueOf(content), e);
                }
            }
            inputStream.close();
        }
        return path;
    }
}

