/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools.server;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.wildfly.plugin.tools.ConsoleConsumer;
import org.wildfly.plugin.tools.ContainerDescription;
import org.wildfly.plugin.tools.DeploymentManager;
import org.wildfly.plugin.tools.OperationExecutionException;
import org.wildfly.plugin.tools.server.CommonOperations;
import org.wildfly.plugin.tools.server.Configuration;
import org.wildfly.plugin.tools.server.DomainConfiguration;
import org.wildfly.plugin.tools.server.DomainManager;
import org.wildfly.plugin.tools.server.ManagedServerManager;
import org.wildfly.plugin.tools.server.ServerManagerException;
import org.wildfly.plugin.tools.server.StandaloneConfiguration;
import org.wildfly.plugin.tools.server.StandaloneManager;

public interface ServerManager
extends AutoCloseable {
    public static Builder builder() {
        return new Builder();
    }

    public static Optional<ProcessHandle> findProcess() {
        return ProcessHandle.allProcesses().filter(p -> {
            ProcessHandle.Info info = p.info();
            boolean found = false;
            if (info.arguments().isPresent()) {
                String[] arguments = info.arguments().get();
                for (int i = 0; i < arguments.length; ++i) {
                    String arg = arguments[i];
                    if (!found && arg.trim().equalsIgnoreCase("-jar")) {
                        found = arguments[++i].contains("jboss-modules.jar");
                        continue;
                    }
                    if ((!found || !"org.jboss.as.process-controller".equals(arg)) && !"org.jboss.as.standalone".equals(arg)) continue;
                    return true;
                }
            }
            return false;
        }).findFirst();
    }

    public static boolean isValidHomeDirectory(Path path) {
        return path != null && Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]) && Files.exists(path.resolve("jboss-modules.jar"), new LinkOption[0]);
    }

    public static boolean isValidHomeDirectory(String path) {
        return path != null && ServerManager.isValidHomeDirectory(Path.of(path, new String[0]));
    }

    public static boolean isRunning(ModelControllerClient client) {
        return ServerManager.launchType(client).map(launchType -> {
            try {
                if ("STANDALONE".equals(launchType)) {
                    return CommonOperations.isStandaloneRunning(client);
                }
                if ("DOMAIN".equals(launchType)) {
                    return CommonOperations.isDomainRunning(client, false);
                }
            }
            catch (RuntimeException e) {
                Logger.getLogger(ServerManager.class).trace((Object)"Interrupted determining if server is running", e);
            }
            return false;
        }).orElse(false);
    }

    public static Optional<String> launchType(ModelControllerClient client) {
        try {
            ModelNode response = client.execute(Operations.createReadAttributeOperation((ModelNode)new ModelNode().setEmptyList(), (String)"launch-type"));
            return Operations.isSuccessfulOutcome((ModelNode)response) ? Optional.of(Operations.readResult((ModelNode)response).asString()) : Optional.empty();
        }
        catch (IOException | RuntimeException exception) {
            return Optional.empty();
        }
    }

    public static StandaloneManager start(StandaloneConfiguration configuration) throws ServerManagerException {
        Process process = null;
        try {
            process = configuration.launcher().launch();
            if (configuration.consumeStderr()) {
                ConsoleConsumer.start(process.getErrorStream(), (OutputStream)System.err);
            }
            if (configuration.consumeStdout()) {
                ConsoleConsumer.start(process.getInputStream(), (OutputStream)System.out);
            }
            return new Builder(configuration).process(process).standalone();
        }
        catch (Throwable t) {
            if (process != null) {
                process.destroyForcibly();
            }
            throw ServerManagerException.startException(configuration, t);
        }
    }

    public static DomainManager start(DomainConfiguration configuration) throws ServerManagerException {
        Process process = null;
        try {
            process = configuration.launcher().launch();
            if (configuration.consumeStderr()) {
                ConsoleConsumer.start(process.getErrorStream(), (OutputStream)System.err);
            }
            if (configuration.consumeStdout()) {
                ConsoleConsumer.start(process.getInputStream(), (OutputStream)System.out);
            }
            return new Builder(configuration).process(process).domain();
        }
        catch (Throwable t) {
            if (process != null) {
                process.destroyForcibly();
            }
            throw ServerManagerException.startException(configuration, t);
        }
    }

    public ModelControllerClient client();

    public String serverState();

    public String launchType();

    public String takeSnapshot() throws IOException;

    public ContainerDescription containerDescription() throws IOException;

    public DeploymentManager deploymentManager();

    public boolean isRunning();

    default public CompletableFuture<ServerManager> kill() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    default public boolean waitFor(long startupTimeout) throws InterruptedException {
        return this.waitFor(startupTimeout, TimeUnit.SECONDS);
    }

    public boolean waitFor(long var1, TimeUnit var3) throws InterruptedException;

    default public void shutdown() throws IOException {
        this.shutdown(0L);
    }

    public void shutdown(long var1) throws IOException;

    default public CompletableFuture<ServerManager> shutdownAsync() {
        return this.shutdownAsync(0L);
    }

    default public CompletableFuture<ServerManager> shutdownAsync(long timeout) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.shutdown(timeout);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
            return this;
        });
    }

    public void executeReload() throws IOException;

    public void executeReload(ModelNode var1) throws IOException;

    public void reloadIfRequired() throws IOException;

    public void reloadIfRequired(long var1, TimeUnit var3) throws IOException;

    default public ModelNode executeOperation(ModelNode op) throws IOException, OperationExecutionException {
        return this.executeOperation(Operation.Factory.create((ModelNode)op));
    }

    default public ModelNode executeOperation(Operation op) throws IOException, OperationExecutionException {
        ModelNode result = this.client().execute(op);
        if (Operations.isSuccessfulOutcome((ModelNode)result)) {
            return Operations.readResult((ModelNode)result);
        }
        throw new OperationExecutionException(op, result);
    }

    default public boolean isClosed() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    default public void close() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    default public ServerManager asManaged() {
        return new ManagedServerManager(this);
    }

    public static class Builder {
        private final Configuration<?> configuration;
        private ProcessHandle process;

        public Builder() {
            this(new StandaloneConfiguration(null));
        }

        protected Builder(Configuration<?> configuration) {
            this.configuration = configuration;
        }

        public Builder client(ModelControllerClient client) {
            this.configuration.client(client);
            return this;
        }

        public Builder process(ProcessHandle process) {
            this.process = process;
            return this;
        }

        public Builder process(Process process) {
            this.process = process == null ? null : process.toHandle();
            return this;
        }

        public Builder managementAddress(String managementAddress) {
            this.configuration.managementAddress(managementAddress);
            return this;
        }

        public Builder managementPort(int managementPort) {
            this.configuration.managementPort(managementPort);
            return this;
        }

        public Builder shutdownOnClose(boolean shutdownOnClose) {
            this.configuration.shutdownOnClose(shutdownOnClose);
            return this;
        }

        public StandaloneManager standalone() {
            return new StandaloneManager(this.process, this.configuration.client(), this.configuration.shutdownOnClose());
        }

        public DomainManager domain() {
            return new DomainManager(this.process, this.getOrCreateDomainClient(), this.configuration.shutdownOnClose());
        }

        public CompletableFuture<ServerManager> build() {
            ModelControllerClient client = this.configuration.client();
            ProcessHandle process = this.process;
            return CompletableFuture.supplyAsync(() -> {
                while (!ServerManager.isRunning(client)) {
                    Thread.onSpinWait();
                    if (process == null || process.isAlive()) continue;
                    throw new ServerManagerException("The server process has died. See previous output from the process. Process id " + process.pid());
                }
                String launchType = ServerManager.launchType(client).orElseThrow(() -> new ServerManagerException("Could not determine the type of the server. Verify the server is running."));
                if ("STANDALONE".equals(launchType)) {
                    return new StandaloneManager(process, client, this.configuration.shutdownOnClose());
                }
                if ("DOMAIN".equals(launchType)) {
                    return new DomainManager(process, this.getOrCreateDomainClient(), this.configuration.shutdownOnClose());
                }
                throw new ServerManagerException("Only standalone and domain servers are support. %s is not supported.", launchType);
            });
        }

        private DomainClient getOrCreateDomainClient() {
            ModelControllerClient client = this.configuration.client();
            return client instanceof DomainClient ? (DomainClient)client : DomainClient.Factory.create((ModelControllerClient)client);
        }
    }
}

