/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.clustering.naming.BinderServiceBuilder;
import org.jboss.as.clustering.naming.JndiNameFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.server.group.CacheGroupService;
import org.wildfly.clustering.spi.CacheServiceNames;
import org.wildfly.clustering.spi.ClusterServiceInstaller;

public class CacheGroupServiceInstaller
implements ClusterServiceInstaller {
    private final Logger logger = Logger.getLogger(this.getClass());

    private static ContextNames.BindInfo createBinding(String group) {
        return ContextNames.bindInfoFor((String)JndiNameFactory.createJndiName((String)"java:jboss", (String[])new String[]{"clustering", "group", group, "default"}).getAbsoluteName());
    }

    public Collection<ServiceName> getServiceNames(String group) {
        return Arrays.asList(CacheServiceNames.GROUP.getServiceName(group), CacheGroupServiceInstaller.createBinding(group).getBinderServiceName());
    }

    public Collection<ServiceController<?>> install(ServiceTarget target, String group, ModuleIdentifier moduleId) {
        ServiceName name = CacheServiceNames.GROUP.getServiceName(group);
        ContextNames.BindInfo bindInfo = CacheGroupServiceInstaller.createBinding(group);
        this.logger.debugf("Installing %s service, bound to ", (Object)name.getCanonicalName(), (Object)bindInfo.getAbsoluteJndiName());
        ServiceBuilder<Group> builder = CacheGroupService.build(target, name, group, "default");
        ServiceController controller = builder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        ServiceBuilder binderBuilder = new BinderServiceBuilder(target).build(bindInfo, name, Group.class);
        return Arrays.asList(controller, binderBuilder.install());
    }
}

