/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.group.ChannelGroupConfiguration;
import org.wildfly.clustering.server.group.ChannelNodeFactory;

@Listener(sync=false)
public class ChannelGroup
implements Group,
AutoCloseable {
    private final List<Group.Listener> listeners = new CopyOnWriteArrayList<Group.Listener>();
    private final EmbeddedCacheManager manager;
    private final ChannelNodeFactory factory;

    public ChannelGroup(ChannelGroupConfiguration config) {
        this.manager = config.getCacheContainer();
        this.factory = config.getNodeFactory();
        this.manager.addListener((Object)this);
    }

    @Override
    public void close() {
        this.manager.removeListener((Object)this);
    }

    public String getName() {
        return this.manager.getClusterName();
    }

    public boolean isCoordinator() {
        return this.manager.isCoordinator();
    }

    public Node getLocalNode() {
        return this.factory.createNode(ChannelGroup.toJGroupsAddress(this.manager.getAddress()));
    }

    public Node getCoordinatorNode() {
        return this.factory.createNode(ChannelGroup.toJGroupsAddress(this.manager.getCoordinator()));
    }

    public List<Node> getNodes() {
        List addresses = this.manager.getMembers();
        ArrayList<Node> nodes = new ArrayList<Node>(addresses.size());
        for (Address address : addresses) {
            nodes.add(this.factory.createNode(ChannelGroup.toJGroupsAddress(address)));
        }
        return nodes;
    }

    @ViewChanged
    public void viewChanged(ViewChangedEvent event) {
        List oldAddresses = event.getOldMembers();
        List<Node> oldNodes = this.getNodes(oldAddresses);
        List newAddresses = event.getNewMembers();
        List<Node> newNodes = this.getNodes(newAddresses);
        HashSet members = new HashSet(newAddresses);
        ArrayList<org.jgroups.Address> obsolete = new ArrayList<org.jgroups.Address>(oldAddresses.size());
        for (Address address : oldAddresses) {
            if (members.contains(address)) continue;
            obsolete.add(ChannelGroup.toJGroupsAddress(address));
        }
        this.factory.invalidate(obsolete);
        for (Group.Listener listener : this.listeners) {
            listener.membershipChanged(oldNodes, newNodes, false);
        }
    }

    public void addListener(Group.Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Group.Listener listener) {
        this.listeners.remove(listener);
    }

    private List<Node> getNodes(List<Address> addresses) {
        ArrayList<Node> nodes = new ArrayList<Node>(addresses.size());
        for (Address address : addresses) {
            nodes.add(this.factory.createNode(ChannelGroup.toJGroupsAddress(address)));
        }
        return nodes;
    }

    private static org.jgroups.Address toJGroupsAddress(Address address) {
        if (address instanceof JGroupsAddress) {
            JGroupsAddress jgroupsAddress = (JGroupsAddress)address;
            return jgroupsAddress.getJGroupsAddress();
        }
        throw new IllegalArgumentException(address.toString());
    }
}

