/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.provider;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.clustering.naming.BinderServiceBuilder;
import org.jboss.as.clustering.naming.JndiNameFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.provider.ServiceProviderRegistrationFactory;
import org.wildfly.clustering.spi.CacheServiceNames;
import org.wildfly.clustering.spi.ServiceInstaller;

public abstract class AbstractServiceProviderRegistrationFactoryServiceInstaller
implements ServiceInstaller {
    private final Logger logger = Logger.getLogger(this.getClass());

    private static ContextNames.BindInfo createBinding(String group) {
        return ContextNames.bindInfoFor((String)JndiNameFactory.createJndiName((String)"java:jboss", (String[])new String[]{"clustering", "providers", group, "default"}).getAbsoluteName());
    }

    public Collection<ServiceName> getServiceNames(String group) {
        return Arrays.asList(CacheServiceNames.SERVICE_PROVIDER_REGISTRATION.getServiceName(group), AbstractServiceProviderRegistrationFactoryServiceInstaller.createBinding(group).getBinderServiceName());
    }

    public Collection<ServiceController<?>> install(ServiceTarget target, String group, ModuleIdentifier moduleId) {
        ServiceName name = CacheServiceNames.SERVICE_PROVIDER_REGISTRATION.getServiceName(group);
        ContextNames.BindInfo bindInfo = AbstractServiceProviderRegistrationFactoryServiceInstaller.createBinding(group);
        this.logger.debugf("Installing %s service, bound to ", (Object)name.getCanonicalName(), (Object)bindInfo.getAbsoluteJndiName());
        ServiceBuilder<ServiceProviderRegistrationFactory> builder = this.build(target, name, group, "default");
        ServiceController controller = builder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        ServiceBuilder binderBuilder = new BinderServiceBuilder(target).build(bindInfo, name, ServiceProviderRegistrationFactory.class);
        return Arrays.asList(controller, binderBuilder.install());
    }

    protected abstract ServiceBuilder<ServiceProviderRegistrationFactory> build(ServiceTarget var1, ServiceName var2, String var3, String var4);
}

