/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.CDIProvider;
import org.jboss.as.weld.deployment.WeldDeployment;
import org.jboss.as.weld.util.Reflections;
import org.jboss.weld.AbstractCDI;
import org.jboss.weld.Container;
import org.jboss.weld.ContainerState;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WeldProvider
implements CDIProvider {
    private static final ConcurrentMap<Container, CdiImpl> containers = new ConcurrentHashMap<Container, CdiImpl>();

    static void containerInitialized(Container container, BeanManagerImpl rootBeanManager, WeldDeployment deployment) {
        containers.put(container, new CdiImpl(container, new BeanManagerProxy(rootBeanManager), deployment));
    }

    static void containerShutDown(Container container) {
        containers.remove(container);
    }

    public CDI<Object> getCDI() {
        Container container = Container.instance();
        WeldProvider.checkContainerState(container);
        return (CDI)containers.get(container);
    }

    private static void checkContainerState(Container container) {
        ContainerState state = container.getState();
        if (state.equals((Object)ContainerState.STOPPED) || state.equals((Object)ContainerState.SHUTDOWN)) {
            throw BeanManagerLogger.LOG.beanManagerNotAvailable();
        }
    }

    private static class CdiImpl
    extends AbstractCDI<Object> {
        private final Container container;
        private final BeanManagerProxy rootBeanManager;
        private final WeldDeployment deployment;

        public CdiImpl(Container container, BeanManagerProxy rootBeanManager, WeldDeployment deployment) {
            this.container = container;
            this.rootBeanManager = rootBeanManager;
            this.deployment = deployment;
        }

        public BeanManagerProxy getBeanManager() {
            BeanDeploymentArchive bda;
            WeldProvider.checkContainerState(this.container);
            String callerName = this.getCallingClassName();
            ClassLoader tccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            Class callerClass = Reflections.loadClass((String)callerName, (ClassLoader)tccl);
            if (callerClass != null && (bda = this.deployment.getBeanDeploymentArchive(callerClass)) != null) {
                return new BeanManagerProxy((BeanManagerImpl)this.container.beanDeploymentArchives().get(bda));
            }
            return this.rootBeanManager;
        }

        public String toString() {
            return "Weld instance for deployment " + BeanManagerProxy.unwrap((BeanManager)this.rootBeanManager).getContextId();
        }
    }
}

