/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.AttributeTranslation;
import org.jboss.as.clustering.controller.AttributeValueTranslator;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;

public class WriteAttributeTranslationHandler
implements OperationStepHandler {
    private final Attribute targetAttribute;
    private final AttributeValueTranslator translator;

    public WriteAttributeTranslationHandler(AttributeTranslation translation) {
        this(translation.getTargetAttribute(), translation.getWriteTranslator());
    }

    public WriteAttributeTranslationHandler(Attribute targetAttribute, AttributeValueTranslator translator) {
        this.targetAttribute = targetAttribute;
        this.translator = translator;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode value = context.resolveExpressions(Operations.getAttributeValue(operation));
        ModelNode targetValue = this.translator.translate(context, value);
        ModelNode targetOperation = Operations.createWriteAttributeOperation(context.getCurrentAddress(), this.targetAttribute, targetValue);
        context.getResourceRegistration().getAttributeAccess(PathAddress.EMPTY_ADDRESS, this.targetAttribute.getName()).getWriteHandler().execute(context, targetOperation);
    }
}

