/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import org.glassfish.enterprise.concurrent.spi.TransactionSetupProvider;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ee.concurrent.DefaultContextSetupProviderImpl;
import org.jboss.as.ee.concurrent.service.ConcurrentServiceNames;
import org.jboss.as.ee.concurrent.service.ContextServiceService;
import org.jboss.as.ee.subsystem.ContextServiceResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class ContextServiceAdd
extends AbstractAddStepHandler {
    static final ContextServiceAdd INSTANCE = new ContextServiceAdd();

    private ContextServiceAdd() {
        super((AttributeDefinition[])ContextServiceResourceDefinition.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        String name = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        String jndiName = ContextServiceResourceDefinition.JNDI_NAME_AD.resolveModelAttribute(context, model).asString();
        boolean useTransactionSetupProvider = ContextServiceResourceDefinition.USE_TRANSACTION_SETUP_PROVIDER_AD.resolveModelAttribute(context, model).asBoolean();
        ContextServiceService contextServiceService = new ContextServiceService(name, jndiName);
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(ConcurrentServiceNames.getContextServiceServiceName(name), (Service)contextServiceService).addInjectionValue(contextServiceService.getContextSetupProvider(), (Value)new ImmediateValue((Object)new DefaultContextSetupProviderImpl()));
        if (useTransactionSetupProvider) {
            serviceBuilder.addDependency(ConcurrentServiceNames.TRANSACTION_SETUP_PROVIDER_SERVICE_NAME, TransactionSetupProvider.class, contextServiceService.getTransactionSetupProvider());
        }
        serviceBuilder.install();
    }
}

