/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.ntlm.encoding;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jboss.security.negotiation.ntlm.Constants;
import org.jboss.security.negotiation.ntlm.encoding.DecoderData;
import org.jboss.security.negotiation.ntlm.encoding.FieldDecoder;
import org.jboss.security.negotiation.ntlm.encoding.NTLMField;
import org.jboss.security.negotiation.ntlm.encoding.NegotiateFlagsDecoder;
import org.jboss.security.negotiation.ntlm.encoding.NegotiateMessage;

public class NegotiateMessageDecoder {
    private static void readVerifySignature(InputStream is, DecoderData data) throws IOException {
        byte[] expected = Constants.SIGNATURE;
        byte[] dataRead = new byte[expected.length];
        is.read(dataRead);
        if (!Arrays.equals(expected, dataRead)) {
            throw new IOException("Invalid signature, expected '" + new String(expected) + "' actual '" + new String(dataRead) + "'");
        }
        data.read += dataRead.length;
    }

    private static void readVerifyMessageType(InputStream is, DecoderData data) throws IOException {
        byte[] expected = Constants.NEGOTIATE_MESSAGE_TYPE;
        byte[] dataRead = new byte[expected.length];
        is.read(dataRead);
        if (!Arrays.equals(expected, dataRead)) {
            throw new IOException("Invalid MessageType, expected '" + new String(expected) + "' actual '" + new String(dataRead) + "'");
        }
        data.read += dataRead.length;
    }

    private static void readVersion(InputStream is, DecoderData data) throws IOException {
        byte[] version = data.message.getNegotiateFlags().isNegotiateVersion() ? new byte[8] : new byte[]{};
        is.read(version);
        data.read += version.length;
        data.message.setVersion(version);
    }

    private static String readPayloadValue(InputStream is, DecoderData data, NTLMField field) throws IOException {
        byte[] dataRead = new byte[field.getLength()];
        int bytesRead = data.read;
        int offset = field.getOffset();
        if (bytesRead < offset) {
            int toSkip = offset - bytesRead;
            is.skip(toSkip);
            data.read += toSkip;
        } else if (bytesRead > offset) {
            throw new IllegalStateException("Read beyond offset.");
        }
        is.read(dataRead);
        data.read += dataRead.length;
        return new String(dataRead);
    }

    private static void readPayload(InputStream is, DecoderData data) throws IOException {
        NegotiateMessage message = data.message;
        NTLMField domainFields = message.getDomainNameFields();
        NTLMField workstationFields = message.getWorkstationFields();
        boolean readDomainName = domainFields.getLength() > 0;
        boolean readWSName = workstationFields.getLength() > 0;
        String domainName = "";
        String workstationName = "";
        if (readWSName && readDomainName) {
            int domainOffset;
            int wsOffset = workstationFields.getOffset();
            if (wsOffset < (domainOffset = domainFields.getOffset())) {
                workstationName = NegotiateMessageDecoder.readPayloadValue(is, data, workstationFields);
                domainName = NegotiateMessageDecoder.readPayloadValue(is, data, domainFields);
            } else {
                domainName = NegotiateMessageDecoder.readPayloadValue(is, data, domainFields);
                workstationName = NegotiateMessageDecoder.readPayloadValue(is, data, workstationFields);
            }
            message.setDomainName(domainName);
            message.setWorkstationName(workstationName);
        } else if (readWSName) {
            workstationName = NegotiateMessageDecoder.readPayloadValue(is, data, workstationFields);
        } else if (readDomainName) {
            domainName = NegotiateMessageDecoder.readPayloadValue(is, data, domainFields);
        }
    }

    public static NegotiateMessage decode(InputStream is) throws IOException {
        DecoderData data = new DecoderData();
        NegotiateMessageDecoder.readVerifySignature(is, data);
        NegotiateMessageDecoder.readVerifyMessageType(is, data);
        NegotiateFlagsDecoder.readNegotiateFlags(is, data);
        data.message.setDomainNameFields(FieldDecoder.readFieldLengths(is, data));
        data.message.setWorkstationFields(FieldDecoder.readFieldLengths(is, data));
        NegotiateMessageDecoder.readVersion(is, data);
        NegotiateMessageDecoder.readPayload(is, data);
        return data.message;
    }

    public static NegotiateMessage decode(byte[] token) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(token);
        return NegotiateMessageDecoder.decode(bais);
    }
}

