/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.addons.transports.undertow;

import io.undertow.server.HttpHandler;
import java.net.InetSocketAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.jboss.ws.undertow_httpspi.PathUtils;
import org.jboss.ws.undertow_httpspi.UndertowServer;
import org.jboss.wsf.stack.cxf.addons.transports.undertow.UndertowServerEngineFactory;

public class UndertowServerEngine {
    private static final RuntimePermission START_UNDERTOW_SERVER_ENGINE = new RuntimePermission("org.jboss.ws.START_UNDERTOW_SERVER_ENGINE");
    private static final Logger LOG = LogUtils.getL7dLogger(UndertowServerEngine.class);
    private Bus bus;
    private UndertowServerEngineFactory factory;
    private String host;
    private int port;
    private int handlerCount;
    private String protocol = "http";
    private UndertowServer server;

    public UndertowServerEngine(UndertowServerEngineFactory fac, Bus bus, String host, int port) {
        this.bus = bus;
        this.factory = fac;
        this.host = host;
        this.port = port;
    }

    public synchronized Bus getBus() {
        return this.bus;
    }

    public synchronized String getProtocol() {
        return this.protocol;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public synchronized String getHost() {
        return this.host;
    }

    public synchronized void addHandler(String address, HttpHandler handler) {
        if (this.server == null) {
            InetSocketAddress isa = this.host != null ? new InetSocketAddress(this.host, this.port) : new InetSocketAddress(this.port);
            this.server = new UndertowServer(isa.getPort(), isa.getHostName());
            this.server.getPathHandler().addExactPath(PathUtils.getContextPath((String)address) + PathUtils.getPath((String)address), handler);
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                this.server.start();
            } else {
                sm.checkPermission(START_UNDERTOW_SERVER_ENGINE);
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        UndertowServerEngine.this.server.start();
                        return null;
                    }
                });
            }
        }
        this.server.getPathHandler().addExactPath(PathUtils.getContextPath((String)address) + PathUtils.getPath((String)address), handler);
        ++this.handlerCount;
    }

    public synchronized void removeHandler(String address) {
        this.server.getPathHandler().removeExactPath(PathUtils.getContextPath((String)address) + PathUtils.getPath((String)address));
        --this.handlerCount;
    }

    protected synchronized void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public synchronized void shutdown() {
        if (this.factory != null && this.handlerCount == 0) {
            this.factory.destroyForPort(this.port);
        } else {
            LOG.log(Level.WARNING, "FAILED_TO_SHUTDOWN_ENGINE_MSG", this.port);
        }
    }
}

