/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.security.PrivilegedAction;
import org.jgroups.util.ThreadFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ClassLoaderThreadFactory
implements ThreadFactory {
    private final ThreadFactory factory;
    private final ClassLoader loader;

    public ClassLoaderThreadFactory(ThreadFactory factory, ClassLoader loader) {
        this.factory = factory;
        this.loader = loader;
    }

    public Thread newThread(Runnable r) {
        return this.newThread(r, null);
    }

    public Thread newThread(Runnable r, String name) {
        Runnable task = () -> {
            try {
                r.run();
            }
            finally {
                this.setContextClassLoader(Thread.currentThread());
            }
        };
        return this.setContextClassLoader(this.factory.newThread(task, name));
    }

    private Thread setContextClassLoader(Thread thread) {
        PrivilegedAction<Thread> action = () -> {
            thread.setContextClassLoader(this.loader);
            return thread;
        };
        return (Thread)WildFlySecurityManager.doUnchecked(action);
    }

    public void setPattern(String pattern) {
        this.factory.setPattern(pattern);
    }

    public void setIncludeClusterName(boolean includeClusterName) {
        this.factory.setIncludeClusterName(includeClusterName);
    }

    public void setClusterName(String channelName) {
        this.factory.setClusterName(channelName);
    }

    public void setAddress(String address) {
        this.factory.setAddress(address);
    }

    public void renameThread(String base_name, Thread thread) {
        this.factory.renameThread(base_name, thread);
    }
}

