/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.iteration;

import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.RemoteIllegalLifecycleStateException;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.iteration.KeyTracker;
import org.infinispan.client.hotrod.impl.iteration.KeyTrackerFactory;
import org.infinispan.client.hotrod.impl.operations.IterationEndResponse;
import org.infinispan.client.hotrod.impl.operations.IterationNextOperation;
import org.infinispan.client.hotrod.impl.operations.IterationNextResponse;
import org.infinispan.client.hotrod.impl.operations.IterationStartOperation;
import org.infinispan.client.hotrod.impl.operations.IterationStartResponse;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.CloseableIterator;

@NotThreadSafe
public class RemoteCloseableIterator<E>
implements CloseableIterator<Map.Entry<Object, E>> {
    private static final Log log = LogFactory.getLog(RemoteCloseableIterator.class);
    private final OperationsFactory operationsFactory;
    private final String filterConverterFactory;
    private final byte[][] filterParams;
    private final Set<Integer> segments;
    private final int batchSize;
    private final boolean metadata;
    private KeyTracker segmentKeyTracker;
    private Transport transport;
    private String iterationId;
    private boolean endOfIteration = false;
    private boolean closed;
    private Queue<Map.Entry<Object, E>> nextElements = new LinkedList<Map.Entry<Object, E>>();

    public RemoteCloseableIterator(OperationsFactory operationsFactory, String filterConverterFactory, byte[][] filterParams, Set<Integer> segments, int batchSize, boolean metadata) {
        this.filterConverterFactory = filterConverterFactory;
        this.filterParams = filterParams;
        this.segments = segments;
        this.batchSize = batchSize;
        this.operationsFactory = operationsFactory;
        this.metadata = metadata;
    }

    public RemoteCloseableIterator(OperationsFactory operationsFactory, int batchSize, Set<Integer> segments, boolean metadata) {
        this(operationsFactory, null, null, segments, batchSize, metadata);
    }

    public void close() {
        if (!this.closed) {
            try {
                IterationEndResponse endResponse = this.operationsFactory.newIterationEndOperation(this.iterationId, this.transport).execute();
                short status = endResponse.getStatus();
                if (HotRodConstants.isSuccess(status)) {
                    log.iterationClosed(this.iterationId);
                }
                if (HotRodConstants.isInvalidIteration(status)) {
                    throw log.errorClosingIteration(this.iterationId);
                }
            }
            catch (HotRodClientException e) {
                log.ignoringErrorDuringIterationClose(this.iterationId, e);
            }
            finally {
                this.closed = true;
            }
        }
    }

    public boolean hasNext() {
        if (!this.endOfIteration && this.nextElements.isEmpty()) {
            this.fetch();
        }
        return !this.endOfIteration;
    }

    public Map.Entry<Object, E> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.nextElements.remove();
    }

    private void fetch() {
        try {
            IterationNextOperation iterationNextOperation = this.operationsFactory.newIterationNextOperation(this.iterationId, this.transport, this.segmentKeyTracker);
            while (this.nextElements.isEmpty() && !this.endOfIteration) {
                Object iterationNextResponse = iterationNextOperation.execute();
                if (!((IterationNextResponse)iterationNextResponse).hasMore()) {
                    this.endOfIteration = true;
                    this.close();
                    break;
                }
                this.nextElements.addAll(((IterationNextResponse)iterationNextResponse).getEntries());
            }
        }
        catch (RemoteIllegalLifecycleStateException | TransportException e) {
            log.warnf(e, "Error reaching the server during iteration", new Object[0]);
            this.startInternal(this.segmentKeyTracker.missedSegments());
            this.fetch();
        }
    }

    private IterationStartResponse startInternal(Set<Integer> segments) {
        if (log.isDebugEnabled()) {
            log.debugf("Starting iteration with segments %s", segments);
        }
        IterationStartOperation iterationStartOperation = this.operationsFactory.newIterationStartOperation(this.filterConverterFactory, this.filterParams, segments, this.batchSize, this.metadata);
        IterationStartResponse startResponse = (IterationStartResponse)iterationStartOperation.execute();
        this.transport = startResponse.getTransport();
        if (log.isDebugEnabled()) {
            log.iterationTransportObtained(this.transport, this.iterationId);
        }
        this.iterationId = startResponse.getIterationId();
        if (log.isDebugEnabled()) {
            log.startedIteration(this.iterationId);
        }
        return startResponse;
    }

    public void start() {
        IterationStartResponse startResponse = this.startInternal(this.segments);
        Marshaller marshaller = startResponse.getTransport().getTransportFactory().getMarshaller();
        this.segmentKeyTracker = KeyTrackerFactory.create(marshaller, startResponse.getSegmentConsistentHash(), startResponse.getTopologyId(), this.segments);
    }
}

