/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso;

import org.infinispan.Cache;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.InfinispanRequirement;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.spi.service.CacheBuilder;
import org.wildfly.clustering.infinispan.spi.service.TemplateConfigurationBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.web.infinispan.sso.InfinispanSSOManagerFactory;
import org.wildfly.clustering.web.infinispan.sso.InfinispanSSOManagerFactoryConfiguration;
import org.wildfly.clustering.web.sso.SSOManagerFactory;

public class InfinispanSSOManagerFactoryBuilder<A, D, S>
implements CapabilityServiceBuilder<SSOManagerFactory<A, D, S, TransactionBatch>>,
Value<SSOManagerFactory<A, D, S, TransactionBatch>>,
InfinispanSSOManagerFactoryConfiguration {
    public static final String DEFAULT_CACHE_CONTAINER = "web";
    private final String name;
    private final InjectedValue<Cache> cache = new InjectedValue();
    private final CapabilityServiceBuilder<?> configurationBuilder;
    private final CapabilityServiceBuilder<?> cacheBuilder;
    private volatile ValueDependency<KeyAffinityServiceFactory> affinityFactory;

    public InfinispanSSOManagerFactoryBuilder(String name) {
        this.name = name;
        this.configurationBuilder = new TemplateConfigurationBuilder(ServiceName.parse((String)InfinispanCacheRequirement.CONFIGURATION.resolve(DEFAULT_CACHE_CONTAINER, name)), DEFAULT_CACHE_CONTAINER, name, null);
        this.cacheBuilder = new CacheBuilder(ServiceName.parse((String)InfinispanCacheRequirement.CACHE.resolve(DEFAULT_CACHE_CONTAINER, name)), DEFAULT_CACHE_CONTAINER, name);
    }

    public ServiceName getServiceName() {
        return ServiceName.JBOSS.append(new String[]{"clustering", "sso", this.name});
    }

    public Builder<SSOManagerFactory<A, D, S, TransactionBatch>> configure(CapabilityServiceSupport support) {
        this.configurationBuilder.configure(support);
        this.cacheBuilder.configure(support);
        this.affinityFactory = new InjectedValueDependency(InfinispanRequirement.KEY_AFFINITY_FACTORY.getServiceName(support, DEFAULT_CACHE_CONTAINER), KeyAffinityServiceFactory.class);
        return this;
    }

    public ServiceBuilder<SSOManagerFactory<A, D, S, TransactionBatch>> build(ServiceTarget target) {
        this.configurationBuilder.build(target).install();
        this.cacheBuilder.build(target).install();
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).addDependency(this.cacheBuilder.getServiceName(), Cache.class, this.cache);
        return this.affinityFactory.register(builder);
    }

    public SSOManagerFactory<A, D, S, TransactionBatch> getValue() {
        return new InfinispanSSOManagerFactory(this);
    }

    @Override
    public <K, V> Cache<K, V> getCache() {
        return (Cache)this.cache.getValue();
    }

    @Override
    public KeyAffinityServiceFactory getKeyAffinityServiceFactory() {
        return (KeyAffinityServiceFactory)this.affinityFactory.getValue();
    }
}

