/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.settings;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.function.Consumer;
import org.aesh.command.Command;
import org.aesh.command.CommandNotFoundHandler;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.activator.CommandActivatorProvider;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.activator.OptionActivatorProvider;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.CompleterInvocationProvider;
import org.aesh.command.converter.ConverterInvocation;
import org.aesh.command.converter.ConverterInvocationProvider;
import org.aesh.command.export.ExportChangeListener;
import org.aesh.command.impl.invocation.AeshInvocationProviders;
import org.aesh.command.impl.registry.MutableCommandRegistryImpl;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.CommandInvocationProvider;
import org.aesh.command.invocation.InvocationProviders;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.settings.FileAccessPermission;
import org.aesh.command.settings.ManProvider;
import org.aesh.command.settings.QuitHandler;
import org.aesh.command.settings.Settings;
import org.aesh.command.settings.SettingsImpl;
import org.aesh.command.validator.ValidatorInvocation;
import org.aesh.command.validator.ValidatorInvocationProvider;
import org.aesh.io.Resource;
import org.aesh.readline.AeshContext;
import org.aesh.readline.editing.EditMode;
import org.aesh.terminal.Connection;
import org.aesh.util.LoggerUtil;

public class SettingsBuilder {
    private SettingsImpl<? extends Command<? extends CommandInvocation>, ? extends CommandInvocation, ? extends ConverterInvocation, ? extends CompleterInvocation, ? extends ValidatorInvocation, ? extends OptionActivator, ? extends CommandActivator> settings;

    private SettingsBuilder apply(Consumer<SettingsBuilder> consumer) {
        consumer.accept(this);
        return this;
    }

    public static SettingsBuilder builder() {
        return new SettingsBuilder();
    }

    private SettingsBuilder() {
        this.settings = new SettingsImpl();
    }

    public SettingsBuilder(Settings<? extends Command, ? extends CommandInvocation, ? extends ConverterInvocation, ? extends CompleterInvocation, ? extends ValidatorInvocation, ? extends OptionActivator, ? extends CommandActivator> baseSettings) {
        this.settings = (SettingsImpl)baseSettings.clone();
    }

    public SettingsBuilder mode(EditMode.Mode mode) {
        return this.apply(c -> c.settings.setMode(mode));
    }

    public SettingsBuilder historyFile(File history) {
        return this.apply(c -> c.settings.setHistoryFile(history));
    }

    public SettingsBuilder historyFilePermission(FileAccessPermission fileAccessPermission) {
        return this.apply(c -> c.settings.setHistoryFilePermission(fileAccessPermission));
    }

    public SettingsBuilder historySize(int size) {
        return this.apply(c -> c.settings.setHistorySize(size));
    }

    public SettingsBuilder bellStyle(String bellStyle) {
        return this.apply(c -> c.settings.setBellStyle(bellStyle));
    }

    public SettingsBuilder inputStream(InputStream inputStream) {
        return this.apply(c -> c.settings.setStdIn(inputStream));
    }

    public SettingsBuilder outputStream(PrintStream outputStream) {
        return this.apply(c -> c.settings.setStdOut(outputStream));
    }

    public SettingsBuilder outputStreamError(PrintStream error) {
        return this.apply(c -> c.settings.setStdErr(error));
    }

    public SettingsBuilder inputrc(File inputrc) {
        return this.apply(c -> c.settings.setInputrc(inputrc));
    }

    public SettingsBuilder logging(boolean logging) {
        return this.apply(c -> c.settings.setLogging(logging));
    }

    public SettingsBuilder disableCompletion(boolean disableCompletion) {
        return this.apply(c -> c.settings.setDisableCompletion(disableCompletion));
    }

    public SettingsBuilder logfile(String logFile) {
        return this.apply(c -> c.settings.setLogFile(logFile));
    }

    public SettingsBuilder readInputrc(boolean readInputrc) {
        return this.apply(c -> c.settings.setReadInputrc(readInputrc));
    }

    public SettingsBuilder disableHistory(boolean disableHistory) {
        return this.apply(c -> c.settings.setHistoryDisabled(disableHistory));
    }

    public SettingsBuilder persistHistory(boolean persistHistory) {
        return this.apply(c -> c.settings.setHistoryPersistent(persistHistory));
    }

    public SettingsBuilder aliasFile(File aliasFile) {
        return this.apply(c -> c.settings.setAliasFile(aliasFile));
    }

    public SettingsBuilder enableAlias(boolean enableAlias) {
        return this.apply(c -> c.settings.setAliasEnabled(enableAlias));
    }

    public SettingsBuilder persistAlias(boolean persistAlias) {
        return this.apply(c -> c.settings.setPersistAlias(persistAlias));
    }

    public SettingsBuilder quitHandler(QuitHandler quitHandler) {
        return this.apply(c -> c.settings.setQuitHandler(quitHandler));
    }

    public SettingsBuilder parseOperators(boolean parseOperators) {
        return this.apply(c -> c.settings.enableOperatorParser(parseOperators));
    }

    public SettingsBuilder enableMan(boolean enableMan) {
        return this.apply(c -> c.settings.setManEnabled(enableMan));
    }

    public SettingsBuilder aeshContext(AeshContext aeshContext) {
        return this.apply(c -> c.settings.setAeshContext(aeshContext));
    }

    public SettingsBuilder enableExport(boolean enableExport) {
        return this.apply(c -> c.settings.setExportEnabled(enableExport));
    }

    public SettingsBuilder exportFile(File exportFile) {
        return this.apply(c -> c.settings.setExportFile(exportFile));
    }

    public SettingsBuilder setPersistExport(boolean persistExport) {
        return this.apply(c -> c.settings.setPersistExport(persistExport));
    }

    public SettingsBuilder setExportUsesSystemEnvironment(boolean isLoad) {
        return this.apply(c -> c.settings.setExportUsesSystemEnvironment(isLoad));
    }

    public SettingsBuilder setFileResource(Resource resource) {
        return this.apply(c -> c.settings.setResource(resource));
    }

    public SettingsBuilder setExecuteAtStart(String execute) {
        return this.apply(c -> c.settings.setExecuteAtStart(execute));
    }

    public SettingsBuilder setExecuteFileAtStart(Resource executeFile) {
        return this.apply(c -> c.settings.setExecuteFileAtStart(executeFile));
    }

    public SettingsBuilder commandActivatorProvider(CommandActivatorProvider commandActivatorProvider) {
        return this.apply(c -> c.settings.setCommandActivatorProvider(commandActivatorProvider));
    }

    public SettingsBuilder optionActivatorProvider(OptionActivatorProvider optionActivatorProvider) {
        return this.apply(c -> c.settings.setOptionActivatorProvider(optionActivatorProvider));
    }

    public SettingsBuilder commandRegistry(CommandRegistry commandRegistry) {
        return this.apply(c -> c.settings.setCommandRegistry(commandRegistry));
    }

    public SettingsBuilder commandInvocationProvider(CommandInvocationProvider commandInvocationProvider) {
        return this.apply(c -> c.settings.setCommandInvocationProvider(commandInvocationProvider));
    }

    public SettingsBuilder commandNotFoundHandler(CommandNotFoundHandler commandNotFoundHandler) {
        return this.apply(c -> c.settings.setCommandNotFoundHandler(commandNotFoundHandler));
    }

    public SettingsBuilder completerInvocationProvider(CompleterInvocationProvider completerInvocationProvider) {
        return this.apply(c -> c.settings.setCompleterInvocationProvider(completerInvocationProvider));
    }

    public SettingsBuilder converterInvocationProvider(ConverterInvocationProvider converterInvocationProvider) {
        return this.apply(c -> c.settings.setConverterInvocationProvider(converterInvocationProvider));
    }

    public SettingsBuilder validatorInvocationProvider(ValidatorInvocationProvider validatorInvocationProvider) {
        return this.apply(c -> c.settings.setValidatorInvocationProvider(validatorInvocationProvider));
    }

    public SettingsBuilder manProvider(ManProvider manProvider) {
        return this.apply(c -> c.settings.setManProvider(manProvider));
    }

    public SettingsBuilder invocationProviders(InvocationProviders invocationProviders) {
        return this.apply(c -> c.settings.setInvocationProviders(invocationProviders));
    }

    public SettingsBuilder connection(Connection connection) {
        return this.apply(c -> c.settings.setConnection(connection));
    }

    public SettingsBuilder enableOperatorParser(boolean enabled) {
        return this.apply(c -> c.settings.enableOperatorParser(enabled));
    }

    public SettingsBuilder exportListener(ExportChangeListener listener) {
        return this.apply(c -> c.settings.setExportListener(listener));
    }

    public Settings<? extends Command<? extends CommandInvocation>, ? extends CommandInvocation, ? extends ConverterInvocation, ? extends CompleterInvocation, ? extends ValidatorInvocation, ? extends OptionActivator, ? extends CommandActivator> build() {
        if (this.settings.logging()) {
            LoggerUtil.doLog();
        }
        if (this.settings.commandRegistry() == null) {
            this.settings.setCommandRegistry(new MutableCommandRegistryImpl());
        }
        if (this.settings.commandInvocationProvider() == null) {
            this.settings.setCommandInvocationProvider(commandInvocation -> commandInvocation);
        }
        if (this.settings.completerInvocationProvider() == null) {
            this.settings.setCompleterInvocationProvider(completerInvocation -> completerInvocation);
        }
        if (this.settings.converterInvocationProvider() == null) {
            this.settings.setConverterInvocationProvider(converterInvocation -> converterInvocation);
        }
        if (this.settings.validatorInvocationProvider() == null) {
            this.settings.setValidatorInvocationProvider(validatorInvocation -> validatorInvocation);
        }
        if (this.settings.optionActivatorProvider() == null) {
            this.settings.setOptionActivatorProvider(optionActivator -> optionActivator);
        }
        if (this.settings.commandActivatorProvider() == null) {
            this.settings.setCommandActivatorProvider(commandActivator -> commandActivator);
        }
        if (this.settings.invocationProviders() == null) {
            this.settings.setInvocationProviders(new AeshInvocationProviders(this.settings.converterInvocationProvider(), this.settings.completerInvocationProvider(), this.settings.validatorInvocationProvider(), this.settings.optionActivatorProvider(), this.settings.commandActivatorProvider()));
        }
        return this.settings;
    }
}

