/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.Collection;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.value.Value;

public class DelegatingServiceBuilder<T>
implements ServiceBuilder<T> {
    private final ServiceBuilder<T> delegate;

    public DelegatingServiceBuilder(ServiceBuilder<T> delegate) {
        this.delegate = delegate;
    }

    protected ServiceBuilder<T> getDelegate() {
        return this.delegate;
    }

    @Override
    public ServiceBuilder<T> addAliases(ServiceName ... aliases) {
        this.getDelegate().addAliases(aliases);
        return this;
    }

    @Override
    public ServiceBuilder<T> setInitialMode(ServiceController.Mode mode) {
        this.getDelegate().setInitialMode(mode);
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependencies(ServiceName ... dependencies) {
        this.getDelegate().addDependencies(dependencies);
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependencies(ServiceBuilder.DependencyType dependencyType, ServiceName ... dependencies) {
        this.getDelegate().addDependencies(dependencyType, dependencies);
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependencies(Iterable<ServiceName> dependencies) {
        this.getDelegate().addDependencies(dependencies);
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependencies(ServiceBuilder.DependencyType dependencyType, Iterable<ServiceName> dependencies) {
        this.getDelegate().addDependencies(dependencyType, dependencies);
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependency(ServiceName dependency) {
        this.getDelegate().addDependency(dependency);
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency) {
        this.getDelegate().addDependency(dependencyType, dependency);
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependency(ServiceName dependency, Injector<Object> target) {
        this.getDelegate().addDependency(dependency, target);
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency, Injector<Object> target) {
        this.getDelegate().addDependency(dependencyType, dependency, target);
        return this;
    }

    @Override
    public <I> ServiceBuilder<T> addDependency(ServiceName dependency, Class<I> type, Injector<I> target) {
        this.getDelegate().addDependency(dependency, type, target);
        return this;
    }

    @Override
    public <I> ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency, Class<I> type, Injector<I> target) {
        this.getDelegate().addDependency(dependencyType, dependency, type, target);
        return this;
    }

    @Override
    public <I> ServiceBuilder<T> addInjection(Injector<? super I> target, I value) {
        this.getDelegate().addInjection(target, value);
        return this;
    }

    @Override
    public <I> ServiceBuilder<T> addInjectionValue(Injector<? super I> target, Value<I> value) {
        this.getDelegate().addInjectionValue(target, value);
        return this;
    }

    @Override
    public ServiceBuilder<T> addInjection(Injector<? super T> target) {
        this.getDelegate().addInjection(target);
        return this;
    }

    @Override
    public ServiceBuilder<T> addMonitor(StabilityMonitor monitor) {
        this.getDelegate().addMonitor(monitor);
        return this;
    }

    @Override
    public ServiceBuilder<T> addMonitors(StabilityMonitor ... monitors) {
        this.getDelegate().addMonitors(monitors);
        return this;
    }

    @Override
    @Deprecated
    public ServiceBuilder<T> addListener(ServiceListener<? super T> listener) {
        this.getDelegate().addListener(listener);
        return this;
    }

    @Override
    @Deprecated
    public ServiceBuilder<T> addListener(ServiceListener<? super T> ... listeners) {
        this.getDelegate().addListener(listeners);
        return this;
    }

    @Override
    public ServiceBuilder<T> addListener(LifecycleListener listener) {
        this.delegate.addListener(listener);
        return this;
    }

    @Override
    @Deprecated
    public ServiceBuilder<T> addListener(Collection<? extends ServiceListener<? super T>> listeners) {
        this.getDelegate().addListener(listeners);
        return this;
    }

    @Override
    public ServiceController<T> install() throws ServiceRegistryException {
        return this.getDelegate().install();
    }
}

