/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.session;

import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.web.session.RoutingSupport;
import org.jboss.as.web.session.SessionIdentifierCodec;
import org.jboss.as.web.session.SimpleRoutingSupport;
import org.jboss.as.web.session.SimpleSessionIdentifierCodec;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.MappedValueService;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.extension.undertow.Server;

public class SimpleSessionIdentifierCodecBuilder
implements CapabilityServiceBuilder<SessionIdentifierCodec> {
    private final ServiceName name;
    private final String serverName;
    private final RoutingSupport routing = new SimpleRoutingSupport();
    private volatile ValueDependency<Server> server;

    public SimpleSessionIdentifierCodecBuilder(ServiceName name, String serverName) {
        this.name = name;
        this.serverName = serverName;
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public Builder<SessionIdentifierCodec> configure(CapabilityServiceSupport support) {
        this.server = new InjectedValueDependency(support.getCapabilityServiceName("org.wildfly.undertow.server", new String[]{this.serverName}), Server.class);
        return this;
    }

    public ServiceBuilder<SessionIdentifierCodec> build(ServiceTarget target) {
        MappedValueService service = new MappedValueService(server -> new SimpleSessionIdentifierCodec(this.routing, server.getRoute()), this.server);
        return this.server.register(target.addService(this.name, (Service)service)).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }
}

