/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.jca;

import com.arjuna.ats.jbossatx.jta.TransactionManagerService;
import org.jboss.as.connector.services.bootstrap.BootStrapContextService;
import org.jboss.as.connector.services.bootstrap.NamedBootstrapContext;
import org.jboss.as.connector.subsystems.jca.JcaBootstrapContextDefinition;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemConfiguration;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.txn.integration.JBossContextXATerminator;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.api.bootstrap.CloneableBootstrapContext;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

public class BootstrapContextAdd
extends AbstractAddStepHandler {
    public static final BootstrapContextAdd INSTANCE = new BootstrapContextAdd();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (JcaBootstrapContextDefinition.BootstrapCtxParameters parameter : JcaBootstrapContextDefinition.BootstrapCtxParameters.values()) {
            parameter.getAttribute().validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        NamedBootstrapContext ctx;
        String name = JcaBootstrapContextDefinition.BootstrapCtxParameters.NAME.getAttribute().resolveModelAttribute(context, model).asString();
        String workmanager = JcaBootstrapContextDefinition.BootstrapCtxParameters.WORKMANAGER.getAttribute().resolveModelAttribute(context, model).asString();
        boolean usingDefaultWm = false;
        if ("default".equals(workmanager)) {
            usingDefaultWm = true;
            ctx = new NamedBootstrapContext(name);
        } else {
            ctx = new NamedBootstrapContext(name, workmanager);
        }
        ServiceTarget serviceTarget = context.getServiceTarget();
        BootStrapContextService bootCtxService = new BootStrapContextService((CloneableBootstrapContext)ctx, name, usingDefaultWm);
        serviceTarget.addService(ConnectorServices.BOOTSTRAP_CONTEXT_SERVICE.append(new String[]{name}), (Service)bootCtxService).addDependency(ServiceBuilder.DependencyType.REQUIRED, ConnectorServices.WORKMANAGER_SERVICE.append(new String[]{workmanager}), WorkManager.class, bootCtxService.getWorkManagerValueInjector()).addDependency(TxnServices.JBOSS_TXN_CONTEXT_XA_TERMINATOR, JBossContextXATerminator.class, bootCtxService.getXaTerminatorInjector()).addDependency(TxnServices.JBOSS_TXN_ARJUNA_TRANSACTION_MANAGER, TransactionManagerService.class, bootCtxService.getTxManagerInjector()).addDependency(ConnectorServices.CONNECTOR_CONFIG_SERVICE, JcaSubsystemConfiguration.class, bootCtxService.getJcaConfigInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }
}

