/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.JBossLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;

public class JBossLogFactory
extends LogFactory {
    private static final Collection<String> UNSUPPORTED_PROPERTIES = Arrays.asList("org.apache.commons.org.apache.commons.logging.LogFactory", "org.apache.commons.org.apache.commons.logging.Log", "org.apache.commons.org.apache.commons.logging.log");
    private static final Logger.AttachmentKey<Log> LOG_KEY = new Logger.AttachmentKey();
    private static final Logger.AttachmentKey<Map<String, Object>> ATTRIBUTE_KEY = new Logger.AttachmentKey();
    private final Logger logger = Logger.getLogger((String)JBossLogFactory.class.getPackage().getName());

    @Override
    public Object getAttribute(String name) {
        return this.getAttributeMap().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAttributeNames() {
        String[] names;
        Map<String, Object> attributes;
        Map<String, Object> map = attributes = this.getAttributeMap();
        synchronized (map) {
            Set<String> s = attributes.keySet();
            names = s.toArray(new String[s.size()]);
        }
        return names;
    }

    @Override
    public Log getInstance(Class clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    @Override
    public Log getInstance(String name) throws LogConfigurationException {
        Log log = (Log)LogContext.getLogContext().getAttachment(name, LOG_KEY);
        if (log != null) {
            return log;
        }
        Logger logger = Logger.getLogger((String)name);
        Log appearing = (Log)logger.attachIfAbsent(LOG_KEY, (Object)(log = new JBossLog(logger)));
        if (appearing != null) {
            log = appearing;
        }
        return log;
    }

    @Override
    public void release() {
        this.getAttributeMap().clear();
    }

    @Override
    public void removeAttribute(String name) {
        this.getAttributeMap().remove(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        Map<String, Object> attributes = this.getAttributeMap();
        if (value == null) {
            attributes.remove(name);
        } else if (!(value instanceof String)) {
            this.logger.log((java.util.logging.Level)Level.WARN, String.format("Attribute values must be of type java.lang.String. Attribute %s with value %s will be ignored.", name, value));
        } else if (UNSUPPORTED_PROPERTIES.contains(name)) {
            this.logger.log((java.util.logging.Level)Level.WARN, String.format("Attribute %s is not supported. Value %s will be ignored.", name, value));
        } else {
            attributes.put(name, value);
        }
    }

    private Map<String, Object> getAttributeMap() {
        Map appearing;
        Logger rootLogger = Logger.getLogger((String)"");
        Map map = (Map)rootLogger.getAttachment(ATTRIBUTE_KEY);
        if (map == null && (appearing = (Map)rootLogger.attachIfAbsent(ATTRIBUTE_KEY, map = Collections.synchronizedMap(new HashMap()))) != null) {
            map = appearing;
        }
        return map;
    }
}

